/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class ServerEachTickTaskManager {
    private static Map<String, EachTickTask> activeTasks = new HashMap<String, EachTickTask>();
    private static final Map<String, Object> saveValue = new HashMap<String, Object>();
    private static boolean initialized = false;

    public static void scheduleTask(String taskId, int tickCount, int interval, Runnable callback) {
        activeTasks.put(taskId, new EachTickTask(tickCount, interval, callback));
    }

    public static void scheduleTask(int tickCount, int interval, Runnable callback) {
        ServerEachTickTaskManager.scheduleTask(UUID.randomUUID().toString(), tickCount, interval, callback);
    }

    public static void scheduleTask(int interval, Runnable runnable) {
        ServerEachTickTaskManager.scheduleTask(UUID.randomUUID().toString(), -1, interval, runnable);
    }

    public static void addSaveValue(String str, Object o) {
        saveValue.put(str, o);
    }

    public static Object getSaveValue(String str) {
        return saveValue.getOrDefault(str, null);
    }

    public static void init() {
        if (!initialized) {
            ServerTickEvents.END_SERVER_TICK.register(server -> {
                Iterator<Map.Entry<String, EachTickTask>> iterator = activeTasks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, EachTickTask> entry = iterator.next();
                    EachTickTask task = entry.getValue();
                    task.tick();
                    if (!task.getCompleted()) continue;
                    Object need_remove = saveValue.getOrDefault(entry.getKey(), null);
                    if (need_remove != null) {
                        saveValue.remove(entry.getKey());
                    }
                    iterator.remove();
                }
            });
            initialized = true;
        }
    }

    public static class EachTickTask {
        public int tickCount;
        public int interval;
        public Runnable callback;
        public boolean completed;
        public int eachTickCount = MAX_EACH_TICK_COUNT;
        public static int MAX_EACH_TICK_COUNT = 72000;

        public EachTickTask(int tickCount, int interval, Runnable callback) {
            this.tickCount = tickCount;
            this.interval = interval;
            this.callback = callback;
            this.completed = false;
        }

        public EachTickTask(int interval, Runnable callback) {
            this(-1, interval, callback);
        }

        public EachTickTask(Runnable callback) {
            this(-1, 20, callback);
        }

        public void tick() {
            if (this.completed) {
                return;
            }
            if (this.tickCount > -1) {
                if (this.tickCount % this.interval == 0) {
                    this.callback.run();
                }
                --this.tickCount;
                if (this.tickCount <= 0) {
                    this.setCompleted(true);
                }
            } else {
                if (this.eachTickCount % this.interval == 0) {
                    this.callback.run();
                }
                --this.eachTickCount;
                if (this.eachTickCount <= 0) {
                    this.eachTickCount = MAX_EACH_TICK_COUNT;
                }
            }
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public boolean getCompleted() {
            return this.completed;
        }
    }
}

