/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.animation.config.utils;

import com.soybeani.animation.AnimationOverhaul;
import com.soybeani.animation.config.AnimationsConfig;
import com.soybeani.animation.config.PlayerConfig;
import com.soybeani.animation.config.utils.IAnimConfig;
import com.soybeani.config.InitValue;
import java.nio.file.Path;

public class ConfigLoader {
    public static boolean checkOutdated(Object[] configs) {
        for (Object config : configs) {
            IAnimConfig aconfig;
            if (!(config instanceof IAnimConfig) || !(aconfig = (IAnimConfig)config).isOutdated()) continue;
            ConfigLoader.updateConfig(aconfig.getFolder(), aconfig.getFileName());
            return true;
        }
        return false;
    }

    public static void reloadConfigs() {
        ConfigLoader.registerConfigs();
        AnimationOverhaul.ANIM_CONFIG = AnimationsConfig.INSTANCE;
        AnimationOverhaul.LOCAL_PLAYER_CONFIG = PlayerConfig.INSTANCE;
        if (AnimationsConfig.INSTANCE.isOutdated()) {
            InitValue.LOGGER.warn(String.format("The 'animations' Animation Overhaul config is outdated! It has been updated to the latest version and renamed to animation-old.json5", new Object[0]));
        }
        if (PlayerConfig.INSTANCE.isOutdated()) {
            InitValue.LOGGER.warn(String.format("The 'local_player' Animation Overhaul config is outdated! It has been updated to the latest version and renamed to local_player-old.json5", new Object[0]));
        }
    }

    public static void registerConfigs() {
        AnimationsConfig.INSTANCE = new AnimationsConfig();
        PlayerConfig.INSTANCE = new PlayerConfig();
    }

    public static void updateConfig(String FOLDER, String FILE_NAME) {
        Path folder = Path.of(FOLDER, new String[0]);
        if (!folder.toFile().exists()) {
            folder.toFile().mkdirs();
        }
        String oldFile = folder.toString() + "/" + FILE_NAME;
        String newFile = folder.toString() + "/" + FILE_NAME + ".old";
        Path oldPath = Path.of(oldFile, new String[0]);
        Path newPath = Path.of(newFile, new String[0]);
        if (oldPath.toFile().exists()) {
            oldPath.toFile().renameTo(newPath.toFile());
        }
    }
}

