/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.block.entity;

import com.soybeani.block.ModBlock;
import com.soybeani.block.custom.TTBlock;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1540;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class TTEntity
extends class_1297
implements class_8046 {
    private static final class_2940<Integer> FUSE = class_2945.method_12791(TTEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2680> BLOCK_STATE = class_2945.method_12791(TTEntity.class, (class_2941)class_2943.field_13312);
    private static final int DEFAULT_FUSE = 80;
    private static final String BLOCK_STATE_NBT_KEY = "block_state";
    public static final String FUSE_NBT_KEY = "fuse";
    private static final float EXPLOSION_RADIUS = 4.0f;
    private static final int CHAIN_FUSE = 20;
    private static final class_5362 TELEPORTED_EXPLOSION_BEHAVIOR = new class_5362(){

        public boolean method_29554(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float power) {
            if (state.method_27852(class_2246.field_10316)) {
                return false;
            }
            return super.method_29554(explosion, world, pos, state, power);
        }

        public Optional<Float> method_29555(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
            if (blockState.method_27852(class_2246.field_10316)) {
                return Optional.empty();
            }
            return super.method_29555(explosion, world, pos, blockState, fluidState);
        }
    };
    private class_1309 causingEntity;

    public TTEntity(class_1299<? extends TTEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
    }

    public TTEntity(class_1937 world, double x, double y, double z, class_1309 igniter) {
        this(ModBlock.TT_ENTITY, world);
        this.method_5814(x, y, z);
        double d = world.field_9229.method_43058() * 6.2831854820251465;
        this.method_18800(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.setFuse(80);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.causingEntity = igniter;
    }

    public TTEntity(class_1937 world, double x, double y, double z, @Nullable class_1309 igniter, boolean chain) {
        this(ModBlock.TT_ENTITY, world);
        this.method_5814(x, y, z);
        double d = world.field_9229.method_43058() * 6.2831854820251465;
        this.method_18800(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.setFuse(chain ? 20 : 80);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FUSE, (Object)80);
        builder.method_56912(BLOCK_STATE, (Object)class_2246.field_10375.method_9564());
    }

    public int getFuse() {
        return (Integer)this.field_6011.method_12789(FUSE);
    }

    public void setFuse(int fuse) {
        this.field_6011.method_12778(FUSE, (Object)fuse);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10575("Fuse", (short)this.getFuse());
    }

    protected void method_5749(class_2487 nbt) {
        this.setFuse(nbt.method_10568("Fuse"));
    }

    public void method_5773() {
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }
        int currentFuse = this.getFuse() - 1;
        this.setFuse(currentFuse);
        if (currentFuse <= 0) {
            this.method_31472();
            if (!this.method_37908().field_9236) {
                this.explode();
            }
        } else {
            this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            class_243 explosionPos = this.method_19538();
            class_238 explosionBox = new class_238(explosionPos.field_1352 - 4.0, explosionPos.field_1351 - 4.0, explosionPos.field_1350 - 4.0, explosionPos.field_1352 + 4.0, explosionPos.field_1351 + 4.0, explosionPos.field_1350 + 4.0);
            class_2338.method_10097((class_2338)new class_2338((int)explosionBox.field_1323, (int)explosionBox.field_1322, (int)explosionBox.field_1321), (class_2338)new class_2338((int)explosionBox.field_1320, (int)explosionBox.field_1325, (int)explosionBox.field_1324)).forEach(pos -> {
                class_2680 state = world.method_8320(pos);
                if (state.method_26204() instanceof TTBlock) {
                    TTBlock.primeTnt(world, pos, true);
                    world.method_8650(pos, false);
                }
            });
            class_2338.method_10097((class_2338)new class_2338((int)explosionBox.field_1323, (int)explosionBox.field_1322, (int)explosionBox.field_1321), (class_2338)new class_2338((int)explosionBox.field_1320, (int)explosionBox.field_1325, (int)explosionBox.field_1324)).forEach(pos -> {
                class_2680 state = world.method_8320(pos);
                if (!state.method_26215() && !state.method_51176()) {
                    class_243 blockCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                    class_243 direction = blockCenter.method_1020(explosionPos).method_1029();
                    double distance = blockCenter.method_1022(explosionPos);
                    double power = Math.max(0.5, (4.0 - distance) / 4.0 * 2.0);
                    class_1540 fallingBlock = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)state);
                    if (fallingBlock != null) {
                        fallingBlock.method_5814(blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350);
                        double randomX = (world.field_9229.method_43058() - 0.5) * 0.2;
                        double randomY = (world.field_9229.method_43058() - 0.5) * 0.2;
                        double randomZ = (world.field_9229.method_43058() - 0.5) * 0.2;
                        fallingBlock.method_18800(direction.field_1352 * power + randomX, direction.field_1351 * power + 0.8 + randomY, direction.field_1350 * power + randomZ);
                        fallingBlock.field_6037 = true;
                        world.method_8650(pos, false);
                    }
                }
            });
            List entities = world.method_8335((class_1297)this, explosionBox);
            for (class_1297 entity : entities) {
                class_243 entityPos = entity.method_19538();
                class_243 direction = entityPos.method_1020(explosionPos).method_1029();
                double distance = entityPos.method_1022(explosionPos);
                double power = Math.max(0.5, (4.0 - distance) / 4.0 * 2.0);
                if (entity instanceof TTEntity) {
                    power *= 1.5;
                }
                double randomX = (world.field_9229.method_43058() - 0.5) * 0.2;
                double randomY = (world.field_9229.method_43058() - 0.5) * 0.2;
                double randomZ = (world.field_9229.method_43058() - 0.5) * 0.2;
                class_243 velocity = new class_243(direction.field_1352 * power + randomX, direction.field_1351 * power + 0.8 + randomY, direction.field_1350 * power + randomZ);
                entity.method_18799(velocity);
                entity.field_6037 = true;
                if (!(entity instanceof TTEntity)) continue;
                TTEntity ttEntity = (TTEntity)entity;
                if (!(distance <= 2.0)) continue;
                ttEntity.setFuse(20);
            }
            world.method_60511(null, explosionPos.field_1352, explosionPos.field_1351, explosionPos.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
            for (int i = 0; i < 50; ++i) {
                double px = explosionPos.field_1352 + (world.field_9229.method_43058() - 0.5) * 4.0 * 2.0;
                double py = explosionPos.field_1351 + (world.field_9229.method_43058() - 0.5) * 4.0 * 2.0;
                double pz = explosionPos.field_1350 + (world.field_9229.method_43058() - 0.5) * 4.0 * 2.0;
                world.method_8406((class_2394)class_2398.field_11236, px, py, pz, 0.0, 0.0, 0.0);
            }
        }
        this.method_31472();
    }

    public class_2680 getBlockState() {
        return ModBlock.TT_BLOCK.method_9564();
    }

    @Nullable
    public class_1297 method_24921() {
        return this.causingEntity;
    }
}

