/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.custom.CopperCoinEntity;
import com.soybeani.items.ItemsRegister;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_9331;

public class CopperSwordItem
extends class_1792 {
    private static final class_9331<Integer> MODE = ComponentTypeRegister.COMMON_INTEGER;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_FAN = 1;
    private static final int MODE_RAIN = 2;
    private static final int MODE_TORNADO = 3;
    private static final int MAX_MODE = 3;

    public CopperSwordItem(class_1792.class_1793 settings) {
        super(settings.method_57349(MODE, (Object)0));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stackInHand = user.method_5998(hand);
        if (!world.field_9236) {
            int currentMode = (Integer)stackInHand.method_57824(MODE);
            if (user.method_5715()) {
                int newMode = (currentMode + 1) % 4;
                stackInHand.method_57379(MODE, (Object)newMode);
                String modeName = CopperSwordItem.getModeName(newMode);
                user.method_7353((class_2561)class_2561.method_43470((String)("\u94dc\u5251\u6a21\u5f0f\u5207\u6362\u4e3a: " + modeName)), true);
                return class_1271.method_22427((Object)stackInHand);
            }
            switch (currentMode) {
                case 0: {
                    return this.fireNormalMode(world, user, hand, stackInHand);
                }
                case 1: {
                    return this.fireFanMode(world, user, hand, stackInHand);
                }
                case 2: {
                    return this.fireRainMode(world, user, hand, stackInHand);
                }
                case 3: {
                    return this.fireTornadoMode(world, user, hand, stackInHand);
                }
            }
            return class_1271.method_22430((Object)stackInHand);
        }
        return class_1271.method_22427((Object)stackInHand);
    }

    public static void switchMode(class_1657 player, class_1799 stackInHand) {
        int currentMode = (Integer)stackInHand.method_57824(MODE);
        int newMode = (currentMode + 1) % 4;
        stackInHand.method_57379(MODE, (Object)newMode);
        String modeName = CopperSwordItem.getModeName(newMode);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u94dc\u5251\u6a21\u5f0f\u5207\u6362\u4e3a: " + modeName)), true);
    }

    private static String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "\u666e\u901a\u6a21\u5f0f";
            }
            case 1: {
                return "\u6247\u5f62\u6a21\u5f0f";
            }
            case 2: {
                return "\u94dc\u5e01\u96e8\u6a21\u5f0f";
            }
            case 3: {
                return "\u6492\u5e01\u6a21\u5f0f";
            }
        }
        return "\u672a\u77e5\u6a21\u5f0f";
    }

    private class_1271<class_1799> fireNormalMode(class_1937 world, class_1657 user, class_1268 hand, class_1799 stackInHand) {
        int coinSlot = this.findCopperCoinInInventory(user);
        if (coinSlot != -1) {
            class_1661 inventory = user.method_31548();
            class_1799 coinStack = inventory.method_5438(coinSlot);
            CopperCoinEntity coinEntity = new CopperCoinEntity(world, (class_1309)user);
            coinEntity.method_16940(coinStack);
            coinEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.5f, 1.0f);
            world.method_8649((class_1297)coinEntity);
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
            if (!user.method_31549().field_7477) {
                coinStack.method_7934(1);
                if (coinStack.method_7960()) {
                    inventory.method_5447(coinSlot, class_1799.field_8037);
                }
            }
            return class_1271.method_22427((Object)stackInHand);
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14701, class_3419.field_15254, 0.5f, 1.0f);
        return class_1271.method_22431((Object)stackInHand);
    }

    private class_1271<class_1799> fireFanMode(class_1937 world, class_1657 user, class_1268 hand, class_1799 stackInHand) {
        int coinCount = this.countCopperCoinsInInventory(user);
        if (coinCount >= 7 || user.method_31549().field_7477) {
            int coinsToFire = Math.min(7, coinCount);
            int coinsConsumed = 0;
            float baseYaw = user.method_36454();
            float basePitch = user.method_36455();
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.8f, 0.6f);
            for (int i = 0; i < coinsToFire; ++i) {
                float yawOffset = (float)(i - 3) * 10.0f;
                if (!user.method_31549().field_7477) {
                    int coinSlot = this.findCopperCoinInInventory(user);
                    if (coinSlot == -1) break;
                    class_1661 inventory = user.method_31548();
                    class_1799 coinStack = inventory.method_5438(coinSlot);
                    CopperCoinEntity coinEntity = new CopperCoinEntity(world, (class_1309)user);
                    coinEntity.method_16940(coinStack);
                    coinEntity.method_24919((class_1297)user, basePitch, baseYaw + yawOffset, 0.0f, 1.5f, 0.5f);
                    world.method_8649((class_1297)coinEntity);
                    coinStack.method_7934(1);
                    if (coinStack.method_7960()) {
                        inventory.method_5447(coinSlot, class_1799.field_8037);
                    }
                    ++coinsConsumed;
                    continue;
                }
                CopperCoinEntity coinEntity = new CopperCoinEntity(world, (class_1309)user);
                coinEntity.method_16940(ItemsRegister.COPPER_COIN.method_7854());
                coinEntity.method_24919((class_1297)user, basePitch, baseYaw + yawOffset, 0.0f, 1.5f, 0.5f);
                world.method_8649((class_1297)coinEntity);
            }
            user.method_7357().method_7906((class_1792)this, 10);
            return class_1271.method_22427((Object)stackInHand);
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14701, class_3419.field_15254, 0.5f, 1.0f);
        user.method_7353((class_2561)class_2561.method_43470((String)"\u9700\u8981\u81f3\u5c117\u4e2a\u94dc\u5e01\u624d\u80fd\u4f7f\u7528\u6247\u5f62\u6a21\u5f0f\uff01"), true);
        return class_1271.method_22431((Object)stackInHand);
    }

    private class_1271<class_1799> fireRainMode(class_1937 world, class_1657 user, class_1268 hand, class_1799 stackInHand) {
        int coinCount = this.countCopperCoinsInInventory(user);
        if (coinCount >= 64 || user.method_31549().field_7477) {
            class_239 hitResult = user.method_5745(50.0, 0.0f, false);
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                class_2338 targetPos = ((class_3965)hitResult).method_17777();
                class_2338 rainPos = targetPos.method_10086(20);
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14865, class_3419.field_15252, 0.6f, 1.0f);
                String taskId = UUID.randomUUID().toString();
                int[] coinsDropped = new int[]{0};
                class_5819 random = world.method_8409();
                ServerEachTickTaskManager.scheduleTask(taskId, 100, 2, () -> {
                    int coinsToSpawn = random.method_39332(2, 4);
                    for (int i = 0; i < coinsToSpawn; ++i) {
                        int xOffset = random.method_39332(-5, 5);
                        int zOffset = random.method_39332(-5, 5);
                        CopperCoinEntity coinEntity = new CopperCoinEntity(world, rainPos.method_10263() + xOffset, rainPos.method_10264(), rainPos.method_10260() + zOffset);
                        coinEntity.method_16940(ItemsRegister.COPPER_COIN.method_7854());
                        coinEntity.method_18800(0.0, -0.2, 0.0);
                        world.method_8649((class_1297)coinEntity);
                        coinsDropped[0] = coinsDropped[0] + 1;
                    }
                    if ((double)random.method_43057() < 0.3) {
                        world.method_43128(null, (double)rainPos.method_10263(), (double)rainPos.method_10264(), (double)rainPos.method_10260(), class_3417.field_24061, class_3419.field_15254, 0.4f, 0.8f + random.method_43057() * 0.4f);
                    }
                });
                if (!user.method_31549().field_7477) {
                    this.consumeCoins(user, 64);
                }
                user.method_7357().method_7906((class_1792)this, 20);
                return class_1271.method_22427((Object)stackInHand);
            }
            user.method_7353((class_2561)class_2561.method_43470((String)"\u8bf7\u6307\u5411\u4e00\u4e2a\u6709\u6548\u7684\u65b9\u5757\u4f4d\u7f6e\uff01"), true);
            return class_1271.method_22431((Object)stackInHand);
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14701, class_3419.field_15254, 0.5f, 1.0f);
        user.method_7353((class_2561)class_2561.method_43470((String)"\u9700\u8981\u81f3\u5c1164\u4e2a\u94dc\u5e01\u624d\u80fd\u4f7f\u7528\u94dc\u5e01\u96e8\u6a21\u5f0f\uff01"), true);
        return class_1271.method_22431((Object)stackInHand);
    }

    private class_1271<class_1799> fireTornadoMode(class_1937 world, class_1657 user, class_1268 hand, class_1799 stackInHand) {
        int coinCount = this.countCopperCoinsInInventory(user);
        if (coinCount >= 32 || user.method_31549().field_7477) {
            class_243 userPos = user.method_33571();
            class_243 lookDir = user.method_5720();
            class_243 tornadoStartPos = userPos.method_1019(lookDir.method_1021(3.0));
            class_243 horizontalLookDir = new class_243(lookDir.field_1352, 0.0, lookDir.field_1350).method_1029();
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14671, class_3419.field_15254, 0.5f, 1.5f);
            String taskId = UUID.randomUUID().toString();
            int[] coinsUsed = new int[]{0};
            int[] tickCount = new int[]{0};
            class_5819 random = world.method_8409();
            class_243[] tornadoBasePos = new class_243[]{tornadoStartPos};
            ServerEachTickTaskManager.scheduleTask(taskId, 160, 1, () -> {
                double heightPercent;
                int i;
                tickCount[0] = tickCount[0] + 1;
                if (tickCount[0] % 10 == 0) {
                    tornadoBasePos[0] = tornadoBasePos[0].method_1019(horizontalLookDir.method_1021(1.5));
                }
                int coinsToSpawn = random.method_39332(2, 4);
                double tornadoHeight = 10.0;
                for (i = 0; i < coinsToSpawn; ++i) {
                    heightPercent = random.method_43058();
                    double maxRadius = 2.5;
                    double minRadius = 0.5;
                    double radius = maxRadius * (1.0 - heightPercent) + minRadius * heightPercent;
                    double angleSpeed = 15.0 - heightPercent * 5.0;
                    double angle = ((double)tickCount[0] * angleSpeed + (double)(i * 90)) * Math.PI / 180.0;
                    double x = tornadoBasePos[0].field_1352 + Math.cos(angle) * radius;
                    double y = tornadoBasePos[0].field_1351 + tornadoHeight * heightPercent;
                    double z = tornadoBasePos[0].field_1350 + Math.sin(angle) * radius;
                    CopperCoinEntity coinEntity = new CopperCoinEntity(world, x, y, z);
                    coinEntity.method_16940(ItemsRegister.COPPER_COIN.method_7854());
                    double speedFactor = 0.2 + heightPercent * 0.3;
                    double vx = Math.cos(angle + 1.5707963267948966) * speedFactor;
                    double vy = 0.05 + heightPercent * 0.1;
                    double vz = Math.sin(angle + 1.5707963267948966) * speedFactor;
                    coinEntity.method_18800(vx, vy, vz);
                    world.method_8649((class_1297)coinEntity);
                    if ((double)random.method_43057() < 0.3) {
                        world.method_8406((class_2394)class_2398.field_11204, x, y, z, vx * 0.2, vy * 0.1, vz * 0.2);
                    }
                    coinsUsed[0] = coinsUsed[0] + 1;
                }
                if (tickCount[0] % 10 == 0) {
                    world.method_43128(null, tornadoBasePos[0].field_1352, tornadoBasePos[0].field_1351, tornadoBasePos[0].field_1350, class_3417.field_14869, class_3419.field_15254, 0.8f, 0.5f + random.method_43057() * 0.5f);
                }
                if (tickCount[0] % 5 == 0) {
                    for (i = 0; i < 10; ++i) {
                        heightPercent = random.method_43058();
                        double height = tornadoHeight * heightPercent;
                        double radius = 2.0 * (1.0 - heightPercent) + 0.5 * heightPercent;
                        double angle = random.method_43058() * 2.0 * Math.PI;
                        double x = tornadoBasePos[0].field_1352 + Math.cos(angle) * radius;
                        double y = tornadoBasePos[0].field_1351 + height;
                        double z = tornadoBasePos[0].field_1350 + Math.sin(angle) * radius;
                        world.method_8406((class_2394)class_2398.field_11204, x, y, z, ((double)random.method_43057() - 0.5) * 0.2, (double)random.method_43057() * 0.2, ((double)random.method_43057() - 0.5) * 0.2);
                    }
                }
            });
            if (!user.method_31549().field_7477) {
                this.consumeCoins(user, 32);
            }
            user.method_7357().method_7906((class_1792)this, 100);
            return class_1271.method_22427((Object)stackInHand);
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14701, class_3419.field_15254, 0.5f, 1.0f);
        user.method_7353((class_2561)class_2561.method_43470((String)"\u9700\u8981\u81f3\u5c1132\u4e2a\u94dc\u5e01\u624d\u80fd\u4f7f\u7528\u6492\u5e01\u6a21\u5f0f\uff01"), true);
        return class_1271.method_22431((Object)stackInHand);
    }

    private int findCopperCoinInInventory(class_1657 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !stack.method_31574(ItemsRegister.COPPER_COIN)) continue;
            return i;
        }
        return -1;
    }

    private int countCopperCoinsInInventory(class_1657 player) {
        class_1661 inventory = player.method_31548();
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !stack.method_31574(ItemsRegister.COPPER_COIN)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private void consumeCoins(class_1657 player, int amount) {
        if (player.method_31549().field_7477) {
            return;
        }
        class_1661 inventory = player.method_31548();
        int remaining = amount;
        for (int i = 0; i < inventory.method_5439() && remaining > 0; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !stack.method_31574(ItemsRegister.COPPER_COIN)) continue;
            int toRemove = Math.min(remaining, stack.method_7947());
            stack.method_7934(toRemove);
            remaining -= toRemove;
            if (!stack.method_7960()) continue;
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (target.method_37908().field_9236) {
            return super.method_7873(stack, target, attacker);
        }
        class_2338 blockPos = target.method_24515();
        class_1542 itemEntity = new class_1542(target.method_37908(), (double)blockPos.method_10263(), (double)(blockPos.method_10264() + 1), (double)blockPos.method_10260(), ItemsRegister.COPPER_COIN.method_7854());
        itemEntity.method_6982(10);
        target.method_37908().method_8649((class_1297)itemEntity);
        return true;
    }
}

