/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.GourdHelmetRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_572;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GourdHelmetItem
extends class_1738
implements GeoItem {
    private static final class_9331<Float> sizeKey = ComponentTypeRegister.COMMON_FLOAT;
    private static final class_9331<Boolean> isInvincible = ComponentTypeRegister.COMMON_BOOL;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final int color;
    public static final int TYPE_R = 0;
    public static final int TYPE_V = 1;

    public GourdHelmetItem(class_1792.class_1793 settings, int color) {
        super(class_1740.field_7889, class_1738.class_8051.field_41934, settings);
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        class_1799 equippedStack;
        class_1792 class_17922;
        if (entity instanceof class_1657 && (class_17922 = (equippedStack = (player = (class_1657)entity).method_6118(class_1304.field_6169)).method_7909()) instanceof GourdHelmetItem) {
            GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public static void handleRedColor(class_1657 player, int type) {
        class_1792 class_17922 = player.method_6118(class_1304.field_6169).method_7909();
        if (class_17922 instanceof GourdHelmetItem) {
            GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
            class_1799 equippedStack = player.method_6118(class_1304.field_6169);
            if (gourdHelmetItem.getColor() == COLOR.RED.getColor()) {
                if (type == 0) {
                    GourdHelmetItem.setSize(equippedStack, GourdHelmetItem.getSize(equippedStack) + 0.05f);
                } else if (type == 1) {
                    GourdHelmetItem.setSize(equippedStack, GourdHelmetItem.getSize(equippedStack) - 0.05f);
                }
            }
        }
    }

    public static void handleYellowColor(class_1657 player) {
        class_1792 class_17922 = player.method_6118(class_1304.field_6169).method_7909();
        if (class_17922 instanceof GourdHelmetItem) {
            GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
            class_1799 equippedStack = player.method_6118(class_1304.field_6169);
            if (gourdHelmetItem.getColor() == COLOR.YELLOW.getColor()) {
                boolean invincible = GourdHelmetItem.getInvincible(equippedStack) == false;
                player.method_5684(invincible);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u91d1\u521a\u4e0d\u574f: " + (invincible ? "\u5f00\u542f" : "\u5173\u95ed"))), true);
                GourdHelmetItem.setInvincible(equippedStack, invincible);
            }
        }
    }

    public static void handleYellowWearDamage(class_1657 player) {
        class_1792 class_17922 = player.method_6118(class_1304.field_6169).method_7909();
        if (class_17922 instanceof GourdHelmetItem) {
            boolean invincible;
            GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
            class_1799 equippedStack = player.method_6118(class_1304.field_6169);
            if (gourdHelmetItem.getColor() == COLOR.YELLOW.getColor() && (invincible = GourdHelmetItem.getInvincible(equippedStack).booleanValue())) {
                equippedStack.method_7970(1, (class_1309)player, class_1304.field_6169);
            }
        } else if (player.method_5655()) {
            player.method_5684(false);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u91d1\u521a\u4e0d\u574f: \u5173\u95ed"), true);
        }
    }

    public static void handleUseEvent(class_1657 player) {
        if (player.method_6047().method_7960()) {
            class_1937 world = player.method_37908();
            class_1799 helmetStack = player.method_6118(class_1304.field_6169);
            class_1792 class_17922 = helmetStack.method_7909();
            if (class_17922 instanceof GourdHelmetItem) {
                GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
                int gourdColor = gourdHelmetItem.getColor();
                if (gourdColor == COLOR.ORANGE.getColor()) {
                    if (!world.field_9236) {
                        class_1799 mapStack = class_1806.method_8005((class_1937)world, (int)((int)player.method_23317()), (int)((int)player.method_23321()), (byte)0, (boolean)true, (boolean)false);
                        if (!player.method_31548().method_7394(mapStack)) {
                            player.method_7328(mapStack, false);
                        }
                        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_17481, class_3419.field_15248, 1.0f, 1.0f);
                    }
                } else if (gourdColor == COLOR.GREEN.getColor()) {
                    if (!world.field_9236) {
                        class_243 lookVec = player.method_5828(1.0f);
                        double range = 10.0;
                        double spreadAngle = 0.7853981633974483;
                        for (int i = 0; i < 40; ++i) {
                            double randomAngle = (Math.random() - 0.5) * spreadAngle;
                            double cosA = Math.cos(randomAngle);
                            double sinA = Math.sin(randomAngle);
                            class_243 rotatedVec = new class_243(lookVec.field_1352 * cosA - lookVec.field_1350 * sinA, lookVec.field_1351, lookVec.field_1352 * sinA + lookVec.field_1350 * cosA);
                            double distance = Math.random() * range;
                            class_243 particlePos = player.method_33571().method_1019(rotatedVec.method_1021(distance));
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11240, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                        class_238 box = player.method_5829().method_1014(range);
                        List entities = world.method_8333((class_1297)player, box, entity -> {
                            if (entity instanceof class_1309) {
                                class_243 toEntity = entity.method_19538().method_1020(player.method_33571()).method_1029();
                                double angle = Math.acos(toEntity.method_1026(lookVec));
                                return angle <= spreadAngle / 2.0;
                            }
                            return false;
                        });
                        for (class_1297 entity2 : entities) {
                            entity2.method_5639(5.0f);
                            double distance = entity2.method_19538().method_1022(player.method_19538());
                            float damage = (float)(8.0 * (1.0 - distance / range));
                            entity2.method_5643(player.method_48923().method_48813(), Math.max(2.0f, damage));
                        }
                        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15013, class_3419.field_15248, 1.0f, 1.0f);
                        helmetStack.method_7970(1, (class_1309)player, class_1304.field_6169);
                    }
                } else if (gourdColor == COLOR.BLUE.getColor()) {
                    if (!world.field_9236) {
                        class_243 lookVec = player.method_5828(1.0f);
                        double range = 10.0;
                        double spreadAngle = 0.7853981633974483;
                        for (int i = 0; i < 40; ++i) {
                            double randomAngle = (Math.random() - 0.5) * spreadAngle;
                            double cosA = Math.cos(randomAngle);
                            double sinA = Math.sin(randomAngle);
                            class_243 rotatedVec = new class_243(lookVec.field_1352 * cosA - lookVec.field_1350 * sinA, lookVec.field_1351, lookVec.field_1352 * sinA + lookVec.field_1350 * cosA);
                            double distance = Math.random() * range;
                            class_243 particlePos = player.method_33571().method_1019(rotatedVec.method_1021(distance));
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11202, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                        class_238 box = player.method_5829().method_1014(range);
                        List entities = world.method_8333((class_1297)player, box, entity -> {
                            if (entity instanceof class_1309) {
                                class_243 toEntity = entity.method_19538().method_1020(player.method_33571()).method_1029();
                                double angle = Math.acos(toEntity.method_1026(lookVec));
                                return angle <= spreadAngle / 2.0;
                            }
                            return false;
                        });
                        for (class_1297 entity3 : entities) {
                            double distance = entity3.method_19538().method_1022(player.method_19538());
                            float damage = (float)(6.0 * (1.0 - distance / range));
                            class_243 knockback = entity3.method_19538().method_1020(player.method_19538()).method_1029();
                            entity3.method_5762(knockback.field_1352 * 0.5, 0.2, knockback.field_1350 * 0.5);
                            entity3.method_5643(player.method_48923().method_48830(), Math.max(2.0f, damage));
                            if (!(entity3 instanceof class_1309)) continue;
                            ((class_1309)entity3).method_6092(new class_1293(class_1294.field_5909, 60, 1));
                        }
                        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14737, class_3419.field_15248, 1.0f, 1.0f);
                        helmetStack.method_7970(1, (class_1309)player, class_1304.field_6169);
                    }
                } else if (gourdColor == COLOR.SKYBLUE.getColor()) {
                    if (!world.field_9236) {
                        player.method_6092(new class_1293(class_1294.field_5905, 1200, 0, false, false));
                        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14545, class_3419.field_15248, 1.0f, 1.0f);
                        ((class_3218)world).method_14199((class_2394)class_2398.field_11245, player.method_23317(), player.method_23318(), player.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
                        helmetStack.method_7970(1, (class_1309)player, class_1304.field_6169);
                    }
                } else if (gourdColor == COLOR.PURPLE.getColor() && !world.field_9236) {
                    class_243 rotationVec = player.method_5828(1.0f);
                    double range = 5.0;
                    class_238 box = player.method_5829().method_1014(range);
                    List entities = world.method_8333((class_1297)player, box, entity -> {
                        if (entity instanceof class_1309) {
                            class_243 vec = entity.method_19538().method_1020(player.method_33571());
                            return vec.method_1029().method_1026(rotationVec) > 0.8;
                        }
                        return false;
                    });
                    for (class_1297 entity4 : entities) {
                        if (!(entity4 instanceof class_1309)) continue;
                        double angle = world.field_9229.method_43058() * Math.PI * 2.0;
                        double distance = 100.0;
                        double newX = entity4.method_23317() + Math.cos(angle) * distance;
                        double newZ = entity4.method_23321() + Math.sin(angle) * distance;
                        double newY = world.method_8624(class_2902.class_2903.field_13197, (int)newX, (int)newZ);
                        if (!world.method_8608()) {
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11214, entity4.method_23317(), entity4.method_23318(), entity4.method_23321(), 50, 0.5, 1.0, 0.5, 0.1);
                            class_3218 serverWorld = (class_3218)world;
                            entity4.method_23327(newX, newY, newZ);
                        }
                        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                        helmetStack.method_7970(5, (class_1309)player, class_1304.field_6169);
                    }
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> {
            state.getController().setAnimation(DefaultAnimations.IDLE);
            class_1297 entity = (class_1297)state.getData(DataTickets.ENTITY);
            if (entity instanceof class_1531) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            if (!(entity instanceof class_1309)) {
                return PlayState.CONTINUE;
            }
            class_1309 livingEntity = (class_1309)entity;
            for (class_1799 stack : livingEntity.method_5661()) {
                if (stack.method_7960()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.method_7909());
            }
            return PlayState.CONTINUE;
        }));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        final int color = this.getColor();
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                if (this.renderer == null) {
                    this.renderer = new GourdHelmetRenderer(color);
                }
                return this.renderer;
            }
        });
    }

    public static void setSize(class_1799 stack, float scale) {
        stack.method_57379(sizeKey, (Object)Float.valueOf(scale));
    }

    public static float getSize(class_1799 stack) {
        return ((Float)stack.method_57825(sizeKey, (Object)Float.valueOf(0.9375f))).floatValue();
    }

    public static void setInvincible(class_1799 stack, boolean b) {
        stack.method_57379(isInvincible, (Object)b);
    }

    public static Boolean getInvincible(class_1799 stack) {
        return (Boolean)stack.method_57825(isInvincible, (Object)false);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum COLOR {
        RED(15807540),
        ORANGE(16755500),
        YELLOW(16706372),
        GREEN(3534634),
        BLUE(2766319),
        SKYBLUE(5367533),
        PURPLE(13644520);

        private final int color;

        private COLOR(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

