/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.config.InitValue;
import com.soybeani.entity.vehicle.FlyingWoodSwordEntity;
import com.soybeani.items.ItemsRegister;
import com.soybeani.utils.CommonUtils;
import com.soybeani.utils.DelayedTaskManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1547;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class TalismanItem
extends class_1792 {
    public Type type;
    public static final Map<UUID, StoreEffectDAO> activePurpleEffects = new HashMap<UUID, StoreEffectDAO>();
    private static final Map<UUID, class_1439> playerGolemMap = new HashMap<UUID, class_1439>();
    private static final Map<UUID, Long> golemSpawnTimes = new HashMap<UUID, Long>();
    private static final long MAX_IDLE_TIME = 1200L;

    public TalismanItem(class_1792.class_1793 settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        UUID playerId;
        if (world.field_9236 || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        activePurpleEffects.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            StoreEffectDAO value = (StoreEffectDAO)entry.getValue();
            int remainingTicks = value.remainingTicks;
            if (remainingTicks <= 0) {
                return true;
            }
            class_3222 affectedPlayer = world.method_8503().method_3760().method_14602(playerId);
            if (affectedPlayer == null || !affectedPlayer.method_5805()) {
                return true;
            }
            this.applyPurpleEffect(world, (class_1657)affectedPlayer, value.level);
            value.remainingTicks = remainingTicks - 1;
            entry.setValue(value);
            return false;
        });
        if (this.type == Type.DARKGREEN && playerGolemMap.containsKey(playerId = player.method_5667())) {
            class_1439 golem = playerGolemMap.get(playerId);
            Long spawnTime = golemSpawnTimes.get(playerId);
            if (golem == null || !golem.method_5805() || world.method_8510() - spawnTime > 1200L) {
                if (golem != null && golem.method_5805()) {
                    golem.method_5650(class_1297.class_5529.field_26999);
                }
                playerGolemMap.remove(playerId);
                golemSpawnTimes.remove(playerId);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u5080\u5121\u5df2\u6d88\u5931"), true);
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void applyPurpleEffect(class_1937 world, class_1657 player, Integer level) {
        double radius = (double)level.intValue() + 1.0;
        double particleCount = 30.0;
        double angleIncrement = Math.PI * 2 / particleCount;
        boolean hasHealedThisTick = false;
        int i = 0;
        while ((double)i < particleCount) {
            double angle = (double)i * angleIncrement;
            double x = player.method_23317() + radius * Math.cos(angle);
            double z = player.method_23321() + radius * Math.sin(angle);
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)class_2398.field_11249, x, player.method_23318() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
            class_238 damageBox = new class_238(x - 0.5, player.method_23318(), z - 0.5, x + 0.5, player.method_23318() + 2.0, z + 0.5);
            List entities = world.method_8390(class_1309.class, damageBox, entity -> entity != player && !entity.method_7325());
            for (class_1309 entity2 : entities) {
                if (!entity2.method_5643(world.method_48963().method_48831(), 5.0f) || hasHealedThisTick || !(player.method_6032() < player.method_6063())) continue;
                player.method_6025(1.0f);
                hasHealedThisTick = true;
                if (!(world instanceof class_3218)) continue;
                class_3218 serverWorld2 = (class_3218)world;
                serverWorld2.method_14199((class_2394)class_2398.field_11211, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 10, 0.5, 0.5, 0.5, 0.0);
            }
            ++i;
        }
    }

    public Type getType() {
        return this.type;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_2338 blockPos = context.method_8037();
        class_1799 stack = player.method_5998(context.method_20287());
        if (!player.method_37908().field_9236) {
            switch (this.type.ordinal()) {
                case 2: {
                    TalismanItem.handleLightningSpell(player, blockPos, stack);
                    break;
                }
                case 10: {
                    TalismanItem.handleFlame(player, blockPos, stack);
                    break;
                }
                case 8: {
                    this.handleSummonFlyWoodSword(player, blockPos, stack);
                    break;
                }
                case 3: {
                    if (!player.method_6047().method_31574(class_1802.field_8091)) break;
                    this.handleGolemMovement(player, player.method_37908());
                    if (player.method_56992()) break;
                    stack.method_7934(1);
                    break;
                }
                default: {
                    return class_1269.field_5811;
                }
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        if (!player.method_37908().field_9236 && this.type == Type.DARKGREEN && player.method_6047().method_31574(class_1802.field_8091)) {
            class_1439 golem;
            UUID playerId = player.method_5667();
            if (!playerGolemMap.containsKey(playerId) && (golem = (class_1439)class_1299.field_6147.method_5883(player.method_37908())) != null) {
                golem.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
                golem.method_5665((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + "\u7684\u94c1\u5080\u5121")));
                golem.method_5880(true);
                golem.method_5977(false);
                player.method_37908().method_8649((class_1297)golem);
                playerGolemMap.put(playerId, golem);
                golemSpawnTimes.put(playerId, player.method_37908().method_8510());
                player.method_7353((class_2561)class_2561.method_43470((String)"\u53ec\u5524\u5080\u5121\u6210\u529f\u5e76\u5f00\u59cb\u653b\u51fb\u76ee\u6807"), true);
            }
            if ((golem = playerGolemMap.get(playerId)) != null && golem.method_5805()) {
                golem.method_5942().method_6340();
                golem.method_5980(target);
                golemSpawnTimes.put(playerId, player.method_37908().method_8510());
                player.method_7353((class_2561)class_2561.method_43470((String)"\u5080\u5121\u5f00\u59cb\u653b\u51fb\u76ee\u6807"), true);
            }
            if (!player.method_56992()) {
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            switch (this.type.ordinal()) {
                case 4: {
                    TalismanItem.handleNatureHealing(player, stack, 0.5f);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    return class_1271.method_22430((Object)stack);
                }
            }
            return class_1271.method_22427((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    private void handleGolemMovement(class_1657 player, class_1937 world) {
        class_243 lookVec;
        class_243 endPos;
        class_243 startPos = player.method_33571();
        class_3965 hitResult = world.method_17742(new class_3959(startPos, endPos = startPos.method_1019((lookVec = player.method_5828(1.0f)).method_1021(50.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 targetPos = hitResult.method_17777();
            class_2350 hitSide = hitResult.method_17780();
            if (hitSide == class_2350.field_11036) {
                targetPos = targetPos.method_10084();
            } else if (hitSide != class_2350.field_11033) {
                targetPos = targetPos.method_10093(hitSide);
            }
            UUID playerId = player.method_5667();
            if (!playerGolemMap.containsKey(playerId)) {
                class_1439 golem = (class_1439)class_1299.field_6147.method_5883(world);
                if (golem != null) {
                    golem.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
                    golem.method_5665((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + "\u7684\u94c1\u5080\u5121")));
                    golem.method_5880(true);
                    golem.method_5977(false);
                    class_1324 speedAttribute = golem.method_5996(class_5134.field_23719);
                    if (speedAttribute != null) {
                        speedAttribute.method_6192(0.5);
                    }
                    world.method_8649((class_1297)golem);
                    playerGolemMap.put(playerId, golem);
                    golemSpawnTimes.put(playerId, world.method_8510());
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u53ec\u5524\u5080\u5121\u6210\u529f"), true);
                }
            } else {
                class_1439 golem = playerGolemMap.get(playerId);
                if (golem != null && golem.method_5805()) {
                    golem.method_5942().method_6340();
                    golem.method_5980(null);
                    class_2338 finalPos = targetPos;
                    while (!world.method_8320(finalPos.method_10074()).method_26234((class_1922)world, finalPos.method_10074()) && finalPos.method_10264() > world.method_31607()) {
                        finalPos = finalPos.method_10074();
                    }
                    golem.method_5942().method_6337((double)finalPos.method_10263() + 0.5, (double)finalPos.method_10264(), (double)finalPos.method_10260() + 0.5, 1.0);
                    world.method_8406((class_2394)class_2398.field_11207, (double)finalPos.method_10263() + 0.5, (double)finalPos.method_10264(), (double)finalPos.method_10260() + 0.5, 0.0, 0.5, 0.0);
                    golemSpawnTimes.put(playerId, world.method_8510());
                    double distance = Math.sqrt(player.method_5649((double)finalPos.method_10263(), (double)finalPos.method_10264(), (double)finalPos.method_10260()));
                    player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u5080\u5121\u6b63\u5728\u79fb\u52a8\u5230\u8be5\u4f4d\u7f6e", distance)), true);
                }
            }
        }
    }

    public void handleSummonFlyWoodSword(class_1657 player, class_2338 blockPos, class_1799 stack) {
        class_1799 stackInHand;
        if (!player.method_37908().field_9236 && (stackInHand = player.method_5998(class_1268.field_5808)).method_7909() == class_1802.field_8091) {
            FlyingWoodSwordEntity flyingWoodSwordEntity = new FlyingWoodSwordEntity(player.method_37908(), blockPos.method_10263(), (double)blockPos.method_10264() + 1.5, blockPos.method_10260());
            player.method_37908().method_8649((class_1297)flyingWoodSwordEntity);
            if (!player.method_56992()) {
                stackInHand.method_7934(1);
                stack.method_7934(1);
            }
        }
    }

    public static void handleLightningSpell(class_1657 player, class_2338 blockPos, class_1799 stack) {
        String taskId;
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(player.method_37908());
        player.method_5684(true);
        lightning.method_5814((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        player.method_37908().method_8649((class_1297)lightning);
        if (!player.method_56992()) {
            stack.method_7934(1);
        }
        if (!DelayedTaskManager.hasTask(taskId = "lightning_invulnerability_" + String.valueOf(player.method_5667()))) {
            DelayedTaskManager.scheduleTask(taskId, 20, () -> player.method_5684(false));
        }
    }

    public static void handleNatureHealing(class_1657 player, class_1799 stack, float healAmount) {
        if (player.method_6032() >= player.method_6063()) {
            return;
        }
        player.method_6025(healAmount);
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.5f, 1.0f + (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.4f);
        if (player.method_37908() instanceof class_3218) {
            class_3218 serverWorld = (class_3218)player.method_37908();
            CommonUtils.spawnSelfParticle(serverWorld, (class_1297)player, class_2398.field_11211);
        }
        if (!player.method_56992()) {
            stack.method_7934(1);
        }
    }

    public static void handleFlame(class_1657 player, class_2338 blockPos, class_1799 stack) {
        class_1937 world = player.method_37908();
        if (world.method_8320(blockPos.method_10084()) == class_2246.field_10124.method_9564()) {
            world.method_8501(blockPos.method_10084(), class_2246.field_10036.method_9564());
            if (!player.method_56992()) {
                stack.method_7934(1);
            }
        }
    }

    public static void handleFlameToEntity(class_1657 player, class_1297 entity, class_1799 stack, int tick) {
        entity.method_20803(tick);
        if (!player.method_56992()) {
            stack.method_7934(1);
        }
        if (player.method_37908() instanceof class_3218) {
            class_3218 serverWorld = (class_3218)player.method_37908();
            CommonUtils.spawnSelfParticle(serverWorld, (class_1297)player, class_2398.field_11240);
        }
    }

    public static void spawnSwordSlashParticles(class_1657 player, class_1937 world, class_1799 stack, float damage) {
        TalismanItem talismanItem;
        class_1799 offHandStack;
        Object object;
        class_243 pos = player.method_33571();
        class_243 lookVec = player.method_5720();
        double range = 50.0;
        double width = 5.0;
        int particleCount = 50;
        if (!player.method_56992() && (object = (offHandStack = player.method_6079()).method_7909()) instanceof TalismanItem && (talismanItem = (TalismanItem)((Object)object)).getType() == Type.NONE) {
            offHandStack.method_7934(1);
        }
        world.method_8396(null, player.method_24515(), (class_3414)class_3417.field_15001.comp_349(), class_3419.field_15248, 1.0f, 0.5f + (float)Math.random());
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            class_243 rotatedVec = new class_243(lookVec.field_1352, lookVec.field_1351, lookVec.field_1350);
            double spread = width * (Math.random() - 0.5) * 0.2;
            class_243 particlePos = pos.method_1031(rotatedVec.field_1352 * range * progress + rotatedVec.field_1350 * spread, rotatedVec.field_1351 * range * progress + (Math.random() - 0.5) * 0.2, rotatedVec.field_1350 * range * progress - rotatedVec.field_1352 * spread);
            ((class_3218)world).method_14199((class_2394)class_2398.field_11227, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.1);
        }
        class_238 damageBox = player.method_5829().method_18804(lookVec.method_1021(range)).method_1014(width);
        List entities = world.method_8335((class_1297)player, damageBox);
        for (class_1297 target : entities) {
            class_243 directionToTarget;
            double dotProduct;
            double angleToTarget;
            if (!(target instanceof class_1309) || !((angleToTarget = Math.acos(dotProduct = lookVec.method_1026(directionToTarget = target.method_19538().method_1020(pos).method_1029()))) <= 0.7853981633974483)) continue;
            target.method_5643(target.method_48923().method_48831(), damage);
            ((class_3218)world).method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321(), 10, 0.2, 0.2, 0.2, 0.5);
        }
    }

    public static void handleWitherStatus(class_1657 player, class_1297 entity, class_1937 world, class_1799 itemStack) {
        if (entity instanceof class_1309) {
            class_1309 target = (class_1309)entity;
            target.method_6092(new class_1293(class_1294.field_5920, 1200, 1));
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_11251, target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321(), 200, 1.0, 1.0, 1.0, 0.2);
            }
            world.method_8396(null, target.method_24515(), class_3417.field_14877, class_3419.field_15248, 1.0f, 1.2f);
            if (!player.method_56992()) {
                itemStack.method_7934(1);
            }
        }
    }

    public static void handleFlySkyToEntity(class_1657 player, class_1297 entity, class_1799 stack) {
        if (entity instanceof class_1309) {
            class_1309 target = (class_1309)entity;
            class_1937 world = target.method_37908();
            target.method_5814(target.method_23317(), target.method_23318() + (double)InitValue.RANDOM.nextInt(5, 10), target.method_23321());
            world.method_8396(null, target.method_24515(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.2f);
            if (!player.method_56992()) {
                stack.method_7934(1);
            }
        }
    }

    public static void EventRegister(class_1657 player, class_1268 hand, class_1937 world, class_1297 entity, class_239 hitResult) {
        if (world.field_9236) {
            return;
        }
        class_1799 offHandStack = player.method_6079();
        class_1799 mainHandStack = player.method_6047();
        class_1792 class_17922 = offHandStack.method_7909();
        if (class_17922 instanceof TalismanItem) {
            TalismanItem talismanItem = (TalismanItem)class_17922;
            if (mainHandStack.method_7909() == class_1802.field_8091) {
                Type type = talismanItem.getType();
                double baseDamage = player.method_45325(class_5134.field_23721);
                class_1799 heldItem = player.method_5998(hand);
                if (heldItem.method_7909() instanceof class_1829) {
                    class_1832 material = ((class_1829)heldItem.method_7909()).method_8022();
                    baseDamage += (double)material.method_8028();
                }
                switch (type.ordinal()) {
                    case 2: {
                        TalismanItem.handleLightningSpell(player, entity.method_24515(), offHandStack);
                        break;
                    }
                    case 4: {
                        float cooldown = player.method_7261(0.5f);
                        float finalDamage = (float)baseDamage * (0.2f + cooldown * cooldown * 0.8f);
                        TalismanItem.handleNatureHealing(player, offHandStack, finalDamage);
                        break;
                    }
                    case 10: {
                        TalismanItem.handleFlameToEntity(player, entity, offHandStack, 100);
                        break;
                    }
                    case 6: {
                        if (!(entity instanceof class_1309)) break;
                        class_1309 target = (class_1309)entity;
                        float extraDamage = (float)(target instanceof class_1588 ? baseDamage + 10.0 : baseDamage + 0.0);
                        target.method_5643(target.method_48923().method_48831(), extraDamage);
                        if (world instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)world;
                            serverWorld.method_14199((class_2394)class_2398.field_22248, target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321(), 50, 1.0, 1.0, 1.0, 0.1);
                        }
                        world.method_8396(null, target.method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.2f);
                        if (player.method_56992()) break;
                        offHandStack.method_7934(1);
                        break;
                    }
                    case 5: {
                        if (!(entity instanceof class_1309)) break;
                        class_1309 target = (class_1309)entity;
                        float extraDamage = (float)(target instanceof class_1547 ? baseDamage + 20.0 : baseDamage + 0.0);
                        target.method_5643(target.method_48923().method_48831(), extraDamage);
                        if (!((class_1309)entity).method_29504()) break;
                        if (world instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)world;
                            serverWorld.method_14199((class_2394)class_2398.field_11251, target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321(), 50, 0.2, 0.2, 0.2, 0.1);
                        }
                        world.method_8396(null, target.method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.2f);
                        if (target instanceof class_1547) {
                            class_1542 itemEntity = new class_1542(target.method_37908(), target.method_23317() - 0.5 + Math.random(), target.method_23318() + 1.0, target.method_23321() - 0.5 + Math.random(), ItemsRegister.TALISMAN_GREY.method_7854());
                            world.method_8649((class_1297)itemEntity);
                        }
                        if (player.method_56992()) break;
                        offHandStack.method_7934(1);
                        break;
                    }
                    case 1: {
                        TalismanItem.handleWitherStatus(player, entity, world, offHandStack);
                        break;
                    }
                    case 8: {
                        TalismanItem.handleFlySkyToEntity(player, entity, offHandStack);
                    }
                }
            }
        }
    }

    public static enum Type {
        NONE,
        BLACK_PURPLE,
        BLUE,
        DARKGREEN,
        GREEN,
        GREY,
        PINK,
        PURPLE,
        SKYBLUE,
        YELLOW,
        YELLOW_RED;

    }

    public static class StoreEffectDAO {
        private int level;
        public int remainingTicks;

        public StoreEffectDAO(int level, int remainingTicks) {
            this.setLevel(level);
            this.remainingTicks = remainingTicks;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }
}

