/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.TrafficConeHelmetRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_572;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TrafficConeHelmetItem
extends class_1738
implements GeoItem {
    private int color;
    public static final int COLOR_DEFAULT = 0;
    public static final int COLOR_RED = 1;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private RawAnimation[] idleAnimations;

    public TrafficConeHelmetItem(class_1792.class_1793 settings, int color) {
        super(class_1740.field_7892, class_1738.class_8051.field_41934, settings);
        this.color = color;
        this.initializeAnimations();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        class_1799 equippedStack;
        class_1792 class_17922;
        if (world.field_9236) {
            return;
        }
        super.method_7888(stack, world, entity, slot, selected);
        State state = TrafficConeHelmetItem.getDamageState(stack);
        if (entity instanceof class_1657 && (class_17922 = (equippedStack = (player = (class_1657)entity).method_6118(class_1304.field_6169)).method_7909()) instanceof TrafficConeHelmetItem) {
            TrafficConeHelmetItem trafficConeHelmetItem = (TrafficConeHelmetItem)class_17922;
            class_2338 playerHeadPos = player.method_24515().method_10084().method_10084();
            List entitiesByType = world.method_8390(class_1309.class, entity.method_5829().method_1002(0.0, -1.0, 0.0).method_989(0.0, 2.0, 0.0), e -> e != entity);
            for (class_1309 livingEntity : entitiesByType) {
                livingEntity.method_5643(player.method_48923().method_48830(), 1.0f);
            }
            if (state == State.NEW) {
                if (trafficConeHelmetItem.color == 1) {
                    this.breakArea(player, playerHeadPos, 2, equippedStack);
                } else {
                    this.breakBlock(player, playerHeadPos, equippedStack);
                }
            } else if (state == State.DAMAGED) {
                if (trafficConeHelmetItem.color == 1) {
                    this.breakArea(player, playerHeadPos, 1, equippedStack);
                } else {
                    this.breakBlock(player, playerHeadPos, equippedStack);
                }
            } else if (state == State.BROKEN) {
                this.breakBlock(player, playerHeadPos, equippedStack);
            }
        }
    }

    private void breakBlock(class_1657 player, class_2338 pos, class_1799 stack) {
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(pos);
        if (!blockState.method_45474()) {
            world.method_8651(pos, true, (class_1297)player);
            this.decreaseDurability(stack, (class_1309)player);
        }
    }

    private void breakArea(class_1657 player, class_2338 pos, int size, class_1799 stack) {
        class_1937 world = player.method_37908();
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    class_2338 areaPos = pos.method_10069(x, y, z);
                    this.breakBlock(player, areaPos, stack);
                }
            }
        }
    }

    private void decreaseDurability(class_1799 stack, class_1309 livingEntity) {
        stack.method_7970(1, livingEntity, class_1304.field_6169);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        final int color = this.color;
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                if (this.renderer == null) {
                    this.renderer = new TrafficConeHelmetRenderer(color);
                }
                return this.renderer;
            }
        });
    }

    private void initializeAnimations() {
        this.idleAnimations = new RawAnimation[3];
        for (int i = 0; i < this.idleAnimations.length; ++i) {
            this.idleAnimations[i] = RawAnimation.begin().then("animation.traffic_cone.idle" + (i + 1), Animation.LoopType.LOOP);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> {
            class_1297 entity = (class_1297)state.getData(DataTickets.ENTITY);
            if (entity instanceof class_1531) {
                state.getController().setAnimation(DefaultAnimations.IDLE);
                return PlayState.CONTINUE;
            }
            if (!(entity instanceof class_1309)) {
                return PlayState.CONTINUE;
            }
            class_1309 livingEntity = (class_1309)entity;
            class_1799 helmetStack = livingEntity.method_6118(class_1304.field_6169);
            if (helmetStack.method_7960() || !(helmetStack.method_7909() instanceof TrafficConeHelmetItem)) {
                return PlayState.STOP;
            }
            State damageState = TrafficConeHelmetItem.getDamageState(helmetStack);
            if (damageState == State.BROKEN) {
                state.getController().setAnimation(this.idleAnimations[2]);
            } else if (damageState == State.DAMAGED) {
                state.getController().setAnimation(this.idleAnimations[1]);
            } else {
                state.getController().setAnimation(this.idleAnimations[0]);
            }
            return PlayState.CONTINUE;
        }));
    }

    private static State getDamageState(class_1799 itemStack) {
        float maxDurability = itemStack.method_7936();
        float currentDurability = maxDurability - (float)itemStack.method_7919();
        float durabilityPercentage = currentDurability / maxDurability * 100.0f;
        if (durabilityPercentage < 33.0f) {
            return State.BROKEN;
        }
        if (durabilityPercentage < 66.0f) {
            return State.DAMAGED;
        }
        return State.NEW;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static enum State {
        NEW,
        DAMAGED,
        BROKEN;

    }
}

