/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.TrafficSpearRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.utils.RayCastUtils;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_756;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TrafficSpearItem
extends class_1792
implements GeoItem {
    private static final RawAnimation ROTATION_ANIMATION = RawAnimation.begin().thenPlay("rotation");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static class_9331<Boolean> IS_ROTATING = ComponentTypeRegister.COMMON_BOOL;

    public TrafficSpearItem(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!world.field_9236) {
                class_3218 serverWorld = (class_3218)world;
                class_1799 mainHandStack = player.method_6047();
                if (player.method_6115() && player.method_6030() == mainHandStack) {
                    this.ExecuteAnimation((class_1309)player, "rotation");
                    TrafficSpearItem.setIsRotating(stack, true);
                    this.breakBlockInFront(world, player);
                } else {
                    this.ExecuteAnimation((class_1309)player, "idle");
                    TrafficSpearItem.setIsRotating(stack, false);
                }
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void breakBlockInFront(class_1937 world, class_1657 player) {
        class_3965 hitResult = TrafficSpearItem.raycast(world, player, class_3959.class_242.field_1348);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            class_2680 blockState = world.method_8320(blockPos);
            if (!blockState.method_26215()) {
                world.method_8651(blockPos, true, (class_1297)player);
                player.method_6047().method_7970(1, (class_1309)player, class_1304.field_6173);
                world.method_8396(null, blockPos, class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
            }
        } else {
            class_1297 targetEntity = RayCastUtils.getTargetEntity(world, player, 5.0);
            if (targetEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)targetEntity;
                livingEntity.method_5643(player.method_48923().method_48802(player), 10.0f);
                player.method_6047().method_7970(1, (class_1309)player, class_1304.field_6173);
            }
        }
    }

    public static class_3965 raycast(class_1937 world, class_1657 player, class_3959.class_242 fluidHandling) {
        float pitch = player.method_36455();
        float yaw = player.method_36454();
        class_243 vec3d = player.method_33571();
        float f = class_3532.method_15362((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float g = class_3532.method_15374((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float h = -class_3532.method_15362((float)(-pitch * ((float)Math.PI / 180)));
        float i = class_3532.method_15374((float)(-pitch * ((float)Math.PI / 180)));
        float j = g * h;
        float k = f * h;
        double reachDistance = 5.0;
        class_243 vec3d2 = vec3d.method_1031((double)j * reachDistance, (double)i * reachDistance, (double)k * reachDistance);
        return world.method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, fluidHandling, (class_1297)player));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        TrafficSpearItem.setIsRotating(stack, false);
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Activation", 0, state -> PlayState.STOP).triggerableAnim("rotation", ROTATION_ANIMATION).triggerableAnim("idle", IDLE_ANIMATION));
    }

    private void ExecuteAnimation(class_1309 entity, String animationName) {
        if (!entity.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)entity.method_37908();
            this.triggerAnim((class_1297)entity, GeoItem.getOrAssignId((class_1799)entity.method_6047(), (class_3218)serverWorld), "Activation", animationName);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){

            @Nullable
            public class_756 getGeoItemRenderer() {
                return new TrafficSpearRenderer();
            }
        });
    }

    public static void setIsRotating(class_1799 itemStack, boolean isRotating) {
        itemStack.method_57379(IS_ROTATING, (Object)isRotating);
    }

    public static boolean getIsRotating(class_1799 itemStack) {
        return (Boolean)itemStack.method_57824(IS_ROTATING);
    }
}

