/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.WaterGunRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.sound.SoundRegister;
import com.soybeani.utils.DelayedTaskManager;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_756;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class WaterGunItem
extends class_1792
implements GeoItem {
    private static final String CONTROLLER_NAME = "Activation";
    private static final String ABSORB_ANIMATION_NAME = "absorb";
    private static final String SHOOT_ANIMATION_NAME = "shoot";
    private static final String IDLE_ANIMATION_NAME = "idle";
    private static final RawAnimation ABSORB_ANIMATION = RawAnimation.begin().thenPlay("absorb");
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().thenPlay("shoot");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_9331<Integer> MODE_KEY = ComponentTypeRegister.COMMON_INTEGER;
    private static final class_9331<Float> CAPACITY_WATER_KEY = ComponentTypeRegister.COMMON_FLOAT;
    private static final class_9331<String> ANIMATION_NAME_KEY = ComponentTypeRegister.COMMON_STRING;
    public static final int MODE_IDLE = 0;
    public static final int MODE_ABSORB = 1;
    public static final int MODE_SHOOT_IDLE = 2;
    public static final int MODE_SHOOT_SHOOT = 3;
    private static final int MAX_WATER_DETECT_DISTANCE = 10;
    private static final float WATER_ABSORB_RATE = 0.005f;
    private static final float WATER_SHOOT_COST = 0.01f;
    private static final int SHOOT_DAMAGE = 3;
    private static final int PARTICLE_DENSITY = 3;

    public WaterGunItem(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 user;
        if (entity instanceof class_1657 && (user = (class_1657)entity).method_6047().method_7909() == this) {
            class_1799 mainHandStack = user.method_6047();
            int mode = WaterGunItem.getMode(stack);
            if (mode == 1) {
                this.ExecuteAnimation((class_1309)user, ABSORB_ANIMATION_NAME, mainHandStack);
                this.handleWaterAbsorption(world, user, mainHandStack);
            } else if (mode == 0 || mode == 2) {
                this.ExecuteAnimation((class_1309)user, IDLE_ANIMATION_NAME, mainHandStack);
            } else if (mode == 3) {
                this.ExecuteAnimation((class_1309)user, SHOOT_ANIMATION_NAME, mainHandStack);
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        float capacityWater = WaterGunItem.getCapacityWater(stack);
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a79\u5bb9\u91cf\uff1a" + Math.round(capacityWater * 100.0f) + "%")));
        super.method_7851(stack, context, tooltip, type);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 mainHandStack = user.method_6047();
        if (mainHandStack.method_7909() instanceof WaterGunItem) {
            int newMode = WaterGunItem.getMode(mainHandStack) == 0 ? 2 : 0;
            WaterGunItem.setMode(mainHandStack, newMode);
            if (!world.method_8608()) {
                world.method_60511(null, user.method_23317(), user.method_23318(), user.method_23321(), newMode == 2 ? class_3417.field_14860 : class_3417.field_14883, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
        return class_1271.method_22431((Object)mainHandStack);
    }

    public void absorbWater(class_1309 livingEntity) {
        class_1799 mainHandStack = livingEntity.method_6047();
        if (mainHandStack.method_7909() instanceof WaterGunItem) {
            int newMode = WaterGunItem.getMode(mainHandStack) == 0 ? 1 : 0;
            WaterGunItem.setMode(mainHandStack, newMode);
        }
    }

    private void handleWaterAbsorption(class_1937 world, class_1657 player, class_1799 stack) {
        class_243 waterCenter;
        class_243 playerPos;
        double distance;
        class_2338 waterPos;
        class_2680 blockState;
        class_3965 hitResult = this.raycastToWater(world, player, 10.0f);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && (blockState = world.method_8320(waterPos = hitResult.method_17777())).method_26227().method_39360((class_3611)class_3612.field_15910) && (distance = (playerPos = player.method_33571()).method_1022(waterCenter = class_243.method_24953((class_2382)waterPos))) <= 10.0) {
            float currentCapacity = WaterGunItem.getCapacityWater(stack);
            if (currentCapacity < 1.0f) {
                this.spawnWaterAbsorbParticles(world, waterCenter, player.method_33571());
                WaterGunItem.setCapacityWater(stack, currentCapacity + 0.005f);
                if (Math.round(currentCapacity * 100.0f) % 10 == 0) {
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_20613, class_3419.field_15248, 0.3f, 1.5f);
                }
            } else {
                WaterGunItem.setMode(stack, 0);
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14627, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public void shootWater(class_1657 player, class_1799 stack) {
        class_1937 world = player.method_37908();
        float currentCapacity = WaterGunItem.getCapacityWater(stack);
        if (currentCapacity < 0.01f) {
            if (!world.method_8608()) {
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14701, class_3419.field_15248, 0.5f, 1.2f);
            }
            return;
        }
        WaterGunItem.setMode(stack, 3);
        if (!world.method_8608()) {
            WaterGunItem.setCapacityWater(stack, currentCapacity - 0.01f);
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), SoundRegister.WATER_GUN, class_3419.field_15248, 0.5f, 1.0f);
            double range = 30.0;
            class_243 startPos = player.method_33571();
            class_243 lookDir = player.method_5828(1.0f);
            class_243 endPos = startPos.method_1019(lookDir.method_1021(range));
            this.spawnWaterShootParticles(world, startPos, endPos);
            class_3966 entityHit = this.raycastToEntity(world, player, startPos, endPos);
            if (entityHit != null && entityHit.method_17782() instanceof class_1309) {
                class_1309 target = (class_1309)entityHit.method_17782();
                target.method_6015((class_1309)player);
                target.method_5643(player.method_48923().method_48830(), 3.0f);
                class_243 knockbackDir = lookDir.method_1021(0.5);
                target.method_5762(knockbackDir.field_1352, 0.1, knockbackDir.field_1350);
            }
            DelayedTaskManager.scheduleTask("animation_waterGun", 5, () -> WaterGunItem.setMode(stack, 2));
            stack.method_7970(1, (class_1309)player, class_1304.field_6173);
        }
    }

    private class_3965 raycastToWater(class_1937 world, class_1657 player, float maxDistance) {
        class_243 startPos = player.method_33571();
        class_243 lookDir = player.method_5828(1.0f);
        class_243 endPos = startPos.method_1019(lookDir.method_1021((double)maxDistance));
        return world.method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1345, (class_1297)player));
    }

    private class_3966 raycastToEntity(class_1937 world, class_1657 player, class_243 startPos, class_243 endPos) {
        class_238 box = player.method_5829().method_18804(endPos.method_1020(startPos)).method_1014(1.0);
        class_3966 result = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_1297 entity : world.method_8333((class_1297)player, box, e -> e instanceof class_1309 && e.method_5805())) {
            double distance;
            class_238 entityBox = entity.method_5829().method_1014(0.3);
            Optional interceptPos = entityBox.method_992(startPos, endPos);
            if (!interceptPos.isPresent() || !((distance = startPos.method_1022((class_243)interceptPos.get())) < closestDistance)) continue;
            result = new class_3966(entity, (class_243)interceptPos.get());
            closestDistance = distance;
        }
        return result;
    }

    private void spawnWaterAbsorbParticles(class_1937 world, class_243 waterPos, class_243 targetPos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_243 direction = targetPos.method_1020(waterPos).method_1029();
            double distance = waterPos.method_1022(targetPos);
            int particleCount = (int)(distance * 3.0);
            for (int i = 0; i < particleCount; ++i) {
                double progress = (double)i / (double)particleCount;
                class_243 particlePos = waterPos.method_1019(direction.method_1021((distance - 1.0) * progress));
                double offsetX = world.field_9229.method_43058() * 0.1 - 0.05;
                double offsetY = world.field_9229.method_43058() * 0.1 - 0.05;
                double offsetZ = world.field_9229.method_43058() * 0.1 - 0.05;
                class_2390 particleEffect = i % 2 == 0 ? new class_2390(new Vector3f(0.0f, 0.3f, 1.0f), 1.0f) : new class_2390(new Vector3f(0.5f, 0.8f, 1.0f), 1.0f);
                serverWorld.method_14199((class_2394)particleEffect, particlePos.field_1352 + offsetX, particlePos.field_1351 + offsetY, particlePos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
    }

    private void spawnWaterShootParticles(class_1937 world, class_243 startPos, class_243 endPos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_243 direction = endPos.method_1020(startPos).method_1029();
            double distance = startPos.method_1022(endPos);
            class_243 adjustedStartPos = startPos.method_1019(direction.method_1021(1.0));
            int particleCount = (int)(distance * 3.0 * 2.0);
            for (int i = 0; i < particleCount; ++i) {
                double progress = (double)i / (double)particleCount;
                class_243 particlePos = adjustedStartPos.method_1019(direction.method_1021(distance * progress));
                double offsetX = world.field_9229.method_43058() * 0.05 - 0.025;
                double offsetY = world.field_9229.method_43058() * 0.05 - 0.025;
                double offsetZ = world.field_9229.method_43058() * 0.05 - 0.025;
                class_2390 particleEffect = i % 2 == 0 ? new class_2390(new Vector3f(0.0f, 0.3f, 1.0f), 1.0f) : new class_2390(new Vector3f(0.5f, 0.8f, 1.0f), 1.0f);
                serverWorld.method_14199((class_2394)particleEffect, particlePos.field_1352 + offsetX, particlePos.field_1351 + offsetY, particlePos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
    }

    public static void setMode(class_1799 itemStack, int mode) {
        itemStack.method_57379(MODE_KEY, (Object)mode);
    }

    public static void setCapacityWater(class_1799 itemStack, float capacityWater) {
        itemStack.method_57379(CAPACITY_WATER_KEY, (Object)Float.valueOf(Math.min(1.0f, capacityWater)));
    }

    public static int getMode(class_1799 itemStack) {
        return (Integer)itemStack.method_57824(MODE_KEY);
    }

    public static float getCapacityWater(class_1799 itemStack) {
        return ((Float)itemStack.method_57824(CAPACITY_WATER_KEY)).floatValue();
    }

    public static void setLastAnimationName(class_1799 itemStack, String animationName) {
        itemStack.method_57379(ANIMATION_NAME_KEY, (Object)animationName);
    }

    public static String getLastAnimationName(class_1799 itemStack) {
        return (String)itemStack.method_57824(ANIMATION_NAME_KEY);
    }

    private void ExecuteAnimation(class_1309 entity, String animationName, class_1799 itemStack) {
        if (!entity.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)entity.method_37908();
            this.triggerAnim((class_1297)entity, GeoItem.getOrAssignId((class_1799)itemStack, (class_3218)serverWorld), CONTROLLER_NAME, animationName);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 0, state -> PlayState.STOP).triggerableAnim(ABSORB_ANIMATION_NAME, ABSORB_ANIMATION).triggerableAnim(SHOOT_ANIMATION_NAME, SHOOT_ANIMATION).triggerableAnim(IDLE_ANIMATION_NAME, IDLE_ANIMATION));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){

            @Nullable
            public class_756 getGeoItemRenderer() {
                return new WaterGunRenderer();
            }
        });
    }
}

