/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.utils.CommonUtils;
import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9331;

public class WaterMoonItem
extends class_1792 {
    private static final class_9331<Long> CHUNK_POS_LONG = ComponentTypeRegister.COMMON_LONG;
    private static final class_9331<Boolean> IS_RECORDING = ComponentTypeRegister.COMMON_BOOL;
    private static final class_9331<String> CHUNK_INFO = ComponentTypeRegister.COMMON_STRING;
    private static final Map<Long, Map<class_2338, class_2680>> CHUNK_SNAPSHOTS = new HashMap<Long, Map<class_2338, class_2680>>();

    public WaterMoonItem(class_1792.class_1793 settings) {
        super(settings.method_57349(CHUNK_POS_LONG, (Object)0L).method_57349(IS_RECORDING, (Object)false).method_57349(CHUNK_INFO, (Object)""));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            Boolean isRecording = (Boolean)stack.method_57825(IS_RECORDING, (Object)false);
            if (isRecording.booleanValue()) {
                this.restoreChunk(world, stack, user);
                stack.method_57379(IS_RECORDING, (Object)false);
            } else {
                this.recordChunk(world, stack, user);
                stack.method_57379(IS_RECORDING, (Object)true);
            }
            user.method_7357().method_7906((class_1792)this, 40);
            stack.method_7970(1, (class_1309)user, class_1309.method_56079((class_1268)hand));
        }
        return class_1271.method_22427((Object)stack);
    }

    private void recordChunk(class_1937 world, class_1799 stack, class_1657 player) {
        class_1923 chunkPos = player.method_31476();
        long chunkPosLong = chunkPos.method_8324();
        stack.method_57379(CHUNK_POS_LONG, (Object)chunkPosLong);
        class_2818 chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        HashMap<class_2338, class_2680> blockStates = new HashMap<class_2338, class_2680>();
        int minY = world.method_31607();
        int maxY = world.method_31600();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    class_2338 pos = new class_2338(chunkPos.method_8326() + x, y, chunkPos.method_8328() + z);
                    class_2680 state = chunk.method_8320(pos);
                    if (state.method_26215()) continue;
                    blockStates.put(pos, state);
                }
            }
        }
        CHUNK_SNAPSHOTS.put(chunkPosLong, blockStates);
        String chunkInfo = "\u533a\u5757\u4f4d\u4e8e " + chunkPos.field_9181 + "," + chunkPos.field_9180 + "\uff0c\u5171 " + blockStates.size() + " \u4e2a\u65b9\u5757";
        stack.method_57379(CHUNK_INFO, (Object)chunkInfo);
        CommonUtils.spawnParticlesAndPlaySound((class_1937)((class_3218)world), (class_1297)player, (class_2394)class_2398.field_28479, class_3417.field_15119, class_3419.field_15248, 100, 0.0, 0.0, 1.0f, 1.0f);
        this.scheduleChunkOutlineParticles((class_3218)world, chunkPos);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u8bb0\u5f55\u5750\u6807\u4e3a " + chunkPos.field_9181 + ", " + chunkPos.field_9180 + " \u7684\u533a\u5757\uff0c\u5171 " + blockStates.size() + " \u4e2a\u65b9\u5757")), true);
    }

    private void restoreChunk(class_1937 world, class_1799 stack, class_1657 player) {
        Long chunkPosLong = (Long)stack.method_57824(CHUNK_POS_LONG);
        if (chunkPosLong == null || chunkPosLong == 0L) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u6ca1\u6709\u8bb0\u5f55\u533a\u5757\u6570\u636e"), true);
            return;
        }
        Map<class_2338, class_2680> blockStates = CHUNK_SNAPSHOTS.get(chunkPosLong);
        if (blockStates == null || blockStates.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u533a\u5757\u6570\u636e\u5df2\u4e22\u5931\u6216\u4e3a\u7a7a"), true);
            return;
        }
        class_1923 chunkPos = new class_1923(chunkPosLong.longValue());
        for (Map.Entry<class_2338, class_2680> entry : blockStates.entrySet()) {
            class_2338 pos = entry.getKey();
            class_2680 state = entry.getValue();
            world.method_8501(pos, state);
        }
        CommonUtils.spawnParticlesAndPlaySound((class_1937)((class_3218)world), (class_1297)player, (class_2394)class_2398.field_11214, class_3417.field_14703, class_3419.field_15248, 100, 0.0, 0.0, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u6062\u590d\u5750\u6807\u4e3a " + chunkPos.field_9181 + ", " + chunkPos.field_9180 + " \u7684\u533a\u5757\uff0c\u5171 " + blockStates.size() + " \u4e2a\u65b9\u5757")), true);
    }

    private void scheduleChunkOutlineParticles(class_3218 world, class_1923 chunkPos) {
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int endX = chunkPos.method_8327();
        int endZ = chunkPos.method_8329();
        int minY = world.method_31607() + 5;
        int maxY = world.method_31600() - 5;
        ServerEachTickTaskManager.scheduleTask(200, 10, () -> {
            int x;
            int randomZ;
            int z;
            for (int y = minY; y <= maxY; y += 3) {
                int x2;
                for (x2 = startX; x2 <= endX; x2 += 2) {
                    this.spawnBarrierParticle(world, x2, y, startZ);
                }
                for (x2 = startX; x2 <= endX; x2 += 2) {
                    this.spawnBarrierParticle(world, x2, y, endZ);
                }
                for (z = startZ; z <= endZ; z += 2) {
                    this.spawnBarrierParticle(world, startX, y, z);
                }
                for (z = startZ; z <= endZ; z += 2) {
                    this.spawnBarrierParticle(world, endX, y, z);
                }
                if (y % 6 != 0) continue;
                if (world.method_8409().method_43057() < 0.3f) {
                    int randomX = startX + world.method_8409().method_43048(16);
                    this.spawnSpecialParticle(world, randomX, y, startZ);
                    this.spawnSpecialParticle(world, randomX, y, endZ);
                }
                if (!(world.method_8409().method_43057() < 0.3f)) continue;
                randomZ = startZ + world.method_8409().method_43048(16);
                this.spawnSpecialParticle(world, startX, y, randomZ);
                this.spawnSpecialParticle(world, endX, y, randomZ);
            }
            for (x = startX; x <= endX; x += 2) {
                for (z = startZ; z <= endZ; z += 2) {
                    this.spawnBarrierParticle(world, x, minY, z);
                }
            }
            for (x = startX; x <= endX; x += 2) {
                for (z = startZ; z <= endZ; z += 2) {
                    this.spawnBarrierParticle(world, x, maxY, z);
                }
            }
            if (world.method_8409().method_43057() < 0.2f) {
                int randomX = startX + world.method_8409().method_43048(16);
                randomZ = startZ + world.method_8409().method_43048(16);
                int randomY = minY + world.method_8409().method_43048(maxY - minY);
                this.spawnSpecialParticle(world, randomX, randomY, randomZ);
            }
        });
    }

    private void spawnBarrierParticle(class_3218 world, int x, int y, int z) {
        world.method_14199((class_2394)class_2398.field_28479, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnSpecialParticle(class_3218 world, int x, int y, int z) {
        world.method_14199((class_2394)class_2398.field_11207, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3, 0.2, 0.2, 0.2, 0.01);
    }

    private void spawnParticleAtPosition(class_3218 world, int x, int y, int z) {
        CommonUtils.spawnSelfParticle(world, new class_2338(x, y, z), class_2398.field_11207);
    }
}

