/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.soybeani.animation.registry.GunAnimations;
import com.soybeani.config.InitValue;
import com.soybeani.entity.client.renderer.GunRenderer;
import com.soybeani.entity.custom.BulletProjectileEntity;
import com.soybeani.event.keybinds.KeyBindsInputHandler;
import com.soybeani.items.attributes.GunAttributes;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.items.weapon.AttachmentItem;
import com.soybeani.network.packet.gun.PlayAnimationPayload;
import com.soybeani.network.packet.gun.RecoilPayload;
import com.soybeani.network.packet.gun.ReloadPayload;
import com.soybeani.utils.BulletUtil;
import com.soybeani.utils.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class GunItem
extends class_1811
implements FabricItem,
GeoItem,
GeoAnimatable {
    public final Random random;
    private final String gunID;
    private final String animationID;
    private final float gunDamage;
    private final int rateOfFire;
    private final int magSize;
    public final class_1792 ammoType;
    private final int reloadCooldown;
    private final float[] bulletSpread;
    private final float[] gunRecoil;
    private final int pelletCount;
    private final LoadingType loadingType;
    private final class_3414 reloadSoundStart;
    private final class_3414 reloadSoundMagOut;
    private final class_3414 reloadSoundMagIn;
    private final class_3414 reloadSoundEnd;
    private final class_3414 shootSound;
    private final class_3414 postShootSound;
    private final int reloadCycles;
    private final boolean isScoped;
    private final boolean unscopeAfterShot;
    private final int reloadStage1;
    private final int reloadStage2;
    private final int reloadStage3;
    public final FiringType firingType;
    public final ArmType armType;
    public static final class_9331<Boolean> isScope = ComponentTypeRegister.IS_SCOPED;
    public static final class_9331<Boolean> isAiming = ComponentTypeRegister.IS_AIMING;
    public static final class_9331<Boolean> isReloading = ComponentTypeRegister.IS_RELOADING;
    public static final class_9331<Integer> reloadTick = ComponentTypeRegister.RELOAD_TICK;
    public static final class_9331<Integer> clip = ComponentTypeRegister.CLIP;
    public static final class_9331<Integer> currentCycle = ComponentTypeRegister.CURRENT_CYCLE;
    public static final class_9331<List<class_1799>> attachments = ComponentTypeRegister.ATTACHMENTS;
    public static final class_9331<Integer> sightId = ComponentTypeRegister.SIGHT_ID;
    public static final class_9331<Integer> gripId = ComponentTypeRegister.GRIP_ID;
    public static final class_9331<Integer> muzzleId = ComponentTypeRegister.MUZZLE_ID;
    private final AttachmentItem.AttachType[] acceptedAttachmentTypes;
    private final Multimap<class_1320, class_1322> attributeModifiers;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GunItem(class_1792.class_1793 settings, String gunID, String animationID, float gunDamage, int rateOfFire, int magSize, class_1792 ammoType, int reloadCooldown, float[] bulletSpread, float[] gunRecoil, int pelletCount, LoadingType loadingType, class_3414 reloadSoundStart, class_3414 reloadSoundMagOut, class_3414 reloadSoundMagIn, class_3414 reloadSoundEnd, class_3414 shootSound, class_3414 postShootSound, int reloadCycles, boolean isScoped, boolean unscopeAfterShot, int reloadStage1, int reloadStage2, int reloadStage3, FiringType firingType, ArmType armType, AttachmentItem.AttachType[] acceptedAttachmentTypes) {
        super(GunItem.setDefaultComponent(settings.method_7895(magSize * 10 + 1)));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.random = new Random();
        this.gunID = gunID;
        this.animationID = animationID;
        this.gunDamage = gunDamage;
        this.rateOfFire = rateOfFire;
        this.magSize = magSize;
        this.ammoType = ammoType;
        this.reloadCooldown = reloadCooldown;
        this.bulletSpread = bulletSpread;
        this.gunRecoil = gunRecoil;
        this.pelletCount = pelletCount;
        this.loadingType = loadingType;
        this.reloadSoundStart = reloadSoundStart;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.shootSound = shootSound;
        this.postShootSound = postShootSound;
        this.reloadCycles = reloadCycles;
        this.isScoped = isScoped;
        this.unscopeAfterShot = unscopeAfterShot;
        this.reloadStage1 = reloadStage1;
        this.reloadStage2 = reloadStage2;
        this.reloadStage3 = reloadStage3;
        this.firingType = firingType;
        this.armType = armType;
        this.acceptedAttachmentTypes = acceptedAttachmentTypes;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)GunAttributes.GUN_DAMAGE, (Object)new class_1322(InitValue.id("weapon_modify"), (double)this.gunDamage, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (hand == class_1268.field_5808 && !user.method_7357().method_7904((class_1792)this) && !user.method_5624() && GunItem.isLoaded(stack)) {
            this.shoot(world, user, stack);
            user.method_7357().method_7906((class_1792)this, this.rateOfFire);
        }
        return class_1271.method_22431((Object)stack);
    }

    public void shoot(class_1937 world, class_1657 user, class_1799 itemStack) {
        itemStack.method_57379(reloadTick, (Object)0);
        itemStack.method_57379(isReloading, (Object)false);
        double h_kick = this.getRecoilX(itemStack);
        float v_kick = this.getRecoilY(itemStack);
        if (this.shouldUnscopeAfterShot() && ((Boolean)itemStack.method_57824(isAiming)).booleanValue()) {
            itemStack.method_57379(isAiming, (Object)false);
        }
        if (!world.method_8608()) {
            for (int i = 0; i < this.pelletCount; ++i) {
                BulletProjectileEntity bullet = new BulletProjectileEntity((class_1309)user, world, (float)user.method_45325(class_7923.field_41190.method_47983((Object)GunAttributes.GUN_DAMAGE)), this.pelletCount);
                bullet.method_5814(user.method_23317(), user.method_23320(), user.method_23321());
                class_243 vertiSpread = BulletUtil.vertiSpread(user, this.random.nextFloat(-this.bulletSpread[0] * 5.0f, this.bulletSpread[0] * 5.0f) * this.getSpreadMult(itemStack));
                class_243 horiSpread = BulletUtil.horiSpread(user, this.random.nextFloat(-this.bulletSpread[1] * 5.0f, this.bulletSpread[1] * 5.0f) * this.getSpreadMult(itemStack));
                class_243 result = user.method_5720().method_1019(vertiSpread).method_1019(horiSpread);
                bullet.method_7485(result.method_10216(), result.method_10214(), result.method_10215(), 20.0f, 0.0f);
                bullet.setBaseVel(bullet.method_18798());
                bullet.method_7432((class_1297)user);
                world.method_8649((class_1297)bullet);
            }
            long id = GeoItem.getOrAssignId((class_1799)itemStack, (class_3218)((class_3218)world));
            String status_name = (Boolean)itemStack.method_57824(isAiming) != false ? "aim_firing" : "firing";
            ServerPlayNetworking.send((class_3222)((class_3222)user), (class_8710)new PlayAnimationPayload(status_name, id));
            ServerPlayNetworking.send((class_3222)((class_3222)user), (class_8710)new RecoilPayload(Float.valueOf(v_kick), h_kick));
        }
        if (!user.method_31549().field_7477) {
            itemStack.method_57379(clip, (Object)((Integer)itemStack.method_57824(clip) - 1));
            itemStack.method_7974(itemStack.method_7936() - ((Integer)itemStack.method_57824(clip) * 10 + 1));
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), this.shootSound, class_3419.field_15250, 1.0f, 1.0f);
        if (this.reloadCycles > 1) {
            itemStack.method_57379(currentCycle, (Object)((Integer)itemStack.method_57824(clip)));
        }
    }

    private static class_1792.class_1793 setDefaultComponent(class_1792.class_1793 settings) {
        return settings.method_57349(isScope, (Object)false).method_57349(isAiming, (Object)false).method_57349(isReloading, (Object)false).method_57349(reloadTick, (Object)0).method_57349(clip, (Object)0).method_57349(currentCycle, (Object)1).method_57349(attachments, List.of()).method_57349(sightId, (Object)0).method_57349(gripId, (Object)0).method_57349(muzzleId, (Object)0);
    }

    public void method_7843(class_1799 stack, class_1937 world) {
        if (world instanceof class_3218) {
            long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)((class_3218)world));
            this.triggerAnim(null, id, "controller", "idle");
        }
        super.method_7843(stack, world);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)("\u5f39\u836f: " + String.valueOf(stack.method_57824(clip)) + "/" + this.magSize)).method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43471((String)("\u4f24\u5bb3: " + this.gunDamage)).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("\u540e\u5ea7\u529b: " + Math.sqrt(this.gunRecoil[0] * this.gunRecoil[0] + this.gunRecoil[1] * this.gunRecoil[1]))).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("\u6bcf\u5206\u949f\u5c04\u901f: " + (int)(20.0f / (float)this.rateOfFire * 60.0f))).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("\u88c5\u5f39\u65f6\u95f4: " + (float)this.reloadCooldown / 20.0f + "\u79d2")).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"\u4f7f\u7528:").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.ammoType.method_7876()).method_27692(class_124.field_1054));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)("\u5f39\u836f: " + String.valueOf(stack.method_57824(clip)) + "/" + this.magSize)).method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43471((String)"\u4f7f\u7528:").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.ammoType.method_7876()).method_27692(class_124.field_1054));
            tooltip.add((class_2561)class_2561.method_43471((String)"\u6309\u4f4fShift\u952e\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f").method_27692(class_124.field_1075));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_9323 components = stack.method_57353();
        boolean isSprinting = entity.method_5624();
        class_1799 mainHandGun = ((class_1657)entity).method_6047();
        long id = GeoItem.getId((class_1799)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (world.method_8608()) {
            if (animationController.getCurrentAnimation() != null && !animationController.getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                if (!(!isSprinting || ((Boolean)stack.method_57824(isAiming)).booleanValue() || mainHandGun != stack || ((Boolean)stack.method_57824(isReloading)).booleanValue() || animationController.isPlayingTriggeredAnimation() && animationController.getCurrentAnimation().animation().name().equals("sprinting") || animationController.getCurrentAnimation().animation().name().equals("melee") && !animationController.getAnimationState().equals((Object)AnimationController.State.PAUSED))) {
                    animationController.tryTriggerAnimation("sprinting");
                } else if (!(isSprinting && mainHandGun == stack || !animationController.isPlayingTriggeredAnimation() || !animationController.getCurrentAnimation().animation().name().equals("sprinting") || animationController.getCurrentAnimation().animation().name().equals("melee") && !animationController.getAnimationState().equals((Object)AnimationController.State.PAUSED))) {
                    animationController.tryTriggerAnimation((Boolean)stack.method_57824(isAiming) == false ? "idle" : "aim");
                }
            }
            if (mainHandGun == stack && KeyBindsInputHandler.KEY_R.method_1434() && GunItem.remainingAmmo(stack) < this.magSize && GunItem.reserveAmmoCount((class_1657)entity, this.ammoType) > 0 && !((Boolean)stack.method_57824(isReloading)).booleanValue() && !isSprinting) {
                ClientPlayNetworking.send((class_8710)new ReloadPayload(true));
            }
        }
        if (mainHandGun != stack && ((Boolean)stack.method_57824(isAiming)).booleanValue()) {
            animationController.tryTriggerAnimation("idle");
            stack.method_57379(isAiming, (Object)false);
        }
        if (((Boolean)stack.method_57824(isReloading)).booleanValue() && !isSprinting) {
            if (mainHandGun != stack || GunItem.reserveAmmoCount((class_1657)entity, this.ammoType) <= 0 && this.reloadCycles <= 1 || (Integer)stack.method_57824(reloadTick) >= this.reloadCooldown || GunItem.remainingAmmo(stack) >= this.magSize && this.reloadCycles <= 1) {
                stack.method_57379(isReloading, (Object)false);
            }
            this.doReloadTick(world, (class_1657)entity, stack);
        } else {
            if ((Integer)stack.method_57824(reloadTick) > this.reloadStage3 && (Integer)stack.method_57824(reloadTick) <= this.reloadCooldown) {
                this.finishReload((class_1657)entity, stack);
            }
            stack.method_57379(isReloading, (Object)false);
            stack.method_57379(reloadTick, (Object)0);
        }
    }

    private void doReloadTick(class_1937 world, class_1657 player, class_1799 stack) {
        int rTick = (Integer)stack.method_57824(reloadTick);
        if (world instanceof class_3218) {
            long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)((class_3218)world));
            if ((Integer)stack.method_57824(reloadTick) == this.reloadStage1) {
                this.triggerAnim((class_1297)player, id, "controller", "reload_magout");
            } else if ((Integer)stack.method_57824(reloadTick) == this.reloadStage2) {
                this.triggerAnim((class_1297)player, id, "controller", "reload_magin");
            } else if ((Integer)stack.method_57824(reloadTick) == this.reloadStage3) {
                this.triggerAnim((class_1297)player, id, "controller", "reload_end");
            }
        }
        stack.method_57379(reloadTick, (Object)(rTick + 1));
        switch (this.loadingType.ordinal()) {
            case 0: {
                if (rTick < this.reloadCooldown || GunItem.reserveAmmoCount(player, this.ammoType) <= 0) break;
                stack.method_57379(currentCycle, (Object)1);
                this.finishReload(player, stack);
                stack.method_57379(reloadTick, (Object)0);
                break;
            }
            case 1: {
                if (rTick < this.reloadStage3 || (Integer)stack.method_57824(currentCycle) >= this.reloadCycles || GunItem.reserveAmmoCount(player, this.ammoType) <= 0) break;
                stack.method_57379(clip, (Object)((Integer)stack.method_57824(clip) + 1));
                InventoryUtil.removeItemFromInventory(player, this.ammoType, 1);
                if (GunItem.remainingAmmo(stack) < this.magSize && GunItem.reserveAmmoCount(player, this.ammoType) > 0) {
                    stack.method_57379(reloadTick, (Object)this.reloadStage2);
                }
                stack.method_57379(currentCycle, (Object)((Integer)stack.method_57824(clip)));
                stack.method_7974(stack.method_7936() - ((Integer)stack.method_57824(clip) * 10 + 1));
            }
        }
    }

    public float getRecoilX(class_1799 stack) {
        boolean rd = this.random.nextBoolean();
        return ((Boolean)stack.method_57824(isAiming) != false ? (rd ? this.gunRecoil[0] : -this.gunRecoil[0]) / 2.0f : (rd ? this.gunRecoil[0] : -this.gunRecoil[0])) * this.getRecoilMult(stack);
    }

    public float getRecoilY(class_1799 stack) {
        return ((Boolean)stack.method_57824(isAiming) != false ? this.gunRecoil[1] / 2.0f : this.gunRecoil[1]) * this.getRecoilMult(stack);
    }

    public float getRecoilMult(class_1799 stack) {
        float recoilMult = 1.0f;
        List attachmentsList = (List)stack.method_57825(attachments, List.of());
        for (class_1799 attachmentStack : attachmentsList) {
            class_1792 class_17922 = attachmentStack.method_7909();
            if (!(class_17922 instanceof AttachmentItem)) continue;
            AttachmentItem attachmentItem = (AttachmentItem)class_17922;
            recoilMult *= attachmentItem.getRecoilMult();
        }
        return recoilMult;
    }

    public float getSpreadMult(class_1799 stack) {
        float spreadMult = 1.0f;
        List attachmentsList = (List)stack.method_57825(attachments, List.of());
        for (class_1799 attachmentStack : attachmentsList) {
            class_1792 class_17922 = attachmentStack.method_7909();
            if (!(class_17922 instanceof AttachmentItem)) continue;
            AttachmentItem attachmentItem = (AttachmentItem)class_17922;
            spreadMult *= attachmentItem.getSpreadMult();
        }
        return spreadMult;
    }

    public static boolean isLoaded(class_1799 stack) {
        return GunItem.remainingAmmo(stack) > 0;
    }

    public void finishReload(class_1657 player, class_1799 stack) {
        int ammoToLoad = this.magSize - (Integer)stack.method_57824(clip);
        if (GunItem.reserveAmmoCount(player, this.ammoType) >= ammoToLoad) {
            stack.method_57379(clip, (Object)((Integer)stack.method_57824(clip) + ammoToLoad));
            InventoryUtil.removeItemFromInventory(player, this.ammoType, ammoToLoad);
        } else {
            stack.method_57379(clip, (Object)((Integer)stack.method_57824(clip) + GunItem.reserveAmmoCount(player, this.ammoType)));
            InventoryUtil.removeItemFromInventory(player, this.ammoType, GunItem.reserveAmmoCount(player, this.ammoType));
        }
        stack.method_7974(stack.method_7936() - ((Integer)stack.method_57824(clip) * 10 + 1));
    }

    public void aimAnimation(class_1799 stack, boolean aim, class_3218 world, class_1657 player) {
        stack.method_57379(isAiming, (Object)aim);
        stack.method_57379(isScope, (Object)this.isScoped);
        long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)world);
        this.triggerAnim((class_1297)player, id, "controller", aim ? "aim" : "idle");
    }

    public void toggleSprint(class_1799 stack, boolean sprint, class_3218 world, class_1657 player) {
        long id = GeoItem.getOrAssignId((class_1799)stack, (class_3218)world);
        if (((Boolean)stack.method_57824(isReloading)).booleanValue()) {
            return;
        }
        if (sprint) {
            this.triggerAnim((class_1297)player, id, "controller", "sprinting");
        }
    }

    public static int remainingAmmo(class_1799 stack) {
        return (Integer)stack.method_57824(clip);
    }

    public static int reserveAmmoCount(class_1657 player, class_1792 item) {
        return InventoryUtil.itemCountInInventory(player, item);
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15353((float)0.0f, (float)1.0f, (float)1.0f);
    }

    public int getRateOfFire() {
        return this.rateOfFire;
    }

    public boolean shouldUnscopeAfterShot() {
        return this.unscopeAfterShot;
    }

    public String getID() {
        return this.gunID;
    }

    public String getAnimationID() {
        return this.animationID;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GunRenderer renderer;

            @Nullable
            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GunRenderer(class_2960.method_60655((String)"fun_item", (String)GunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<GunItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate).triggerableAnim("idle", GunAnimations.IDLE).triggerableAnim("firing", GunAnimations.FIRING).triggerableAnim("reload_start", GunAnimations.RELOAD_START).triggerableAnim("reload_magout", GunAnimations.RELOAD_MAGOUT).triggerableAnim("reload_magin", GunAnimations.RELOAD_MAGIN).triggerableAnim("reload_end", GunAnimations.RELOAD_END).triggerableAnim("aim", GunAnimations.AIM).triggerableAnim("aim_firing", GunAnimations.AIM_FIRING).triggerableAnim("aim_reload_start", GunAnimations.AIM_RELOAD_START).triggerableAnim("melee", GunAnimations.MELEE).triggerableAnim("sprinting", GunAnimations.SPRINTING);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(controller);
    }

    private void soundListener(SoundKeyframeEvent<GunItem> gunItemSoundKeyframeEvent) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "reload_start": {
                    player.method_5783(this.reloadSoundStart, 1.0f, 1.0f);
                    break;
                }
                case "reload_magout": {
                    player.method_5783(this.reloadSoundMagOut, 1.0f, 1.0f);
                    break;
                }
                case "reload_magin": {
                    player.method_5783(this.reloadSoundMagIn, 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    player.method_5783(this.reloadSoundEnd, 1.0f, 1.0f);
                    break;
                }
                case "post_shoot": {
                    player.method_5783(this.postShootSound, 1.0f, 1.0f);
                    break;
                }
                case "melee": {
                    player.method_5783(class_3417.field_14840, 1.0f, 1.0f);
                }
            }
        }
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float speed, float divergence, float yaw, @Nullable class_1309 target) {
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        if (otherStack.method_7960()) {
            this.removeFirstStack(stack).ifPresent(itemStack -> {
                player.method_5783(class_3417.field_34377, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
                cursorStackReference.method_32332(itemStack);
            });
        } else {
            int i = this.addAttachment(stack, otherStack);
            if (i > 0) {
                otherStack.method_7934(i);
                player.method_5783(class_3417.field_34376, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
            }
        }
        return true;
    }

    public int addAttachment(class_1799 gun, class_1799 attachment) {
        class_1792 class_17922 = attachment.method_7909();
        if (!(class_17922 instanceof AttachmentItem)) {
            return 0;
        }
        AttachmentItem attachmentItem = (AttachmentItem)class_17922;
        if (!this.acceptedAttachment(attachmentItem.getAttachType())) {
            return 0;
        }
        ArrayList<class_1799> currentAttachments = new ArrayList<class_1799>((Collection)gun.method_57825(attachments, List.of()));
        boolean hasAttachmentOfSameType = currentAttachments.stream().anyMatch(item -> item.method_7909() instanceof AttachmentItem && ((AttachmentItem)item.method_7909()).getAttachType() == attachmentItem.getAttachType());
        if (hasAttachmentOfSameType) {
            return 0;
        }
        int attachID = attachmentItem.getId();
        class_1799 itemStack = attachment.method_7972();
        itemStack.method_7939(1);
        currentAttachments.add(0, itemStack);
        gun.method_57379(attachments, currentAttachments);
        switch (attachmentItem.getAttachType()) {
            case SIGHT: {
                gun.method_57379(sightId, (Object)attachID);
                break;
            }
            case GRIP: {
                gun.method_57379(gripId, (Object)attachID);
                break;
            }
            case MUZZLE: {
                gun.method_57379(muzzleId, (Object)attachID);
            }
        }
        return 1;
    }

    private Optional<class_1799> removeFirstStack(class_1799 gun) {
        List currentAttachments = (List)gun.method_57825(attachments, List.of());
        if (currentAttachments.isEmpty()) {
            return Optional.empty();
        }
        class_1799 attachment = (class_1799)currentAttachments.get(0);
        class_1792 class_17922 = attachment.method_7909();
        if (!(class_17922 instanceof AttachmentItem)) {
            return Optional.empty();
        }
        AttachmentItem attachmentItem = (AttachmentItem)class_17922;
        ArrayList updatedAttachments = new ArrayList(currentAttachments);
        updatedAttachments.remove(0);
        gun.method_57379(attachments, updatedAttachments);
        switch (attachmentItem.getAttachType()) {
            case SIGHT: {
                gun.method_57379(sightId, (Object)0);
                break;
            }
            case GRIP: {
                gun.method_57379(gripId, (Object)0);
                break;
            }
            case MUZZLE: {
                gun.method_57379(muzzleId, (Object)0);
            }
        }
        return Optional.of(attachment);
    }

    private boolean acceptedAttachment(AttachmentItem.AttachType attachType) {
        for (AttachmentItem.AttachType attachType2 : this.acceptedAttachmentTypes) {
            if (attachType != attachType2) continue;
            return true;
        }
        return false;
    }

    public Predicate<class_1799> method_19268() {
        return null;
    }

    public int method_24792() {
        return 0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public FiringType getFiringType() {
        return this.firingType;
    }

    public boolean isScoped() {
        return this.isScoped;
    }

    public ArmType getArmType() {
        return this.armType;
    }

    public int getSightID(class_1799 gun) {
        return (Integer)gun.method_57824(sightId);
    }

    public int getGripID(class_1799 gun) {
        return (Integer)gun.method_57824(gripId);
    }

    public int getMuzzleID(class_1799 gun) {
        return (Integer)gun.method_57824(muzzleId);
    }

    public static enum LoadingType {
        MAGAZINE,
        PER_CARTRIDGE;

    }

    public static enum FiringType {
        SEMI_AUTO,
        AUTO;

    }

    public static enum ArmType {
        HANDGUN_ONEHAND,
        HANDGUN_TWOHAND,
        REVOLVER_FANNING,
        LONG_GUNS,
        MINIGUN;

    }
}

