/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class DelayedTaskManager {
    private static final Map<String, DelayedTask> activeTasks = new HashMap<String, DelayedTask>();
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            ServerTickEvents.END_SERVER_TICK.register(server -> {
                Iterator<Map.Entry<String, DelayedTask>> iterator = activeTasks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, DelayedTask> entry = iterator.next();
                    DelayedTask task = entry.getValue();
                    task.tick();
                    if (!task.isCompleted()) continue;
                    iterator.remove();
                }
            });
            initialized = true;
        }
    }

    public static void scheduleTask(String taskId, int delayTicks, Runnable callback) {
        activeTasks.put(taskId, new DelayedTask(delayTicks, callback));
    }

    public static void cancelTask(String taskId) {
        activeTasks.remove(taskId);
    }

    public static void resetTask(String taskId) {
        DelayedTask task = activeTasks.get(taskId);
        if (task != null) {
            task.reset();
        }
    }

    public static boolean hasTask(String taskId) {
        return activeTasks.containsKey(taskId);
    }

    public static boolean isTaskCompleted(String taskId) {
        DelayedTask task = activeTasks.get(taskId);
        return task != null && task.isCompleted();
    }

    public static class DelayedTask {
        private int tickCounter = 0;
        private final int targetTicks;
        private final Runnable callback;
        private boolean completed = false;

        public DelayedTask(int targetTicks, Runnable callback) {
            this.targetTicks = targetTicks;
            this.callback = callback;
        }

        public void tick() {
            if (this.completed) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter >= this.targetTicks) {
                this.callback.run();
                this.completed = true;
            }
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void reset() {
            this.tickCounter = 0;
            this.completed = false;
        }
    }
}

