/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.custom;

import com.soybeani.config.InitValue;
import com.soybeani.items.ItemsRegister;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FireTridentEntity
extends class_1665 {
    public static final class_1299<FireTridentEntity> FIRE_TRIDENT = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)InitValue.id("fire_trident"), (Object)class_1299.class_1300.method_5903(FireTridentEntity::new, (class_1311)class_1311.field_17715).method_17687(0.6f, 2.9f).method_55687(2.55f).method_55689(new float[]{2.80625f}).method_27299(8).build());
    private static final int WATER_CLEAR_RADIUS = 5;
    private Set<class_2338> affectedWaterBlocks = new HashSet<class_2338>();
    private boolean isActive = false;
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(FireTridentEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(FireTridentEntity.class, (class_2941)class_2943.field_13323);
    private boolean dealtDamage;
    public int returnTimer;

    public boolean method_5753() {
        return true;
    }

    public FireTridentEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FireTridentEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(FIRE_TRIDENT, owner, world, stack, (class_1799)null);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
    }

    public FireTridentEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(FIRE_TRIDENT, x, y, z, world, stack, stack);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(ENCHANTED, (Object)false);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (i > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(this.method_19538());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double d = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.isActive || this.method_5771() || this.method_5799()) {
                this.clearWaterArea(this.method_24515());
            }
            if (this.method_31481()) {
                this.restoreWater();
            }
        }
        super.method_5773();
    }

    private void clearWaterArea(class_2338 center) {
        class_3218 world = (class_3218)this.method_37908();
        this.affectedWaterBlocks.clear();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    if (!(center.method_10262((class_2382)pos) <= 25.0)) continue;
                    class_2680 blockState = world.method_8320(pos);
                    if (blockState.method_27852(class_2246.field_10382) || blockState.method_27852(class_2246.field_10164)) {
                        this.affectedWaterBlocks.add(pos.method_10062());
                        world.method_30092(pos, class_2246.field_10124.method_9564(), 2, 0);
                        world.method_14199((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.5, 0.5, 0.5, 0.1);
                        world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                        continue;
                    }
                    if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                        this.affectedWaterBlocks.add(pos.method_10062());
                        world.method_30092(pos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 2, 0);
                        continue;
                    }
                    if (!blockState.method_27852(class_2246.field_10376) && !blockState.method_27852(class_2246.field_10238)) continue;
                    this.affectedWaterBlocks.add(pos.method_10062());
                    world.method_30092(pos, class_2246.field_10124.method_9564(), 2, 0);
                }
            }
        }
    }

    private void restoreWater() {
        class_3218 world = (class_3218)this.method_37908();
        for (class_2338 pos : this.affectedWaterBlocks) {
            if (!world.method_8320(pos).method_26215()) continue;
            world.method_8501(pos, class_2246.field_10382.method_9564());
            world.method_14199((class_2394)class_2398.field_11202, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.5, 0.5, 0.5, 0.1);
        }
        this.affectedWaterBlocks.clear();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    public boolean isEnchanted() {
        return (Boolean)this.field_6011.method_12789(ENCHANTED);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_3218 serverWorld;
        class_1297 entity = entityHitResult.method_17782();
        float f = 8.0f;
        class_1297 entity2 = this.method_24921();
        class_1282 damageSource = this.method_48923().method_48799((class_1297)this, (class_1297)(entity2 == null ? this : entity2));
        class_1937 var7 = this.method_37908();
        if (var7 instanceof class_3218) {
            serverWorld = (class_3218)var7;
            f = class_1890.method_60120((class_3218)serverWorld, (class_1799)this.method_59958(), (class_1297)entity, (class_1282)damageSource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.method_5643(damageSource, f)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            var7 = this.method_37908();
            if (var7 instanceof class_3218) {
                serverWorld = (class_3218)var7;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_5639(5.0f);
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(class_3417.field_15213, 1.0f, 1.0f);
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().field_9236) {
            this.isActive = true;
        }
    }

    protected void method_59956(class_3218 world, class_3965 blockHitResult, class_1799 weaponStack) {
        class_1309 livingEntity;
        class_243 vec3d = blockHitResult.method_17777().method_60913(blockHitResult.method_17784());
        class_1297 var6 = this.method_24921();
        class_1309 var10002 = var6 instanceof class_1309 ? (livingEntity = (class_1309)var6) : null;
        class_1890.method_60124((class_3218)world, (class_1799)weaponStack, (class_1309)var10002, (class_1297)this, (class_1304)null, (class_243)vec3d, (class_2680)world.method_8320(blockHitResult.method_17777()), item -> this.method_5768());
    }

    public class_1799 method_59958() {
        return this.method_54759();
    }

    protected boolean method_34713(class_1657 player) {
        return super.method_34713(player) || this.method_7441() && this.method_34714((class_1297)player) && player.method_31548().method_7394(this.method_7445());
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)ItemsRegister.FIRE_TRIDENT);
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public void method_5694(class_1657 player) {
        if (this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.dealtDamage = nbt.method_10577("DealtDamage");
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(this.method_54759()));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("DealtDamage", this.dealtDamage);
    }

    private byte getLoyalty(class_1799 stack) {
        class_1937 var3 = this.method_37908();
        if (var3 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var3;
            return (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverWorld, (class_1799)stack, (class_1297)this), (int)0, (int)127);
        }
        return 0;
    }

    public void method_7446() {
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (this.field_7572 != class_1665.class_1666.field_7593 || i <= 0) {
            super.method_7446();
        }
    }

    protected float method_7436() {
        return 0.99f;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

