/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.vehicle;

import com.soybeani.config.InitValue;
import com.soybeani.entity.EntityRegister;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2740;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_8836;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;

public class FlyingWoodSwordEntity
extends class_8836
implements class_9817 {
    private static final float MAX_DAMAGE = 40.0f;
    private static final float ROTATION_SPEED = 2.0f;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private boolean pressingJump;
    private boolean pressingSneak;
    private float velocityDecay = 0.9f;
    private float yawVelocity;
    private class_1309 pilot;
    private class_243 lastLocation;
    private class_9817.class_9818 leashData;

    public FlyingWoodSwordEntity(class_1299<? extends class_8836> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
        this.field_5960 = true;
    }

    public FlyingWoodSwordEntity(class_1937 world, double x, double y, double z) {
        this(EntityRegister.FLYING_WOOD_SWORD_ENTITY_ENTITY_TYPE, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public void method_5773() {
        this.lastLocation = this.method_19538();
        if (this.pilot != null && !this.pilot.method_31481() && this.pilot.method_5854() == this) {
            this.updateMovement();
            if (this.method_5787()) {
                class_243 movement = this.calculateMovement();
                this.method_18799(movement);
                this.method_5784(class_1313.field_6308, this.method_18798());
            } else {
                this.method_18799(class_243.field_1353);
            }
        }
        this.method_36457(0.0f);
        this.method_36456(this.method_36454() + this.yawVelocity);
        super.method_5773();
    }

    private class_243 calculateMovement() {
        if (this.pilot == null || this.pilot.method_31481()) {
            return class_243.field_1353;
        }
        double speed = 1.0;
        class_243 movement = class_243.field_1353;
        float playerYaw = this.pilot.method_36454();
        this.method_36456(playerYaw);
        float pitch = this.pilot.method_36455();
        if (this.pressingForward || this.pressingBack) {
            double horizontalSpeed = Math.cos(Math.toRadians(pitch)) * speed;
            double x = -Math.sin(Math.toRadians(playerYaw)) * horizontalSpeed;
            double z = Math.cos(Math.toRadians(playerYaw)) * horizontalSpeed;
            double y = -Math.sin(Math.toRadians(pitch)) * speed;
            if (this.pressingBack) {
                x = -x;
                z = -z;
                y = -y;
            }
            movement = new class_243(x, y, z);
        }
        if (this.pressingLeft || this.pressingRight) {
            double x = Math.cos(Math.toRadians(playerYaw)) * speed;
            double z = Math.sin(Math.toRadians(playerYaw)) * speed;
            if (this.pressingRight) {
                x = -x;
                z = -z;
            }
            movement = !movement.equals((Object)class_243.field_1353) ? movement.method_1019(new class_243(x, 0.0, z)).method_1021(0.7071) : new class_243(x, 0.0, z);
        }
        if (this.pressingJump) {
            movement = movement.method_1031(0.0, 0.5, 0.0);
        }
        return movement;
    }

    private void updateMovement() {
        if (this.pressingLeft) {
            this.yawVelocity = -2.0f;
            this.method_36456(this.method_36454() + this.yawVelocity);
        }
        if (this.pressingRight) {
            this.yawVelocity = 2.0f;
            this.method_36456(this.method_36454() + this.yawVelocity);
        }
        if (!this.pressingLeft && !this.pressingRight) {
            this.yawVelocity = 0.0f;
        }
    }

    public void setInputs(boolean pressingForward, boolean pressingBack, boolean pressingLeft, boolean pressingRight, boolean pressingJump, boolean pressingSneak) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
        this.pressingJump = pressingJump;
        this.pressingSneak = pressingSneak;
    }

    protected void method_5749(class_2487 nbt) {
        this.leashData = this.method_60967(nbt);
        boolean hasPlayerUUID = nbt.method_10545("PlayerUUID");
        if (hasPlayerUUID) {
            InitValue.LOGGER.info("PlayerUUID: " + String.valueOf(nbt.method_25926("PlayerUUID")));
            UUID playerUUID = nbt.method_25926("PlayerUUID");
            this.pilot = this.method_37908().method_18470(playerUUID);
        }
    }

    protected void method_5652(class_2487 nbt) {
        this.method_60962(nbt, this.leashData);
        if (this.pilot != null) {
            nbt.method_25927("PlayerUUID", this.pilot.method_5667());
        } else {
            nbt.method_10551("PlayerUUID");
        }
    }

    public void method_5644(class_1297 passenger) {
        super.method_5644(passenger);
        if (passenger instanceof class_1309) {
            this.pilot = (class_1309)passenger;
        }
    }

    public class_1309 method_5642() {
        return this.pilot;
    }

    public class_1792 method_7557() {
        return class_1802.field_8091;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5688(player, hand);
        if (actionResult != class_1269.field_5811) {
            return actionResult;
        }
        if (player.method_21823()) {
            this.pilot = null;
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236) {
            this.pilot = player;
            return player.method_5873((class_1297)this, true) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    protected float getPassengerHorizontalOffset() {
        return 0.0f;
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        float f = this.getPassengerHorizontalOffset();
        if (this.method_5685().size() > 1) {
            int i = this.method_5685().indexOf(passenger);
            f = i == 0 ? 0.2f : -0.6f;
            if (passenger instanceof class_1429) {
                f += 0.2f;
            }
        }
        return new class_243(0.0, (double)(dimensions.comp_2186() * 0.8888889f), (double)f).method_1024(-this.method_36454() * ((float)Math.PI / 180));
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (!passenger.method_5864().method_20210(class_3483.field_47578)) {
            passenger.method_36456(passenger.method_36454() + this.yawVelocity);
            passenger.method_5847(passenger.method_5791() + this.yawVelocity);
            this.clampPassengerYaw(passenger);
            if (passenger instanceof class_1429 && this.method_5685().size() == this.getMaxPassengers()) {
                int i = passenger.method_5628() % 2 == 0 ? 90 : 270;
                passenger.method_5636(((class_1429)passenger).field_6283 + (float)i);
                passenger.method_5847(passenger.method_5791() + (float)i);
            }
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().field_9236 && reason.method_31486()) {
            this.method_5932(true, true);
        }
        super.method_5650(reason);
    }

    @Nullable
    public class_9817.class_9818 method_60955() {
        return this.leashData;
    }

    public void method_60960(@Nullable class_9817.class_9818 leashData) {
        this.leashData = leashData;
    }

    public void method_5932(boolean sendPacket, boolean dropItem) {
        FlyingWoodSwordEntity.detachLeash(this, sendPacket, dropItem);
    }

    private static <E extends class_1297> void detachLeash(E entity, boolean sendPacket, boolean dropItem) {
        class_1937 var5;
        if (sendPacket && (var5 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var5;
            serverWorld.method_14178().method_18754(entity, (class_2596)new class_2740(entity, (class_1297)null));
        }
    }

    protected class_2561 method_23315() {
        return class_2561.method_43471((String)this.method_7557().method_7876());
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.method_7557());
    }

    protected void clampPassengerYaw(class_1297 passenger) {
        passenger.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        passenger.field_5982 += g - f;
        passenger.method_36456(passenger.method_36454() + g - f);
        passenger.method_5847(passenger.method_36454());
    }

    protected int getMaxPassengers() {
        return 2;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }
}

