/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import net.minecraft.class_6880;

public class SprintEffect
extends class_1291 {
    private static final float MAX_SPEED_MULTIPLIER = 3.0f;
    private static final float SPEED_INCREMENT = 0.01f;
    private static final float[] DESTRUCTION_TIERS = new float[]{3.0f, 5.0f, 8.0f, 12.0f};
    private static final Map<UUID, Float> PLAYER_SPEEDS = new HashMap<UUID, Float>();

    public SprintEffect() {
        super(class_4081.field_18271, 5881011);
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }

    public void method_52520(class_1309 entity, int amplifier) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PLAYER_SPEEDS.put(player.method_5667(), Float.valueOf(1.0f));
        }
        super.method_52520(entity, amplifier);
    }

    public boolean method_5572(class_1309 entity, int amplifier) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            UUID playerId = player.method_5667();
            float currentSpeed = PLAYER_SPEEDS.getOrDefault(playerId, Float.valueOf(1.0f)).floatValue();
            currentSpeed = Math.min(currentSpeed + 0.01f * (float)(amplifier + 1), 3.0f * (float)(amplifier + 1));
            PLAYER_SPEEDS.put(playerId, Float.valueOf(currentSpeed));
            class_243 velocity = player.method_18798();
            class_243 lookDir = player.method_5720();
            float accelerationFactor = 0.05f * (currentSpeed - 1.0f);
            double newX = velocity.field_1352 + lookDir.field_1352 * (double)accelerationFactor;
            double newZ = velocity.field_1350 + lookDir.field_1350 * (double)accelerationFactor;
            player.method_18800(newX, velocity.field_1351, newZ);
            player.method_5875(true);
            if (currentSpeed > DESTRUCTION_TIERS[0]) {
                int tier = 0;
                for (int i = 0; i < DESTRUCTION_TIERS.length; ++i) {
                    if (!(currentSpeed >= DESTRUCTION_TIERS[i])) continue;
                    tier = i + 1;
                }
                this.applyDestructionEffect(player, tier, lookDir);
            }
        }
        return true;
    }

    private void applyDestructionEffect(class_1657 player, int tier, class_243 direction) {
        class_1937 world = player.method_37908();
        int range = tier;
        int width = tier;
        class_243 playerPos = player.method_19538().method_1031(0.0, (double)player.method_18381(player.method_18376()) * 0.5, 0.0);
        class_243 endPos = playerPos.method_1019(direction.method_1021((double)range));
        class_238 destructionBox = new class_238(Math.min(playerPos.field_1352, endPos.field_1352) - (double)width / 2.0, Math.min(playerPos.field_1351, endPos.field_1351) - (double)width / 2.0, Math.min(playerPos.field_1350, endPos.field_1350) - (double)width / 2.0, Math.max(playerPos.field_1352, endPos.field_1352) + (double)width / 2.0, Math.max(playerPos.field_1351, endPos.field_1351) + (double)width / 2.0, Math.max(playerPos.field_1350, endPos.field_1350) + (double)width / 2.0);
        class_2338.method_10097((class_2338)new class_2338((int)destructionBox.field_1323, (int)destructionBox.field_1322, (int)destructionBox.field_1321), (class_2338)new class_2338((int)destructionBox.field_1320, (int)destructionBox.field_1325, (int)destructionBox.field_1324)).forEach(pos -> {
            class_2680 state = world.method_8320(pos);
            float hardness = state.method_26214((class_1922)world, pos);
            if (hardness >= 0.0f && hardness <= (float)tier * 2.0f) {
                world.method_8651(pos, true, (class_1297)player);
                world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            }
        });
        if (tier >= 3) {
            world.method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 0.5f, 1.0f + (world.field_9229.method_43057() - 0.5f) * 0.2f);
        }
    }

    public void method_58617(class_1309 entity, int amplifier, class_1297.class_5529 reason) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PLAYER_SPEEDS.remove(player.method_5667());
            entity.method_5875(false);
        }
        super.method_58617(entity, amplifier, reason);
    }
}

