/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.IceSkatesRenderer;
import com.soybeani.items.ItemsRegister;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.items.item.GemAttachmentItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_572;
import net.minecraft.class_9331;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceSkatesItem
extends class_1738
implements GeoItem {
    private static final String CONTROLLER_NAME = "Activation";
    private static final String IDLE_ANIMATION_NAME = "idle";
    private static final class_9331<List<class_1799>> attachments = ComponentTypeRegister.ATTACHMENTS;
    private static final class_9331<Boolean> GEM_LAND = ComponentTypeRegister.GEM_LAND;
    private static final class_9331<Boolean> GEM_WATER = ComponentTypeRegister.GEM_WATER;
    private static final class_9331<Boolean> GEM_LAVA = ComponentTypeRegister.GEM_LAVA;
    private static final class_9331<Boolean> GEM_COLOR = ComponentTypeRegister.GEM_COLOR;
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public IceSkatesItem(class_1792.class_1793 settings) {
        super(class_1740.field_7892, class_1738.class_8051.field_41937, settings.method_57349(GEM_LAND, (Object)false).method_57349(GEM_WATER, (Object)false).method_57349(GEM_LAVA, (Object)false).method_57349(GEM_COLOR, (Object)false));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 0, state -> PlayState.STOP).triggerableAnim(IDLE_ANIMATION_NAME, IDLE_ANIMATION));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){

            public <T extends class_1309> class_572<?> getGeoArmorRenderer(T livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<T> original) {
                return new IceSkatesRenderer();
            }
        });
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (((Boolean)stack.method_57824(GEM_LAND)).booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43470((String)ItemsRegister.GEM_LAND.method_7848().getString()));
        }
        if (((Boolean)stack.method_57824(GEM_WATER)).booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43470((String)ItemsRegister.GEM_WATER.method_7848().getString()));
        }
        if (((Boolean)stack.method_57824(GEM_LAVA)).booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43470((String)ItemsRegister.GEM_LAVA.method_7848().getString()));
        }
        if (((Boolean)stack.method_57824(GEM_COLOR)).booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43470((String)ItemsRegister.GEM_COLOR.method_7848().getString()));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        class_1799 boots;
        super.method_7888(stack, world, entity, slot, selected);
        if (!world.field_9236 && entity instanceof class_1657 && (boots = (player = (class_1657)entity).method_31548().method_7372(0)).method_31574((class_1792)this) && ((Boolean)boots.method_57824(GEM_COLOR)).booleanValue() && world.method_8510() % 5L == 0L) {
            class_3218 serverWorld = (class_3218)world;
            this.spawnColorfulParticles(serverWorld, player);
        }
    }

    private void spawnColorfulParticles(class_3218 world, class_1657 player) {
        Vector3f[] colors = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
        for (int i = 0; i < 3; ++i) {
            Vector3f color = colors[world.method_8409().method_43048(colors.length)];
            double angle = world.method_8409().method_43058() * Math.PI * 2.0;
            double distance = 0.5 + world.method_8409().method_43058() * 0.5;
            double height = world.method_8409().method_43058() * 2.0;
            double x = player.method_23317() + Math.sin(angle) * distance;
            double y = player.method_23318() + height;
            double z = player.method_23321() + Math.cos(angle) * distance;
            class_2390 particleEffect = new class_2390(color, 1.0f);
            world.method_14199((class_2394)particleEffect, x, y, z, 1, 0.0, 0.05, 0.0, 0.0);
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        if (otherStack.method_7960()) {
            this.removeFirstStack(stack).ifPresent(itemStack -> cursorStackReference.method_32332(itemStack));
        } else {
            int i = this.addAttachment(stack, otherStack);
            if (i > 0) {
                otherStack.method_7934(i);
                player.method_5783(class_3417.field_34376, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
            }
        }
        return true;
    }

    public int addAttachment(class_1799 stack, class_1799 attachment) {
        class_1792 class_17922 = attachment.method_7909();
        if (!(class_17922 instanceof GemAttachmentItem)) {
            return 0;
        }
        GemAttachmentItem attachmentItem = (GemAttachmentItem)class_17922;
        ArrayList<class_1799> currentAttachments = new ArrayList<class_1799>((Collection)stack.method_57825(attachments, List.of()));
        boolean hasAttachmentOfSameType = currentAttachments.stream().anyMatch(item -> item.method_7909() instanceof GemAttachmentItem && ((GemAttachmentItem)item.method_7909()).getGemType() == attachmentItem.getGemType());
        if (hasAttachmentOfSameType) {
            return 0;
        }
        class_1799 itemStack = attachment.method_7972();
        itemStack.method_7939(1);
        currentAttachments.add(0, itemStack);
        stack.method_57379(attachments, currentAttachments);
        switch (attachmentItem.getGemType()) {
            case LAND: {
                stack.method_57379(GEM_LAND, (Object)true);
                break;
            }
            case WATER: {
                stack.method_57379(GEM_WATER, (Object)true);
                break;
            }
            case LAVA: {
                stack.method_57379(GEM_LAVA, (Object)true);
                break;
            }
            case COLOR: {
                stack.method_57379(GEM_COLOR, (Object)true);
            }
        }
        return 1;
    }

    private Optional<class_1799> removeFirstStack(class_1799 stack) {
        List currentAttachments = (List)stack.method_57825(attachments, List.of());
        if (currentAttachments.isEmpty()) {
            return Optional.empty();
        }
        class_1799 attachment = (class_1799)currentAttachments.get(0);
        class_1792 class_17922 = attachment.method_7909();
        if (!(class_17922 instanceof GemAttachmentItem)) {
            return Optional.empty();
        }
        GemAttachmentItem attachmentItem = (GemAttachmentItem)class_17922;
        ArrayList updatedAttachments = new ArrayList(currentAttachments);
        updatedAttachments.remove(0);
        stack.method_57379(attachments, updatedAttachments);
        switch (attachmentItem.getGemType()) {
            case LAND: {
                stack.method_57379(GEM_LAND, (Object)false);
                break;
            }
            case WATER: {
                stack.method_57379(GEM_WATER, (Object)false);
                break;
            }
            case LAVA: {
                stack.method_57379(GEM_LAVA, (Object)false);
                break;
            }
            case COLOR: {
                stack.method_57379(GEM_COLOR, (Object)false);
            }
        }
        return Optional.of(attachment);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

