/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.KeyboardRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import net.minecraft.class_756;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KeyBoardItem
extends class_1792
implements GeoItem {
    private static final class_9331<Integer> COLOR_COMPONENT = ComponentTypeRegister.COMMON_INTEGER;
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int color = COLOR.WHITE.getColor();

    public KeyBoardItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public int getColor() {
        return this.color;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (world.field_9236) {
                this.spawnColoredParticles(world, player.method_19538(), this.getColor(stack));
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void spawnColoredParticles(class_1937 world, class_243 playerPos, int colorValue) {
        class_5819 random = world.method_8409();
        float red = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorValue & 0xFF) / 255.0f;
        for (int i = 0; i < 2; ++i) {
            double x = playerPos.field_1352 + (random.method_43058() - 0.5) * 5.0;
            double y = playerPos.field_1351 + random.method_43058() * 2.0;
            double z = playerPos.field_1350 + (random.method_43058() - 0.5) * 5.0;
            world.method_8406((class_2394)new class_2390(new Vector3f(red, green, blue), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> {
            state.getController().setAnimation(DefaultAnimations.IDLE);
            return PlayState.CONTINUE;
        }));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){

            @Nullable
            public class_756 getGeoItemRenderer() {
                return new KeyboardRenderer();
            }
        });
    }

    public void switchColor(class_1799 stack) {
        int currentColor = this.getColor(stack);
        int nextColor = COLOR.getColorNext(currentColor);
        this.setColor(stack, nextColor);
    }

    public int getColor(class_1799 stack) {
        return (Integer)stack.method_57824(COLOR_COMPONENT);
    }

    public void setColor(class_1799 stack, int color) {
        stack.method_57379(COLOR_COMPONENT, (Object)color);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum COLOR {
        WHITE(0xFFFFFF),
        RED(15807540),
        ORANGE(16755500),
        YELLOW(16706372),
        GREEN(3534634),
        BLUE(2766319),
        SKYBLUE(5367533),
        PURPLE(13644520);

        private final int color;

        private COLOR(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public static int getColorNext(int color) {
            COLOR[] values = COLOR.values();
            for (int i = 0; i < values.length; ++i) {
                COLOR value = values[i];
                if (value.getColor() != color) continue;
                if (i == values.length - 1) {
                    return values[0].getColor();
                }
                return values[i + 1].getColor();
            }
            return 0;
        }
    }
}

