/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.items.ItemsRegister;
import com.soybeani.items.component.ComponentTypeRegister;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class SpongeBootItem
extends class_1738 {
    private static class_9331<Boolean> IS_SPONGE = ComponentTypeRegister.COMMON_BOOL;
    private static class_9331<Integer> STORAGE_WATER = ComponentTypeRegister.COMMON_INTEGER;
    private static final int MAX_STORAGE_WATER = 100000;
    private static final int CHANGE_BOOTS_VALUE = 20000;
    private static final int MIN_STORAGE_WATER = 0;
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public SpongeBootItem(class_6880<class_1741> material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1799 feetStack = player.method_6118(class_1304.field_6166);
            class_2338 pos = player.method_24515();
            if (feetStack.method_7909() == this) {
                boolean isSponge = SpongeBootItem.getIsSponge(feetStack);
                if (player.method_5799() && isSponge) {
                    SpongeBootItem.absorbWater(world, pos, player, feetStack);
                    world.method_8396((class_1657)null, pos, class_3417.field_15237, class_3419.field_15245, 1.0f, 1.0f);
                } else if (!isSponge) {
                    SpongeBootItem.drainWater(world, pos, player, feetStack);
                }
                int storageWater = SpongeBootItem.getStorageWater(feetStack);
                if (storageWater > 20000 && feetStack.method_7909() == ItemsRegister.SPONGE_BOOTS) {
                    class_1799 newItemStack = feetStack.method_56701((class_1935)ItemsRegister.WET_SPONGE_BOOTS, 1);
                    player.method_31548().field_7548.set(0, (Object)newItemStack);
                } else if (storageWater <= 20000 && feetStack.method_7909() == ItemsRegister.WET_SPONGE_BOOTS) {
                    class_1799 newItemStack = feetStack.method_56701((class_1935)ItemsRegister.SPONGE_BOOTS, 1);
                    player.method_31548().field_7547.set(0, (Object)newItemStack);
                }
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a79\u5f53\u524d\u50a8\u6c34\u91cf: " + SpongeBootItem.getStorageWater(stack))));
        super.method_7851(stack, context, tooltip, type);
    }

    private static boolean absorbWater(class_1937 world, class_2338 pos, class_1657 player, class_1799 stack) {
        return class_2338.method_49925((class_2338)pos, (int)6, (int)650, (currentPos, queuer) -> {
            for (class_2350 direction : DIRECTIONS) {
                queuer.accept(currentPos.method_10093(direction));
                SpongeBootItem.setStorageWater(stack, SpongeBootItem.getStorageWater(stack) + 1);
            }
        }, currentPos -> {
            class_2263 fluidDrainable;
            class_2680 blockState = world.method_8320(currentPos);
            class_3610 fluidState = world.method_8316(currentPos);
            if (!fluidState.method_15767(class_3486.field_15517)) {
                return false;
            }
            class_2248 block = blockState.method_26204();
            if (block instanceof class_2263 && !(fluidDrainable = (class_2263)block).method_9700(player, (class_1936)world, currentPos, blockState).method_7960()) {
                return true;
            }
            if (blockState.method_26204() instanceof class_2404) {
                world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
            } else {
                if (!(blockState.method_27852(class_2246.field_9993) || blockState.method_27852(class_2246.field_10463) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238))) {
                    return false;
                }
                class_2586 blockEntity = blockState.method_31709() ? world.method_8321(currentPos) : null;
                class_2248.method_9610((class_2680)blockState, (class_1936)world, (class_2338)currentPos, (class_2586)blockEntity);
                world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
            }
            return true;
        }) > 1;
    }

    private static void drainWater(class_1937 world, class_2338 pos, class_1657 player, class_1799 stack) {
        int storedWater = SpongeBootItem.getStorageWater(stack);
        if (storedWater <= 0) {
            return;
        }
        int waterPlaced = 0;
        int size = stack.method_7909() == ItemsRegister.SPONGE_BOOTS ? 1 : 2;
        class_243 lookVec = player.method_5828(1.0f);
        class_2338 frontPos = pos.method_10081((class_2382)new class_2338((int)Math.round(lookVec.field_1352), 0, (int)Math.round(lookVec.field_1350)));
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                class_2338 currentPos = frontPos.method_10069(x, 0, z);
                class_2680 blockState = world.method_8320(currentPos);
                if (!blockState.method_26215() && !blockState.method_45474()) continue;
                if (storedWater <= 0) break;
                world.method_8652(currentPos, class_2246.field_10382.method_9564(), 3);
                ++waterPlaced;
                --storedWater;
            }
            if (storedWater <= 0) break;
        }
        if (waterPlaced > 0) {
            SpongeBootItem.setStorageWater(stack, SpongeBootItem.getStorageWater(stack) - waterPlaced);
        }
    }

    public static void setIsSponge(class_1799 itemStack, boolean b) {
        itemStack.method_57379(IS_SPONGE, (Object)b);
    }

    public static boolean getIsSponge(class_1799 itemStack) {
        return (Boolean)itemStack.method_57824(IS_SPONGE);
    }

    public static boolean switchIsSponge(class_1799 itemStack) {
        boolean isSponge = !SpongeBootItem.getIsSponge(itemStack);
        itemStack.method_57379(IS_SPONGE, (Object)isSponge);
        return isSponge;
    }

    public static void setStorageWater(class_1799 itemStack, int water) {
        itemStack.method_57379(STORAGE_WATER, (Object)Math.min(100000, water));
    }

    public static int getStorageWater(class_1799 itemStack) {
        return (Integer)itemStack.method_57824(STORAGE_WATER);
    }
}

