/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.mixin;

import com.soybeani.items.item.HotWheelsItem;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class HotWheelsEntityMixin {
    private static final float HOT_WHEELS_HEIGHT = 0.5f;
    private static final float FIRE_DAMAGE = 4.0f;
    private static final int FIRE_DURATION = 100;
    private static final int PARTICLE_RANGE = 2;
    private static final int PARTICLE_COUNT = 5;

    @Inject(method={"getBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyBoundingBox(CallbackInfoReturnable<class_238> cir) {
        class_1309 livingEntity;
        HotWheelsEntityMixin hotWheelsEntityMixin = this;
        if (hotWheelsEntityMixin instanceof class_1309 && this.isWearingHotWheels(livingEntity = (class_1309)hotWheelsEntityMixin)) {
            class_238 original = (class_238)cir.getReturnValue();
            class_238 modified = new class_238(original.field_1323, original.field_1322 - 0.5, original.field_1321, original.field_1320, original.field_1325, original.field_1324);
            cir.setReturnValue((Object)modified);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        class_1309 livingEntity;
        HotWheelsEntityMixin hotWheelsEntityMixin = this;
        if (hotWheelsEntityMixin instanceof class_1309 && this.isWearingHotWheels(livingEntity = (class_1309)hotWheelsEntityMixin) && livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            this.generateFireParticlesAndDamageEntities(player);
            if (player.method_31549().field_7479) {
                this.destroyBlocksAndSetFire(player);
            }
        }
    }

    private void generateFireParticlesAndDamageEntities(class_1657 player) {
        class_5819 random = player.method_59922();
        class_1799 equippedStack = player.method_6118(class_1304.field_6166);
        boolean isFlame = false;
        if (this.isWearingHotWheels((class_1309)player)) {
            isFlame = HotWheelsItem.getFlame(equippedStack);
        }
        if (player.method_37908().field_9236) {
            double footHeight = player.method_19538().method_10214() - 0.2;
            class_243 lookDir = player.method_5720();
            class_243 rightVector = new class_243(-lookDir.field_1350, 0.0, lookDir.field_1352).method_1029().method_1021(0.2);
            player.method_37908().method_8406((class_2394)class_2398.field_11240, player.method_19538().method_10216() - rightVector.field_1352, footHeight, player.method_19538().method_10215() - rightVector.field_1350, 0.0, 0.0, 0.0);
            player.method_37908().method_8406((class_2394)class_2398.field_11240, player.method_19538().method_10216() + rightVector.field_1352, footHeight, player.method_19538().method_10215() + rightVector.field_1350, 0.0, 0.0, 0.0);
            if (isFlame) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                double offsetX = (random.method_43058() - 0.5) * 2.0 * 2.0;
                double offsetY = (random.method_43058() - 0.5) * 2.0 * 2.0;
                double offsetZ = (random.method_43058() - 0.5) * 2.0 * 2.0;
                player.method_37908().method_8406((class_2394)class_2398.field_11240, player.method_19538().method_10216() + offsetX, player.method_19538().method_10214() + offsetY, player.method_19538().method_10215() + offsetZ, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (isFlame) {
            return;
        }
        class_238 damageBox = player.method_5829().method_1014(2.0);
        List nearbyEntities = player.method_37908().method_8335((class_1297)player, damageBox);
        for (class_1297 entity : nearbyEntities) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity instanceof class_1657) continue;
            entity.method_5643(player.method_48923().method_48813(), 4.0f);
            entity.method_20803(100);
            if (livingEntity == null) continue;
            livingEntity.method_6092(new class_1293(class_1294.field_5909, 100, 0));
        }
    }

    private boolean isWearingHotWheels(class_1309 entity) {
        class_1799 feetStack = entity.method_6118(class_1304.field_6166);
        return !feetStack.method_7960() && feetStack.method_7909() instanceof HotWheelsItem;
    }

    private void destroyBlocksAndSetFire(class_1657 player) {
        if (player.method_37908().field_9236) {
            return;
        }
        class_2338 playerPos = player.method_24515();
        class_2338 currentPos = playerPos.method_10074();
        class_2680 currentState = player.method_37908().method_8320(currentPos);
        if (!(currentState.method_26215() || currentState.method_27852(class_2246.field_10036) || currentState.method_51176() || currentState.method_27852(class_2246.field_9987))) {
            player.method_37908().method_8501(playerPos, class_2246.field_10036.method_9564());
        }
        if (player.method_31549().field_7479) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -2; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        class_2338 pos = playerPos.method_10069(x, y, z);
                        class_2680 state = player.method_37908().method_8320(pos);
                        if (state.method_26215() || state.method_27852(class_2246.field_9987) || state.method_51176()) continue;
                        player.method_37908().method_8651(pos, true, (class_1297)player);
                        class_2338 belowPos = pos.method_10074();
                        class_2680 belowState = player.method_37908().method_8320(belowPos);
                        if (belowState.method_26215() || belowState.method_27852(class_2246.field_10036) || belowState.method_51176() || belowState.method_27852(class_2246.field_9987)) continue;
                        player.method_37908().method_8501(belowPos.method_10084(), class_2246.field_10036.method_9564());
                    }
                }
            }
        }
    }
}

