/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.mixin.client;

import com.mojang.authlib.GameProfile;
import com.soybeani.animation.AnimationOverhaul;
import com.soybeani.animation.api.AnimationHolder;
import com.soybeani.animation.api.ILeanablePlayer;
import com.soybeani.animation.config.AnimationsConfig;
import com.soybeani.animation.registry.AOAnimationInstance;
import com.soybeani.items.item.KindSwordItem;
import com.soybeani.items.item.WaterGunItem;
import com.soybeani.items.weapon.GunItem;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import net.minecraft.class_1657;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements ILeanablePlayer {
    @Unique
    private final ModifierLayer<IAnimation> CONTAINER = new ModifierLayer();
    public AnimationHolder anim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_run = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_right = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_left = AnimationHolder.EMPTY;
    public AnimationHolder anim_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_slow_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_landing = AnimationHolder.EMPTY;
    public AnimationHolder anim_swimming = AnimationHolder.EMPTY;
    public AnimationHolder anim_swim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawl_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawling = AnimationHolder.EMPTY;
    public AnimationHolder anim_eating = AnimationHolder.EMPTY;
    public AnimationHolder anim_drinking = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sprint_stop = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_edge_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_elytra_fly = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel_sneak = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_left_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_right_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_forward = AnimationHolder.EMPTY;
    public AnimationHolder anim_rolling = AnimationHolder.EMPTY;
    public AnimationHolder[] anim_jump = new AnimationHolder[2];
    public AnimationHolder[] anim_fall = new AnimationHolder[2];
    public AnimationHolder[] anim_punch = new AnimationHolder[2];
    public AnimationHolder[] anim_punch_sneaking = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing_sneak = new AnimationHolder[2];
    public AnimationHolder[] fingers_crossing = new AnimationHolder[2];
    public AnimationHolder aim_double = AnimationHolder.EMPTY;
    public AnimationHolder fire_double = AnimationHolder.EMPTY;
    public int punch_index = 0;
    public int jump_index = 0;
    public float leanAmount = 0.0f;
    public float leanMultiplier = 1.0f;
    public float realLeanMultiplier = 1.0f;
    public float squash = 0.0f;
    public float realSquash = 0.0f;
    public float momentum = 0.0f;
    public AnimationsConfig ANIMS = AnimationOverhaul.ANIM_CONFIG;
    public float turnDelta = 0.0f;
    public class_243 lastPos = new class_243(0.0, 0.0, 0.0);
    public boolean lastOnGround = false;
    public boolean hasSlowFall = false;
    private int tickCounter = 0;
    KeyframeAnimation currentAnimation = null;
    private boolean modified = false;
    private boolean armAnimationsEnabled = true;

    public AbstractClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    private AnimationHolder validateHolder(AnimationHolder holder) {
        if (holder == null) {
            throw new RuntimeException("Missing animation from config! Your config is corrupt, you might have deleted some animations.");
        }
        return holder;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void animation_overhaul$init(class_638 world, GameProfile profile, CallbackInfo info) {
        PlayerAnimationAccess.getPlayerAnimLayer((class_742)((class_742)this)).addAnimLayer(1, this.CONTAINER);
        AOAnimationInstance.States cfg = this.ANIMS.enabled_animations;
        this.anim_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"idle"), cfg.idle.enabled));
        this.anim_fall[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fall_first"), cfg.fall.enabled));
        this.anim_fall[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fall_second"), cfg.fall.enabled));
        this.anim_jump[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"jump_first"), cfg.jump.enabled));
        this.anim_jump[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"jump_second"), cfg.jump.enabled));
        this.anim_sneak_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sneak_idle"), cfg.sneak_idle.enabled));
        this.anim_sneak_walk = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sneak_walk"), cfg.sneak_walk.enabled));
        this.anim_walk = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"walking"), cfg.walk.enabled));
        this.anim_run = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"running"), cfg.run.enabled));
        this.anim_turn_right = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"turn_right"), cfg.turn_right.enabled));
        this.anim_turn_left = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"turn_left"), cfg.turn_left.enabled));
        this.anim_punch[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"punch_right"), cfg.punch.enabled));
        this.anim_punch[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"punch_left"), cfg.punch.enabled));
        this.anim_punch_sneaking[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"punch_right_sneak"), cfg.punch_sneaking.enabled));
        this.anim_punch_sneaking[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"punch_left_sneak"), cfg.punch_sneaking.enabled));
        this.anim_sword_swing[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sword_swing_first"), cfg.sword_swing.enabled));
        this.anim_sword_swing[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sword_swing_second"), cfg.sword_swing.enabled));
        this.anim_sword_swing_sneak[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sword_swing_sneak_first"), cfg.sword_swing_sneak.enabled));
        this.anim_sword_swing_sneak[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sword_swing_sneak_second"), cfg.sword_swing_sneak.enabled));
        this.anim_falling = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"falling"), cfg.falling.enabled));
        this.anim_slow_falling = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"slow_falling"), cfg.slow_falling.enabled));
        this.anim_landing = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"landing"), cfg.landing.enabled));
        this.anim_swimming = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"swimming"), cfg.swimming.enabled));
        this.anim_swim_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"swim_idle"), cfg.swim_idle.enabled));
        this.anim_crawl_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"crawl_idle"), cfg.crawl_idle.enabled));
        this.anim_crawling = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"crawling"), cfg.crawling.enabled));
        this.anim_eating = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"eating"), cfg.eating.enabled));
        this.anim_drinking = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"drinking"), cfg.drinking.enabled));
        this.anim_climbing = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"climbing"), cfg.climbing.enabled));
        this.anim_climbing_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"climbing_idle"), cfg.climbing_idle.enabled));
        this.anim_sprint_stop = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"sprint_stop"), cfg.sprint_stop.enabled));
        this.anim_fence_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fence_idle"), cfg.fence_idle.enabled));
        this.anim_fence_walk = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fence_walk"), cfg.fence_walk.enabled));
        this.anim_edge_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"edge_idle"), cfg.edge_idle.enabled));
        this.anim_elytra_fly = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"elytra_fly"), cfg.elytra_fly.enabled));
        this.anim_flint_and_steel = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"flint_and_steel"), cfg.flint_and_steel.enabled));
        this.anim_flint_and_steel_sneak = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"flint_and_steel_sneak"), cfg.flint_and_steel_sneak.enabled));
        this.anim_boat_idle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"boat_idle"), cfg.boat_idle.enabled));
        this.anim_boat_forward = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"boat_forward"), cfg.boat_forward.enabled));
        this.anim_boat_right_paddle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"boat_right_paddle"), cfg.boat_right_paddle.enabled));
        this.anim_boat_left_paddle = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"boat_left_paddle"), cfg.boat_left_paddle.enabled));
        this.anim_rolling = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"rolling"), cfg.rolling.enabled));
        this.fingers_crossing[0] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fingers_crossing_first"), cfg.fingers_crossing.enabled));
        this.fingers_crossing[1] = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fingers_crossing_second"), cfg.fingers_crossing.enabled));
        this.aim_double = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"aim_double"), cfg.aim_double.enabled));
        this.fire_double = this.validateHolder(new AnimationHolder(class_2960.method_60655((String)"fun_item", (String)"fire_double"), cfg.fire_double.enabled));
    }

    public class_742 _this() {
        return (class_742)this;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        class_742 clientPlayerEntity = this._this();
        if (clientPlayerEntity.method_5765()) {
            return;
        }
        boolean onGround = clientPlayerEntity.method_24828();
        class_243 pos = this._this().method_19538();
        float delta = 0.05f;
        AnimationHolder animationToPlay = AnimationHolder.EMPTY;
        if (!(this._this().field_6252 && this._this().field_6279 >= 0 || !onGround || clientPlayerEntity.method_5765())) {
            this.enableArmAnimations();
        }
        boolean isUsingFlintAndSteel = false;
        boolean waterGunMode = false;
        boolean isTargetAnimation = false;
        if (this._this().method_6047() != null) {
            class_1799 mainHandStack = this._this().method_6047();
            class_1792 item = mainHandStack.method_7909();
            if (item instanceof class_1786 && (this._this().field_6252 || this._this().field_6279 > 0 || this._this().method_6115())) {
                isUsingFlintAndSteel = true;
                AnimationHolder animationHolder = animationToPlay = this._this().method_5715() ? this.anim_flint_and_steel_sneak : this.anim_flint_and_steel;
                if (animationToPlay != null && animationToPlay.isEnabled()) {
                    this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
                    isTargetAnimation = true;
                }
            }
            if (item instanceof WaterGunItem) {
                int mode = WaterGunItem.getMode(mainHandStack);
                if (mode == 2) {
                    animationToPlay = this.aim_double;
                }
                if (mode == 3) {
                    animationToPlay = this.fire_double;
                }
                if (animationToPlay != null && animationToPlay.isEnabled()) {
                    this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade(), FirstPersonMode.THIRD_PERSON_MODEL);
                    this._this().field_6283 = this._this().field_6241;
                    isTargetAnimation = true;
                }
            }
            if (item instanceof KindSwordItem) {
                int kindMode = KindSwordItem.getKindMode(mainHandStack);
                if (kindMode == 1 || kindMode == 2) {
                    animationToPlay = this.fingers_crossing[1];
                }
                if (animationToPlay != null && animationToPlay.isEnabled()) {
                    this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade(), FirstPersonMode.THIRD_PERSON_MODEL);
                    this._this().field_6283 = this._this().field_6241;
                    isTargetAnimation = true;
                }
            }
        }
        if (!isTargetAnimation) {
            animationToPlay = this.anim_idle;
            this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
        }
        if (!isUsingFlintAndSteel) {
            if (this.currentAnimation != null && (this.currentAnimation == this.anim_flint_and_steel.getAnimation() || this.currentAnimation == this.anim_flint_and_steel_sneak.getAnimation())) {
                this.currentAnimation = null;
            }
            this.enableArmAnimations();
        }
        this.lastPos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
        this.lastOnGround = onGround;
    }

    public void playAnimation(KeyframeAnimation anim) {
        this.playAnimation(anim, 1.0f, 10);
    }

    public void playAnimation(KeyframeAnimation anim, float speed, int fade, FirstPersonMode firstPersonMode) {
        this.playAnimation(this.CONTAINER, anim, speed, fade, firstPersonMode);
    }

    public void playAnimation(KeyframeAnimation anim, float speed, int fade) {
        this.playAnimation(this.CONTAINER, anim, speed, fade, FirstPersonMode.VANILLA);
    }

    public void playAnimation(ModifierLayer<IAnimation> container, KeyframeAnimation anim, float speed, int fade, FirstPersonMode firstPersonMode) {
        if (this.currentAnimation == anim || anim == null) {
            return;
        }
        this.currentAnimation = anim;
        KeyframeAnimation.AnimationBuilder builder = anim.mutableCopy();
        builder.leftArm.setEnabled(this.armAnimationsEnabled);
        builder.rightArm.setEnabled(this.armAnimationsEnabled);
        builder.leftLeg.setEnabled(false);
        builder.rightLeg.setEnabled(false);
        if (firstPersonMode == FirstPersonMode.THIRD_PERSON_MODEL) {
            // empty if block
        }
        anim = builder.build();
        if (this.modified) {
            container.removeModifier(0);
        }
        this.modified = true;
        container.addModifierBefore((AbstractModifier)new SpeedModifier(speed));
        container.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fade, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(anim).setFirstPersonMode(firstPersonMode).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftArm(true).setShowRightItem(true).setShowLeftItem(true)));
        container.setupAnim(0.05f);
    }

    public void disableArmAnimations() {
        if (this.currentAnimation != null && this.armAnimationsEnabled) {
            this.armAnimationsEnabled = false;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(false);
            builder.rightArm.setEnabled(false);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this._this().method_6029()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
            animationContainer.setupAnim(0.05f);
            animationContainer.tick();
        }
    }

    @Unique
    public void enableArmAnimations() {
        if (this.currentAnimation != null && !this.armAnimationsEnabled) {
            this.armAnimationsEnabled = true;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(true);
            builder.rightArm.setEnabled(true);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this._this().method_6029()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
        }
    }

    public void playJumpAnimation() {
        this.realLeanMultiplier = 0.0f;
        this.realSquash = -0.1f;
        ++this.jump_index;
        this.jump_index %= 2;
        AnimationHolder anim = this.anim_jump[this.jump_index];
        if (anim != null && anim.isEnabled()) {
            this.playAnimation(this.CONTAINER, anim.getAnimation(), anim.getSpeed(), anim.getFade(), FirstPersonMode.THIRD_PERSON_MODEL);
        }
    }

    @Override
    public float getLeanAmount() {
        return this.leanAmount * 0.01f;
    }

    @Override
    public float getLeanMultiplier() {
        return this.leanMultiplier;
    }

    @Override
    public float getSquash() {
        return this.squash;
    }

    @Inject(method={"getFovMultiplier"}, at={@At(value="TAIL")}, cancellable=true)
    public void zoomLevel(CallbackInfoReturnable<Float> ci) {
        class_1799 gun = this.method_6047();
        if (gun.method_7909() instanceof GunItem && ((Boolean)gun.method_57824(GunItem.isAiming)).booleanValue()) {
            if (((Boolean)gun.method_57824(GunItem.isScope)).booleanValue()) {
                ci.setReturnValue((Object)Float.valueOf(0.125f));
            } else {
                ci.setReturnValue((Object)Float.valueOf(0.75f));
            }
        }
    }
}

