/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.mixin.client;

import com.soybeani.animation.AnimationOverhaul;
import com.soybeani.animation.api.ILeanablePlayer;
import com.soybeani.animation.registry.ArmPoseRegister;
import com.soybeani.items.ItemsRegister;
import com.soybeani.items.item.GourdHelmetItem;
import com.soybeani.items.weapon.GunItem;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1007.class})
public abstract class PlayerEntityRendererMixin {
    @Shadow
    protected abstract void method_4218(class_742 var1);

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, cancellable=true)
    public void animation_overhaul$renderLeaning(class_742 player, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        class_310 mc = class_310.method_1551();
        if (!AnimationOverhaul.LOCAL_PLAYER_CONFIG.enable_leaning_and_squash || mc.field_1773 == null || player != mc.field_1724) {
            return;
        }
        if (!mc.field_1773.method_19418().method_19332() && player == mc.field_1724) {
            return;
        }
        matrixStack.method_22903();
        float lean_x = (float)player.method_60478().field_1350;
        float lean_z = -((float)player.method_60478().field_1352);
        float turnLeanAmount = ((ILeanablePlayer)player).getLeanAmount();
        float leanMultiplier = ((ILeanablePlayer)player).getLeanMultiplier();
        float player_squash = ((ILeanablePlayer)player).getSquash();
        player_squash = Math.clamp(player_squash, -1.0f, 1.0f) * 0.25f;
        float h_scale = 1.0f;
        float v_scale = 1.0f;
        float yaw = (float)Math.toRadians(player.method_43078() + 90.0f);
        lean_x = (float)((double)lean_x + Math.cos(yaw) * (double)turnLeanAmount);
        lean_z = (float)((double)lean_z + Math.sin(yaw) * (double)turnLeanAmount);
        lean_x *= leanMultiplier;
        lean_z *= leanMultiplier;
        if (player.method_6128()) {
            lean_x = 0.0f;
            lean_z = 0.0f;
            h_scale = 1.0f;
            v_scale = 1.0f;
        }
        Quaternionf quat = new Quaternionf();
        quat = new Matrix4f().rotate(lean_x, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).rotate(lean_z, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).getNormalizedRotation(quat);
        matrixStack.method_22903();
        matrixStack.method_22907(quat);
        matrixStack.method_22905(h_scale, v_scale, h_scale);
        this.method_4218(player);
        matrixStack.method_22909();
        ci.cancel();
    }

    @Inject(method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")})
    private void onRenderPre(class_742 player, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        if (player.method_6059(ItemsRegister.REVERSAL_EFFECT_ENTRY)) {
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 0.0f);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            matrixStack.method_46416(0.0f, -player.method_17682(), 0.0f);
        }
        if (player.method_6059(ItemsRegister.CHAOS_EFFECT_ENTRY)) {
            matrixStack.method_22903();
            float rotationAngle = player.method_37908().method_8510() % 36L * 10L;
            if (player.method_6112(ItemsRegister.CHAOS_EFFECT_ENTRY).method_5578() >= 4) {
                matrixStack.method_46416(0.0f, 1.0f, 0.0f);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotationAngle));
                matrixStack.method_46416(0.0f, -1.0f, 0.0f);
            } else {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationAngle));
            }
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="RETURN")})
    private void onRenderPost(class_742 player, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        if (player.method_6059(ItemsRegister.REVERSAL_EFFECT_ENTRY) || player.method_6059(ItemsRegister.CHAOS_EFFECT_ENTRY)) {
            matrixStack.method_22909();
        }
    }

    @Inject(method={"scale"}, at={@At(value="HEAD")}, cancellable=true)
    protected void scale(class_742 abstractClientPlayerEntity, class_4587 matrixStack, float f, CallbackInfo ci) {
        class_1792 class_17922 = abstractClientPlayerEntity.method_6118(class_1304.field_6169).method_7909();
        if (class_17922 instanceof GourdHelmetItem) {
            GourdHelmetItem gourdHelmetItem = (GourdHelmetItem)class_17922;
            class_1799 equippedStack = abstractClientPlayerEntity.method_6118(class_1304.field_6169);
            if (gourdHelmetItem.getColor() == GourdHelmetItem.COLOR.RED.getColor()) {
                float scale = GourdHelmetItem.getSize(equippedStack);
                matrixStack.method_22905(scale, scale, scale);
                ci.cancel();
            }
        }
    }

    @Inject(method={"getArmPose"}, at={@At(value="TAIL")}, cancellable=true)
    private static void gunPose(class_742 player, class_1268 hand, CallbackInfoReturnable<class_572.class_573> ci) {
        class_1792 class_17922;
        if (hand == class_1268.field_5808 && (class_17922 = player.method_5998(hand).method_7909()) instanceof GunItem) {
            GunItem gun = (GunItem)class_17922;
            if ((Integer)player.method_5998(hand).method_57824(GunItem.reloadTick) > 0) {
                ci.setReturnValue((Object)class_572.class_573.field_3405);
                return;
            }
            if (GunItem.isLoaded(player.method_5998(hand)) && !player.method_5624()) {
                GunItem.ArmType armType = gun.getArmType();
                switch (armType) {
                    case HANDGUN_ONEHAND: {
                        ci.setReturnValue((Object)ArmPoseRegister.HANDGUN_ONEHAND);
                        break;
                    }
                    case HANDGUN_TWOHAND: {
                        ci.setReturnValue((Object)ArmPoseRegister.HANDGUN_TWOHAND);
                        break;
                    }
                    case LONG_GUNS: {
                        ci.setReturnValue((Object)ArmPoseRegister.LONG_GUNS);
                        break;
                    }
                    case REVOLVER_FANNING: {
                        ci.setReturnValue((Object)ArmPoseRegister.REVOLVER_FANNING);
                        break;
                    }
                    case MINIGUN: {
                        ci.setReturnValue((Object)ArmPoseRegister.MINIGUN);
                    }
                }
            }
        }
    }
}

