/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.armor;

import com.coolerpromc.moregears.util.MGTags;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.neoforge.common.Tags;

public class MGArmorMaterials {
    public static final ArmorMaterial COPPER_ARMOR_MATERIAL = MGArmorMaterials.register("copper", 15, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 2);
        map.put(ArmorType.LEGGINGS, 4);
        map.put(ArmorType.CHESTPLATE, 6);
        map.put(ArmorType.HELMET, 2);
        map.put(ArmorType.BODY, 4);
    }), 12, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, (TagKey<Item>)Tags.Items.INGOTS_COPPER, 0.0f, 0.0f);
    public static final ArmorMaterial BRONZE_ARMOR_MATERIAL = MGArmorMaterials.register("bronze", 22, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 3);
        map.put(ArmorType.LEGGINGS, 5);
        map.put(ArmorType.CHESTPLATE, 7);
        map.put(ArmorType.HELMET, 2);
        map.put(ArmorType.BODY, 7);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, MGTags.Items.INGOTS_BRONZE, 0.0f, 0.0f);
    public static final ArmorMaterial STEEL_ARMOR_MATERIAL = MGArmorMaterials.register("steel", 30, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 3);
        map.put(ArmorType.LEGGINGS, 6);
        map.put(ArmorType.CHESTPLATE, 8);
        map.put(ArmorType.HELMET, 3);
        map.put(ArmorType.BODY, 10);
    }), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, MGTags.Items.INGOTS_STEEL, 1.5f, 0.0f);
    public static final ArmorMaterial RUBY_ARMOR_MATERIAL = MGArmorMaterials.register("ruby", 28, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 3);
        map.put(ArmorType.LEGGINGS, 6);
        map.put(ArmorType.CHESTPLATE, 7);
        map.put(ArmorType.HELMET, 3);
        map.put(ArmorType.BODY, 9);
    }), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, MGTags.Items.GEMS_RUBY, 1.0f, 0.0f);
    public static final ArmorMaterial TITANIUM_ARMOR_MATERIAL = MGArmorMaterials.register("titanium", 45, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 4);
        map.put(ArmorType.LEGGINGS, 7);
        map.put(ArmorType.CHESTPLATE, 9);
        map.put(ArmorType.HELMET, 4);
        map.put(ArmorType.BODY, 12);
    }), 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, MGTags.Items.INGOTS_TITANIUM, 4.0f, 0.5f);
    public static final ArmorMaterial ENDERITE_ARMOR_MATERIAL = MGArmorMaterials.register("enderite", Integer.MAX_VALUE, (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 5);
        map.put(ArmorType.LEGGINGS, 8);
        map.put(ArmorType.CHESTPLATE, 10);
        map.put(ArmorType.HELMET, 5);
        map.put(ArmorType.BODY, 13);
    }), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, MGTags.Items.INGOTS_ENDERITE, 5.0f, 1.0f);

    private static ArmorMaterial register(String name, int durability, EnumMap<ArmorType, Integer> typeProtection, int enchantmentValue, Holder<SoundEvent> equipSound, TagKey<Item> ingredient, float toughness, float knockbackResistance) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)name);
        ResourceKey layers = ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)location);
        EnumMap<ArmorType, Integer> typeMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
        for (ArmorType type : ArmorType.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return new ArmorMaterial(durability, typeMap, enchantmentValue, equipSound, toughness, knockbackResistance, ingredient, layers);
    }
}

