/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.trim;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public class MGTrimMaterials {
    public static final ResourceKey<TrimMaterial> TIN = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"tin"));
    public static final ResourceKey<TrimMaterial> BRONZE = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"bronze"));
    public static final ResourceKey<TrimMaterial> STEEL = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"steel"));
    public static final ResourceKey<TrimMaterial> RUBY = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"ruby"));
    public static final ResourceKey<TrimMaterial> TITANIUM = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"titanium"));
    public static final ResourceKey<TrimMaterial> ENDERITE = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"enderite"));
    public static final MaterialAssetGroup TIN_ASSET_GROUP = MaterialAssetGroup.create((String)"tin");
    public static final MaterialAssetGroup BRONZE_ASSET_GROUP = MaterialAssetGroup.create((String)"bronze");
    public static final MaterialAssetGroup STEEL_ASSET_GROUP = MaterialAssetGroup.create((String)"steel");
    public static final MaterialAssetGroup RUBY_ASSET_GROUP = MaterialAssetGroup.create((String)"ruby");
    public static final MaterialAssetGroup TITANIUM_ASSET_GROUP = MaterialAssetGroup.create((String)"titanium");
    public static final MaterialAssetGroup ENDERITE_ASSET_GROUP = MaterialAssetGroup.create((String)"enderite");
    public static final List<MaterialAssetGroup> MATERIAL_ASSET_GROUPS = List.of(TIN_ASSET_GROUP, BRONZE_ASSET_GROUP, STEEL_ASSET_GROUP, RUBY_ASSET_GROUP, TITANIUM_ASSET_GROUP, ENDERITE_ASSET_GROUP);

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        MGTrimMaterials.register(context, TIN, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#9dc6e0").getOrThrow()), TIN_ASSET_GROUP);
        MGTrimMaterials.register(context, BRONZE, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#f1c232").getOrThrow()), BRONZE_ASSET_GROUP);
        MGTrimMaterials.register(context, STEEL, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#6e6b6b").getOrThrow()), STEEL_ASSET_GROUP);
        MGTrimMaterials.register(context, RUBY, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#E0115F").getOrThrow()), RUBY_ASSET_GROUP);
        MGTrimMaterials.register(context, TITANIUM, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#9e6590").getOrThrow()), TITANIUM_ASSET_GROUP);
        MGTrimMaterials.register(context, ENDERITE, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#5D3391").getOrThrow()), ENDERITE_ASSET_GROUP);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> trimKey, Style style, MaterialAssetGroup materialAssetGroup) {
        MutableComponent component = Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)trimKey.location())).withStyle(style);
        context.register(trimKey, (Object)new TrimMaterial(materialAssetGroup, (Component)component));
    }
}

