/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears;

import com.coolerpromc.moregears.Config;
import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.block.entity.MGBlockEntities;
import com.coolerpromc.moregears.datagen.property.Arrow;
import com.coolerpromc.moregears.entity.MGEntities;
import com.coolerpromc.moregears.entity.renderer.MGArrowRenderer;
import com.coolerpromc.moregears.item.MGCreativeTab;
import com.coolerpromc.moregears.item.MGItems;
import com.coolerpromc.moregears.recipe.MGRecipes;
import com.coolerpromc.moregears.screen.MGMenuTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterSelectItemModelPropertyEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@Mod(value="moregears")
public class MoreGears {
    public static final String MODID = "moregears";

    public MoreGears(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        MGEntities.register(modEventBus);
        MGItems.register(modEventBus);
        MGBlocks.register(modEventBus);
        MGBlockEntities.register(modEventBus);
        MGCreativeTab.register(modEventBus);
        MGRecipes.register(modEventBus);
        MGMenuTypes.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DispenserBlock.registerProjectileBehavior(MGItems.COPPER_ARROW);
        DispenserBlock.registerProjectileBehavior(MGItems.BRONZE_ARROW);
        DispenserBlock.registerProjectileBehavior(MGItems.STEEL_ARROW);
        DispenserBlock.registerProjectileBehavior(MGItems.RUBY_ARROW);
        DispenserBlock.registerProjectileBehavior(MGItems.TITANIUM_ARROW);
        DispenserBlock.registerProjectileBehavior(MGItems.ENDERITE_ARROW);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onOnDatapackSync(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{(RecipeType)MGRecipes.ALLOY_SMELTING_TYPE.get()});
    }

    @EventBusSubscriber(modid="moregears", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void onEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)MGEntities.COPPER_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("copper_arrow")));
            event.registerEntityRenderer((EntityType)MGEntities.BRONZE_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("bronze_arrow")));
            event.registerEntityRenderer((EntityType)MGEntities.STEEL_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("steel_arrow")));
            event.registerEntityRenderer((EntityType)MGEntities.RUBY_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("ruby_arrow")));
            event.registerEntityRenderer((EntityType)MGEntities.TITANIUM_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("titanium_arrow")));
            event.registerEntityRenderer((EntityType)MGEntities.ENDERITE_ARROW.get(), context -> new MGArrowRenderer(context, MGArrowRenderer.getTextureLocation("enderite_arrow")));
        }

        @SubscribeEvent
        public static void onRegisterSelectItemModelProperty(RegisterSelectItemModelPropertyEvent event) {
            event.register(ResourceLocation.fromNamespaceAndPath((String)MoreGears.MODID, (String)"select_bow"), Arrow.TYPE);
        }
    }
}

