/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.coolerpromc.moregears.armor.MGArmorItem;
import com.coolerpromc.moregears.armor.MGArmorMaterials;
import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.datagen.property.Arrow;
import com.coolerpromc.moregears.item.MGItems;
import com.coolerpromc.moregears.item.custom.MGArrowItem;
import com.coolerpromc.moregears.trim.MGTrimMaterials;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.UseDuration;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.TrimMaterialProperty;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class MGModelProvider
extends ModelProvider {
    public final ResourceLocation RAW_ORE = this.itemLocation("template_raw_ore");
    public final ResourceLocation INGOT = this.itemLocation("template_ingot");
    public final ResourceLocation GEM = this.itemLocation("template_gem");
    public static final List<ItemModelGenerators.TrimMaterialData> TRIM_MATERIAL_MODELS = List.of(new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.QUARTZ, TrimMaterials.QUARTZ), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.IRON, TrimMaterials.IRON), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.NETHERITE, TrimMaterials.NETHERITE), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.REDSTONE, TrimMaterials.REDSTONE), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.COPPER, TrimMaterials.COPPER), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.GOLD, TrimMaterials.GOLD), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.EMERALD, TrimMaterials.EMERALD), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.DIAMOND, TrimMaterials.DIAMOND), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.LAPIS, TrimMaterials.LAPIS), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.AMETHYST, TrimMaterials.AMETHYST), new ItemModelGenerators.TrimMaterialData(MaterialAssetGroup.RESIN, TrimMaterials.RESIN), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.TIN_ASSET_GROUP, MGTrimMaterials.TIN), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.BRONZE_ASSET_GROUP, MGTrimMaterials.BRONZE), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.STEEL_ASSET_GROUP, MGTrimMaterials.STEEL), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.RUBY_ASSET_GROUP, MGTrimMaterials.RUBY), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.TITANIUM_ASSET_GROUP, MGTrimMaterials.TITANIUM), new ItemModelGenerators.TrimMaterialData(MGTrimMaterials.ENDERITE_ASSET_GROUP, MGTrimMaterials.ENDERITE));
    public static final ResourceLocation MOD_TRIM_PREFIX_HELMET = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"item/helmet_trim");
    public static final ResourceLocation MOD_TRIM_PREFIX_CHESTPLATE = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"item/chestplate_trim");
    public static final ResourceLocation MOD_TRIM_PREFIX_LEGGINGS = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"item/leggings_trim");
    public static final ResourceLocation MOD_TRIM_PREFIX_BOOTS = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"item/boots_trim");

    public MGModelProvider(PackOutput output) {
        super(output, "moregears");
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        this.registerBlockState(blockModels);
        this.registerItemModels(itemModels);
    }

    private void registerBlockState(BlockModelGenerators blockModels) {
        this.simpleBlockWithItem(blockModels, MGBlocks.TIN_ORE);
        this.simpleBlockWithItem(blockModels, MGBlocks.DEEPSLATE_TIN_ORE);
        this.simpleBlockWithItem(blockModels, MGBlocks.RUBY_ORE);
        this.simpleBlockWithItem(blockModels, MGBlocks.DEEPSLATE_RUBY_ORE);
        this.simpleBlockWithItem(blockModels, MGBlocks.NETHER_TITANIUM_ORE);
        this.simpleBlockWithItem(blockModels, MGBlocks.END_ENDERITE_ORE);
        this.horizontalRotationBlock(blockModels, MGBlocks.ALLOY_SMELTER);
    }

    private void registerItemModels(ItemModelGenerators itemModels) {
        this.basicItem(itemModels, MGItems.RAW_TIN);
        this.basicItem(itemModels, MGItems.RAW_RUBY);
        this.basicItem(itemModels, MGItems.RAW_TITANIUM);
        this.basicItem(itemModels, MGItems.RAW_ENDERITE);
        this.basicItem(itemModels, MGItems.TIN_INGOT);
        this.basicItem(itemModels, MGItems.BRONZE_INGOT);
        this.basicItem(itemModels, MGItems.STEEL_INGOT);
        this.basicItem(itemModels, MGItems.RUBY_INGOT);
        this.basicItem(itemModels, MGItems.TITANIUM_INGOT);
        this.basicItem(itemModels, MGItems.ENDERITE_INGOT);
        this.trimmedArmorItem(itemModels, Items.TURTLE_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.TURTLE_SCUTE, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.LEATHER_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.LEATHER, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, true);
        this.trimmedArmorItem(itemModels, Items.LEATHER_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.LEATHER, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, true);
        this.trimmedArmorItem(itemModels, Items.LEATHER_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.LEATHER, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, true);
        this.trimmedArmorItem(itemModels, Items.LEATHER_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.LEATHER, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, true);
        this.trimmedArmorItem(itemModels, Items.CHAINMAIL_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.CHAINMAIL, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.CHAINMAIL_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.CHAINMAIL, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, false);
        this.trimmedArmorItem(itemModels, Items.CHAINMAIL_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.CHAINMAIL, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, false);
        this.trimmedArmorItem(itemModels, Items.CHAINMAIL_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.CHAINMAIL, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, false);
        this.trimmedArmorItem(itemModels, Items.IRON_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.IRON, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.IRON_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.IRON, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, false);
        this.trimmedArmorItem(itemModels, Items.IRON_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.IRON, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, false);
        this.trimmedArmorItem(itemModels, Items.IRON_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.IRON, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, false);
        this.trimmedArmorItem(itemModels, Items.DIAMOND_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.DIAMOND, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.DIAMOND_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.DIAMOND, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, false);
        this.trimmedArmorItem(itemModels, Items.DIAMOND_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.DIAMOND, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, false);
        this.trimmedArmorItem(itemModels, Items.DIAMOND_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.DIAMOND, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, false);
        this.trimmedArmorItem(itemModels, Items.GOLDEN_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.GOLD, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.GOLDEN_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.GOLD, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, false);
        this.trimmedArmorItem(itemModels, Items.GOLDEN_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.GOLD, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, false);
        this.trimmedArmorItem(itemModels, Items.GOLDEN_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.GOLD, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, false);
        this.trimmedArmorItem(itemModels, Items.NETHERITE_HELMET, (ResourceKey<EquipmentAsset>)EquipmentAssets.NETHERITE, ItemModelGenerators.TRIM_PREFIX_HELMET, MOD_TRIM_PREFIX_HELMET, false);
        this.trimmedArmorItem(itemModels, Items.NETHERITE_CHESTPLATE, (ResourceKey<EquipmentAsset>)EquipmentAssets.NETHERITE, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, MOD_TRIM_PREFIX_CHESTPLATE, false);
        this.trimmedArmorItem(itemModels, Items.NETHERITE_LEGGINGS, (ResourceKey<EquipmentAsset>)EquipmentAssets.NETHERITE, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, MOD_TRIM_PREFIX_LEGGINGS, false);
        this.trimmedArmorItem(itemModels, Items.NETHERITE_BOOTS, (ResourceKey<EquipmentAsset>)EquipmentAssets.NETHERITE, ItemModelGenerators.TRIM_PREFIX_BOOTS, MOD_TRIM_PREFIX_BOOTS, false);
        this.trimmedArmorItem(itemModels, MGItems.COPPER_HELMET, MGArmorMaterials.COPPER_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.COPPER_CHESTPLATE, MGArmorMaterials.COPPER_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.COPPER_LEGGINGS, MGArmorMaterials.COPPER_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.COPPER_BOOTS, MGArmorMaterials.COPPER_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.BRONZE_HELMET, MGArmorMaterials.BRONZE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.BRONZE_CHESTPLATE, MGArmorMaterials.BRONZE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.BRONZE_LEGGINGS, MGArmorMaterials.BRONZE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.BRONZE_BOOTS, MGArmorMaterials.BRONZE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.STEEL_HELMET, MGArmorMaterials.STEEL_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.STEEL_CHESTPLATE, MGArmorMaterials.STEEL_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.STEEL_LEGGINGS, MGArmorMaterials.STEEL_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.STEEL_BOOTS, MGArmorMaterials.STEEL_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.RUBY_HELMET, MGArmorMaterials.RUBY_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.RUBY_CHESTPLATE, MGArmorMaterials.RUBY_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.RUBY_LEGGINGS, MGArmorMaterials.RUBY_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.RUBY_BOOTS, MGArmorMaterials.RUBY_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.TITANIUM_HELMET, MGArmorMaterials.TITANIUM_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.TITANIUM_CHESTPLATE, MGArmorMaterials.TITANIUM_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.TITANIUM_LEGGINGS, MGArmorMaterials.TITANIUM_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.TITANIUM_BOOTS, MGArmorMaterials.TITANIUM_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.ENDERITE_HELMET, MGArmorMaterials.ENDERITE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.ENDERITE_CHESTPLATE, MGArmorMaterials.ENDERITE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.ENDERITE_LEGGINGS, MGArmorMaterials.ENDERITE_ARMOR_MATERIAL);
        this.trimmedArmorItem(itemModels, MGItems.ENDERITE_BOOTS, MGArmorMaterials.ENDERITE_ARMOR_MATERIAL);
        this.basicItem(itemModels, MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE);
        this.basicItem(itemModels, MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE);
        this.handheldItem(itemModels, MGItems.COPPER_SWORD);
        this.handheldItem(itemModels, MGItems.COPPER_SHOVEL);
        this.handheldItem(itemModels, MGItems.COPPER_PICKAXE);
        this.handheldItem(itemModels, MGItems.COPPER_AXE);
        this.handheldItem(itemModels, MGItems.COPPER_HOE);
        this.handheldItem(itemModels, MGItems.BRONZE_SWORD);
        this.handheldItem(itemModels, MGItems.BRONZE_SHOVEL);
        this.handheldItem(itemModels, MGItems.BRONZE_PICKAXE);
        this.handheldItem(itemModels, MGItems.BRONZE_AXE);
        this.handheldItem(itemModels, MGItems.BRONZE_HOE);
        this.handheldItem(itemModels, MGItems.STEEL_SWORD);
        this.handheldItem(itemModels, MGItems.STEEL_SHOVEL);
        this.handheldItem(itemModels, MGItems.STEEL_PICKAXE);
        this.handheldItem(itemModels, MGItems.STEEL_AXE);
        this.handheldItem(itemModels, MGItems.STEEL_HOE);
        this.handheldItem(itemModels, MGItems.RUBY_SWORD);
        this.handheldItem(itemModels, MGItems.RUBY_SHOVEL);
        this.handheldItem(itemModels, MGItems.RUBY_PICKAXE);
        this.handheldItem(itemModels, MGItems.RUBY_AXE);
        this.handheldItem(itemModels, MGItems.RUBY_HOE);
        this.handheldItem(itemModels, MGItems.TITANIUM_SWORD);
        this.handheldItem(itemModels, MGItems.TITANIUM_SHOVEL);
        this.handheldItem(itemModels, MGItems.TITANIUM_PICKAXE);
        this.handheldItem(itemModels, MGItems.TITANIUM_AXE);
        this.handheldItem(itemModels, MGItems.TITANIUM_HOE);
        this.handheldItem(itemModels, MGItems.ENDERITE_SWORD);
        this.handheldItem(itemModels, MGItems.ENDERITE_SHOVEL);
        this.handheldItem(itemModels, MGItems.ENDERITE_PICKAXE);
        this.handheldItem(itemModels, MGItems.ENDERITE_AXE);
        this.handheldItem(itemModels, MGItems.ENDERITE_HOE);
        this.basicItem(itemModels, MGItems.COPPER_ARROW);
        this.basicItem(itemModels, MGItems.BRONZE_ARROW);
        this.basicItem(itemModels, MGItems.STEEL_ARROW);
        this.basicItem(itemModels, MGItems.RUBY_ARROW);
        this.basicItem(itemModels, MGItems.TITANIUM_ARROW);
        this.basicItem(itemModels, MGItems.ENDERITE_ARROW);
        this.generateBow(itemModels, Items.BOW);
        this.generateBow(itemModels, (Item)MGItems.COPPER_BOW.get());
        this.generateBow(itemModels, (Item)MGItems.BRONZE_BOW.get());
        this.generateBow(itemModels, (Item)MGItems.STEEL_BOW.get());
        this.generateBow(itemModels, (Item)MGItems.RUBY_BOW.get());
        this.generateBow(itemModels, (Item)MGItems.TITANIUM_BOW.get());
        this.generateBow(itemModels, (Item)MGItems.ENDERITE_BOW.get());
    }

    private <T extends Block> void horizontalRotationBlock(BlockModelGenerators blockModels, DeferredBlock<T> block) {
        blockModels.createNonTemplateHorizontalBlock((Block)MGBlocks.ALLOY_SMELTER.get());
        blockModels.registerSimpleItemModel((Block)block.get(), this.blockLocation(this.getBlockName((Block)block.get())));
    }

    private <T extends Block> void simpleBlockWithItem(BlockModelGenerators blockModels, DeferredBlock<T> block) {
        blockModels.createTrivialCube((Block)block.get());
    }

    private void trimmedArmorItem(ItemModelGenerators itemModels, DeferredItem<MGArmorItem> item, ArmorMaterial armorMaterial) {
        this.generateTrimmableItem(itemModels, (Item)item.get(), (ResourceKey<EquipmentAsset>)armorMaterial.assetId(), ResourceLocation.parse((String)("trims/items/" + ((MGArmorItem)((Object)item.get())).getArmorType().getName() + "_trim")), ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("item/" + ((MGArmorItem)((Object)item.get())).getArmorType().getName() + "_trim")), false);
    }

    private void trimmedArmorItem(ItemModelGenerators itemModels, Item item, ResourceKey<EquipmentAsset> equipmentAsset, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, boolean tint) {
        this.generateTrimmableItem(itemModels, item, equipmentAsset, resourceLocation, resourceLocation2, false);
    }

    public void generateTrimmableItem(ItemModelGenerators itemModels, Item armorItem, ResourceKey<EquipmentAsset> equipmentAsset, ResourceLocation vanillaTrimLocation, ResourceLocation modTrimLocation, boolean tint) {
        ItemModel.Unbaked itemmodel$unbaked1;
        ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Item)armorItem);
        ResourceLocation resourcelocation1 = TextureMapping.getItemTexture((Item)armorItem);
        ResourceLocation resourcelocation2 = TextureMapping.getItemTexture((Item)armorItem, (String)"_overlay");
        ArrayList<SelectItemModel.SwitchCase> list = new ArrayList<SelectItemModel.SwitchCase>(TRIM_MATERIAL_MODELS.size());
        for (ItemModelGenerators.TrimMaterialData itemmodelgenerators$trimmaterialdata : TRIM_MATERIAL_MODELS) {
            ItemModel.Unbaked itemmodel$unbaked;
            ResourceLocation resourcelocation4;
            ResourceLocation resourcelocation3 = resourcelocation.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().base().suffix() + "_trim");
            ResourceLocation resourceLocation = resourcelocation4 = MGTrimMaterials.MATERIAL_ASSET_GROUPS.contains(itemmodelgenerators$trimmaterialdata.assets()) ? modTrimLocation.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().assetId(equipmentAsset).suffix()) : vanillaTrimLocation.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().assetId(equipmentAsset).suffix());
            if (tint) {
                itemModels.generateLayeredItem(resourcelocation3, resourcelocation1, resourcelocation2, resourcelocation4);
                itemmodel$unbaked = ItemModelUtils.tintedModel((ResourceLocation)resourcelocation3, (ItemTintSource[])new ItemTintSource[]{new Dye(-6265536)});
            } else {
                itemModels.generateLayeredItem(resourcelocation3, resourcelocation1, resourcelocation4);
                itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)resourcelocation3);
            }
            list.add(ItemModelUtils.when((Object)itemmodelgenerators$trimmaterialdata.materialKey(), (ItemModel.Unbaked)itemmodel$unbaked));
        }
        if (tint) {
            ModelTemplates.TWO_LAYERED_ITEM.create(resourcelocation, TextureMapping.layered((ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation2), itemModels.modelOutput);
            itemmodel$unbaked1 = ItemModelUtils.tintedModel((ResourceLocation)resourcelocation, (ItemTintSource[])new ItemTintSource[]{new Dye(-6265536)});
        } else {
            ModelTemplates.FLAT_ITEM.create(resourcelocation, TextureMapping.layer0((ResourceLocation)resourcelocation1), itemModels.modelOutput);
            itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)resourcelocation);
        }
        itemModels.itemModelOutput.accept(armorItem, ItemModelUtils.select((SelectItemModelProperty)new TrimMaterialProperty(), (ItemModel.Unbaked)itemmodel$unbaked1, list));
    }

    private <T extends Item> void basicItem(ItemModelGenerators itemModels, DeferredItem<T> item) {
        itemModels.generateFlatItem((Item)item.get(), ModelTemplates.FLAT_ITEM);
    }

    private <T extends Item> void handheldItem(ItemModelGenerators itemModels, DeferredItem<T> item) {
        TextureMapping textureMapping = new TextureMapping();
        textureMapping.put(TextureSlot.LAYER0, this.itemLocation(this.getItemName((Item)item.get())));
        itemModels.itemModelOutput.accept((Item)item.get(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelTemplates.FLAT_HANDHELD_ITEM.create((Item)item.get(), textureMapping, itemModels.modelOutput), List.of()));
    }

    public void generateBow(ItemModelGenerators itemModels, Item bowItem) {
        ItemModel.Unbaked baseModel = bowItem == Items.BOW ? ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)bowItem)) : ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "", ModelTemplates.BOW));
        ItemModel.Unbaked basePulling0 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked basePulling1 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked basePulling2 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked bronzePulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_bronze_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked bronzePulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_bronze_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked bronzePulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_bronze_arrow_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked copperPulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_copper_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked copperPulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_copper_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked copperPulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_copper_arrow_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked enderitePulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_enderite_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked enderitePulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_enderite_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked enderitePulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_enderite_arrow_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked rubyPulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_ruby_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked rubyPulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_ruby_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked rubyPulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_ruby_arrow_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked steelPulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_steel_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked steelPulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_steel_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked steelPulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_steel_arrow_pulling_2", ModelTemplates.BOW));
        ItemModel.Unbaked titaniumPulling0 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_titanium_arrow_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked titaniumPulling1 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_titanium_arrow_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked titaniumPulling2 = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(itemModels, bowItem, "_titanium_arrow_pulling_2", ModelTemplates.BOW));
        itemModels.itemModelOutput.accept(bowItem, ItemModelUtils.select((SelectItemModelProperty)new Arrow(), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)basePulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)basePulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)basePulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel), (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.BRONZE), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)bronzePulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)bronzePulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)bronzePulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel)), ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.COPPER), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)copperPulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)copperPulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)copperPulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel)), ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.ENDERITE), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)enderitePulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)enderitePulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)enderitePulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel)), ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.RUBY), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)rubyPulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)rubyPulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)rubyPulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel)), ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.STEEL), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)steelPulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)steelPulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)steelPulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel)), ItemModelUtils.when((Object)((Object)MGArrowItem.MGArrowType.TITANIUM), (ItemModel.Unbaked)ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)titaniumPulling0, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)titaniumPulling1, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)titaniumPulling2, (float)0.9f)}), (ItemModel.Unbaked)baseModel))}));
    }

    private ResourceLocation mcLoc(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    private String getBlockName(Block block) {
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)block);
        return location.getPath();
    }

    private String getItemName(Item item) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        return location.getPath();
    }

    private ResourceLocation blockLocation(String modelName) {
        return ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("block/" + modelName));
    }

    private ResourceLocation itemLocation(String modelName) {
        return ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("item/" + modelName));
    }

    public ResourceLocation createFlatItemModel(ItemModelGenerators itemModels, Item item, String suffix, ModelTemplate modelTemplate) {
        return modelTemplate.create(this.getModelLocation(item, suffix), TextureMapping.layer0((ResourceLocation)this.getModelLocation(item, suffix)), itemModels.modelOutput);
    }

    public ResourceLocation getModelLocation(Item item, String suffix) {
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)this.getItemName(item));
        return resourcelocation.withPath(p_386751_ -> "item/" + p_386751_ + suffix);
    }

    @NotNull
    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.listElements().filter(blockReference -> Optional.of(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockReference.value()))).filter(resourceLocation -> resourceLocation.getNamespace().equals("moregears")).isPresent());
    }

    @NotNull
    protected Stream<? extends Holder<Item>> getKnownItems() {
        return BuiltInRegistries.ITEM.listElements().filter(itemReference -> Optional.of(BuiltInRegistries.ITEM.getKey((Object)((Item)itemReference.value()))).filter(resourceLocation -> resourceLocation.getNamespace().equals("moregears")).isPresent());
    }
}

