/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.recipe;

import com.coolerpromc.moregears.recipe.MGRecipes;
import com.coolerpromc.moregears.recipe.custom.MultipleRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record AlloySmeltingRecipe(List<SizedIngredient> inputItems, List<ItemStack> output) implements Recipe<MultipleRecipeInput>
{
    public boolean matches(MultipleRecipeInput multipleRecipeInput, Level level) {
        List<ItemStack> inputItems = multipleRecipeInput.inputItems();
        ArrayList<SizedIngredient> remainingIngredients = new ArrayList<SizedIngredient>(this.inputItems);
        for (ItemStack itemStack : inputItems) {
            if (itemStack.isEmpty()) continue;
            boolean ingredientFound = false;
            Iterator iterator = remainingIngredients.iterator();
            while (iterator.hasNext()) {
                SizedIngredient ingredient = (SizedIngredient)iterator.next();
                if (!ingredient.ingredient().test(itemStack)) continue;
                iterator.remove();
                ingredientFound = true;
                break;
            }
            if (ingredientFound) continue;
            return false;
        }
        return remainingIngredients.isEmpty();
    }

    public ItemStack assemble(MultipleRecipeInput multipleRecipeInput, HolderLookup.Provider provider) {
        return this.output.isEmpty() ? ItemStack.EMPTY : this.output.get(0).copy();
    }

    public RecipeSerializer<? extends Recipe<MultipleRecipeInput>> getSerializer() {
        return (RecipeSerializer)MGRecipes.ALLOY_SMELTING_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<MultipleRecipeInput>> getType() {
        return (RecipeType)MGRecipes.ALLOY_SMELTING_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (SizedIngredient inputItem : this.inputItems) {
            ingredients.add(inputItem.ingredient());
        }
        return PlacementInfo.create(ingredients);
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<AlloySmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"alloy_smelting");
        private final MapCodec<AlloySmeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(alloySmeltingRecipeInstance -> alloySmeltingRecipeInstance.group((App)SizedIngredient.NESTED_CODEC.listOf().fieldOf("ingredients").forGetter(AlloySmeltingRecipe::inputItems), (App)ItemStack.CODEC.listOf().fieldOf("output").forGetter(AlloySmeltingRecipe::output)).apply((Applicative)alloySmeltingRecipeInstance, AlloySmeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlloySmeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AlloySmeltingRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlloySmeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static AlloySmeltingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int ingredientCount = buffer.readVarInt();
            ArrayList<SizedIngredient> inputItems = new ArrayList<SizedIngredient>(ingredientCount);
            for (int i = 0; i < ingredientCount; ++i) {
                inputItems.add((SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer));
            }
            int outputCount = buffer.readVarInt();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(outputCount);
            for (int i = 0; i < outputCount; ++i) {
                result.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            return new AlloySmeltingRecipe(inputItems, result);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, AlloySmeltingRecipe recipe) {
            buffer.writeVarInt(recipe.inputItems.size());
            for (SizedIngredient ingredient : recipe.inputItems) {
                SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeVarInt(recipe.output.size());
            for (ItemStack itemStack : recipe.output) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)itemStack);
            }
        }
    }
}

