/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.screen;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.block.entity.AlloySmelterBlockEntity;
import com.coolerpromc.moregears.screen.MGMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class AlloySmelterMenu
extends AbstractContainerMenu {
    public final AlloySmelterBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 4;

    public AlloySmelterMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(6));
    }

    public AlloySmelterMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super(MGMenuTypes.ALLOY_SMELTER.get(), pContainerId);
        AlloySmelterMenu.checkContainerSize((Container)inv, (int)6);
        this.blockEntity = (AlloySmelterBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemStacksResourceHandler fuelHandler = this.blockEntity.getFuelHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)fuelHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)fuelHandler).set(arg_0, arg_1, arg_2), 0, 31, 23));
        ItemStacksResourceHandler inputHandler = this.blockEntity.getInputHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)inputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)inputHandler).set(arg_0, arg_1, arg_2), 0, 83, 23));
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)inputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)inputHandler).set(arg_0, arg_1, arg_2), 1, 119, 23));
        ItemStacksResourceHandler outputHandler = this.blockEntity.getOutputHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)outputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)outputHandler).set(arg_0, arg_1, arg_2), 0, 101, 55));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 40, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 40) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(pPlayer, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return AlloySmelterMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)MGBlocks.ALLOY_SMELTER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getEnergy() {
        return this.data.get(2);
    }

    public int getMaxEnergy() {
        return this.data.get(3);
    }

    public int getEnergyStoredScaled() {
        return (int)((float)this.getEnergy() / (float)this.getMaxEnergy() * 58.0f);
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 25;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean isGeneratingEnergy() {
        return this.data.get(4) > 0;
    }

    public int getEnergyProgress() {
        int progress = this.data.get(4);
        int maxProgress = this.data.get(5);
        int progressArrowSize = 18;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

