/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.screen;

import com.coolerpromc.moregears.screen.AlloySmelterMenu;
import com.coolerpromc.moregears.util.MGEnergyStorage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AlloySmelterScreen
extends AbstractContainerScreen<AlloySmelterMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"textures/gui/alloy_smelter_gui.png");

    public AlloySmelterScreen(AlloySmelterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 74;
        this.titleLabelX = 56;
        this.titleLabelY = 5;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderEnergyBar(pGuiGraphics, x, y);
        this.renderProgressArrow(pGuiGraphics, x, y);
        this.renderEnergyGeneration(pGuiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energyScaled = ((AlloySmelterMenu)this.menu).getEnergyStoredScaled();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + 9, y + 13 + (58 - energyScaled), 176.0f, (float)(101 - energyScaled), 14, energyScaled, 256, 256);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloySmelterMenu)this.menu).isCrafting()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + 99, y + 30, 176.0f, 18.0f, 20, ((AlloySmelterMenu)this.menu).getScaledProgress(), 256, 256);
        }
    }

    private void renderEnergyGeneration(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloySmelterMenu)this.menu).isGeneratingEnergy()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + 33, y + 44 + ((AlloySmelterMenu)this.menu).getEnergyProgress(), 176.0f, (float)((AlloySmelterMenu)this.menu).getEnergyProgress(), 12, 18 - ((AlloySmelterMenu)this.menu).getEnergyProgress(), 256, 256);
        }
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        int energyStored = ((AlloySmelterMenu)this.menu).getEnergy();
        int maxEnergy = ((AlloySmelterMenu)this.menu).getMaxEnergy();
        MutableComponent text = Component.translatable((String)"gui.moregears.energy_stored", (Object[])new Object[]{MGEnergyStorage.convertEnergyToString(energyStored), MGEnergyStorage.convertEnergyToString(maxEnergy)});
        if (this.isHovering(9, 13, 14, 58, pMouseX, pMouseY)) {
            pGuiGraphics.setTooltipForNextFrame(this.font, (Component)text, pMouseX, pMouseY);
        }
    }
}

