/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.util;

import net.neoforged.neoforge.transfer.energy.SimpleEnergyHandler;

public class MGEnergyStorage
extends SimpleEnergyHandler {
    public MGEnergyStorage(int capacity) {
        super(capacity);
    }

    public MGEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public MGEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public MGEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public void setEnergy(int energy) {
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.capacity) {
            energy = this.capacity;
        }
        this.set(energy);
    }

    public void setMaxReceive(int maxReceive) {
        this.maxInsert = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void addEnergy(int energy) {
        this.setEnergy(this.energy + energy);
    }

    public void removeEnergy(int energy) {
        this.setEnergy(this.energy - energy);
    }

    public static String convertEnergyToString(int energy) {
        if (energy < 1000) {
            return energy + " FE";
        }
        if (energy < 1000000) {
            return String.format("%.2f", Float.valueOf((float)energy / 1000.0f)) + " kFE";
        }
        if (energy < 1000000000) {
            return String.format("%.2f", Float.valueOf((float)energy / 1000000.0f)) + " MFE";
        }
        return String.format("%.2f", Float.valueOf((float)energy / 1.0E9f)) + " GFE";
    }
}

