/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.block.entity;

import com.coolerpromc.moregears.block.entity.MGBlockEntities;
import com.coolerpromc.moregears.recipe.AlloySmeltingRecipe;
import com.coolerpromc.moregears.recipe.MGRecipes;
import com.coolerpromc.moregears.recipe.custom.MultipleRecipeInput;
import com.coolerpromc.moregears.screen.AlloySmelterMenu;
import com.coolerpromc.moregears.util.ImplementedInventory;
import com.coolerpromc.moregears.util.MGEnergyStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class AlloySmelterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private final MGEnergyStorage energyStorage = new MGEnergyStorage(100000, 1000, 0){

        protected void onFinalCommit() {
            super.onFinalCommit();
            AlloySmelterBlockEntity.this.method_5431();
            if (AlloySmelterBlockEntity.this.field_11863 != null) {
                AlloySmelterBlockEntity.this.field_11863.method_8413(AlloySmelterBlockEntity.this.field_11867, AlloySmelterBlockEntity.this.method_11010(), AlloySmelterBlockEntity.this.method_11010(), 3);
            }
        }

        @Override
        public boolean supportsExtraction() {
            return false;
        }

        @Override
        public boolean supportsInsertion() {
            return true;
        }
    };
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public static final int FUEL_SLOT = 0;
    public static final int[] INPUT_SLOT = new int[]{1, 2};
    public static final int[] OUTPUT_SLOT = new int[]{3};
    protected final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> AlloySmelterBlockEntity.this.progress;
                case 1 -> AlloySmelterBlockEntity.this.maxProgress;
                case 2 -> AlloySmelterBlockEntity.this.energyStorage.amount;
                case 3 -> AlloySmelterBlockEntity.this.energyStorage.capacity;
                case 4 -> AlloySmelterBlockEntity.this.burnProgress;
                case 5 -> AlloySmelterBlockEntity.this.maxBurnProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AlloySmelterBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AlloySmelterBlockEntity.this.maxProgress = value;
                    break;
                }
                case 5: {
                    AlloySmelterBlockEntity.this.maxBurnProgress = value;
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int burnProgress = 0;
    private int maxBurnProgress = 0;
    private boolean isBurning = false;

    public AlloySmelterBlockEntity(class_2338 pos, class_2680 state) {
        super(MGBlockEntities.ALLOY_SMELTER_BE, pos, state);
    }

    public MGEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.moregears.alloy_smelter");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new AlloySmelterMenu(syncId, playerInventory, this, this.data);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("energy", this.energyStorage.amount);
        nbt.method_10569("progress", this.progress);
        nbt.method_10569("burnProgress", this.burnProgress);
        nbt.method_10569("maxBurnProgress", this.maxBurnProgress);
        nbt.method_10556("isBurning", this.isBurning);
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.energyStorage.setEnergy(nbt.method_10550("energy"));
        this.progress = nbt.method_10550("progress");
        this.burnProgress = nbt.method_10550("burnProgress");
        this.maxBurnProgress = nbt.method_10550("maxBurnProgress");
        this.isBurning = nbt.method_10577("isBurning");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return slot == OUTPUT_SLOT[0] && side == class_2350.field_11033;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        if (slot == 0 && side == class_2350.field_11036) {
            assert (this.field_11863 != null);
            return this.field_11863.method_61269().method_61752(stack);
        }
        return slot == INPUT_SLOT[0] || slot == INPUT_SLOT[1] && side != class_2350.field_11036 && side != class_2350.field_11033;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        this.generateEnergy();
        this.method_5431();
        if (world != null) {
            world.method_8413(pos, this.method_11010(), this.method_11010(), 3);
        }
        if (this.hasRecipe() && this.energyStorage.amount >= 1) {
            this.increaseCraftingProgress();
            try (Transaction transaction = Transaction.openOuter();){
                this.energyStorage.extract(10L, (TransactionContext)transaction);
                transaction.commit();
            }
            AlloySmelterBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
                AlloySmelterBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            }
        } else {
            this.resetProgress();
            AlloySmelterBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private void generateEnergy() {
        if (this.getFuelTime((class_1799)this.inventory.get(0)) > 0 && !this.isBurning) {
            this.maxBurnProgress = Math.max(this.getFuelTime((class_1799)this.inventory.get(0)), 0);
        }
        if (this.getFuelTime((class_1799)this.inventory.get(0)) > 0 || this.isBurning && this.energyStorage.amount < this.energyStorage.capacity) {
            if (this.burnProgress >= this.maxBurnProgress) {
                this.burnProgress = 0;
                this.isBurning = false;
                return;
            }
            if (this.burnProgress == 0) {
                this.method_5434(0, 1);
                this.isBurning = true;
            }
            try (Transaction transaction = Transaction.openOuter();){
                this.energyStorage.insert(100L, (TransactionContext)transaction);
                transaction.commit();
            }
            ++this.burnProgress;
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<class_8786<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            List<class_1799> results = ((AlloySmeltingRecipe)recipe.get().comp_1933()).getOutput();
            int extractFromSlot0 = 0;
            int extractFromSlot1 = 0;
            for (class_1856 ingredient : ((AlloySmeltingRecipe)recipe.get().comp_1933()).getInputItems()) {
                if (ingredient.method_8093((class_1799)this.inventory.get(INPUT_SLOT[0]))) {
                    extractFromSlot0 += Math.min(((class_1799)this.inventory.get(INPUT_SLOT[0])).method_7947(), 1);
                    continue;
                }
                if (!ingredient.method_8093((class_1799)this.inventory.get(INPUT_SLOT[1]))) continue;
                extractFromSlot1 += Math.min(((class_1799)this.inventory.get(INPUT_SLOT[1])).method_7947(), 1);
            }
            if (extractFromSlot0 > 0) {
                this.method_5434(INPUT_SLOT[0], extractFromSlot0);
            }
            if (extractFromSlot1 > 0) {
                this.method_5434(INPUT_SLOT[1], extractFromSlot1);
            }
            for (class_1799 result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.inventory.set(outputSlot, (Object)new class_1799((class_1935)result.method_7909(), ((class_1799)this.inventory.get(outputSlot)).method_7947() + result.method_7947()));
                    continue;
                }
                System.err.println("No suitable output slot found for item: " + String.valueOf(result));
            }
        }
    }

    private int findSuitableOutputSlot(class_1799 result) {
        for (int i : OUTPUT_SLOT) {
            class_1799 stackInSlot = (class_1799)this.inventory.get(i);
            if (!stackInSlot.method_7960() && (stackInSlot.method_7909() != result.method_7909() || stackInSlot.method_7947() + result.method_7947() > stackInSlot.method_7914())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<class_8786<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        AlloySmeltingRecipe currentRecipe = (AlloySmeltingRecipe)recipe.get().comp_1933();
        List<class_1856> recipeIngredients = currentRecipe.getInputItems();
        List<class_1799> outputResults = currentRecipe.getOutput();
        ArrayList<class_1799> userInputs = new ArrayList<class_1799>();
        for (int inputSlot : INPUT_SLOT) {
            userInputs.add((class_1799)this.inventory.get(inputSlot));
        }
        Object object = recipeIngredients.iterator();
        while (object.hasNext()) {
            class_1856 recipeIngredient = (class_1856)object.next();
            boolean ingredientMatched = false;
            Iterator userInputIterator = userInputs.iterator();
            while (userInputIterator.hasNext()) {
                class_1799 userInput = (class_1799)userInputIterator.next();
                if (!recipeIngredient.method_8093(userInput) || userInput.method_7947() < 1) continue;
                userInputIterator.remove();
                ingredientMatched = true;
                break;
            }
            if (ingredientMatched) continue;
            return false;
        }
        for (class_1799 result : outputResults) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result.method_7909())) continue;
            return false;
        }
        return this.checkSlot(outputResults);
    }

    private boolean checkSlot(List<class_1799> results) {
        int count = 0;
        int emptyCount = 0;
        for (class_1799 result : results) {
            ++count;
        }
        for (Object i : (Object)OUTPUT_SLOT) {
            class_1799 stackInSlot = (class_1799)this.inventory.get((int)i);
            if (!stackInSlot.method_7960()) {
                for (class_1799 result : results) {
                    if (stackInSlot.method_7909() != result.method_7909() || stackInSlot.method_7947() + result.method_7947() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private Optional<class_8786<AlloySmeltingRecipe>> getCurrentRecipe() {
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        for (int i : INPUT_SLOT) {
            inputs.add((class_1799)this.inventory.get(i));
        }
        class_3218 serverWorld = (class_3218)this.field_11863;
        assert (serverWorld != null);
        return serverWorld.method_64577().method_8132(MGRecipes.ALLOY_SMELTING_TYPE, (class_9695)new MultipleRecipeInput(inputs), this.field_11863);
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        for (int i : OUTPUT_SLOT) {
            class_1799 stackInSlot = (class_1799)this.inventory.get(i);
            if (!stackInSlot.method_7960() && (stackInSlot.method_7909() != result.method_7909() || stackInSlot.method_7947() + result.method_7947() > stackInSlot.method_7914())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        for (int i : OUTPUT_SLOT) {
            class_1799 stackInSlot = (class_1799)this.inventory.get(i);
            if (!stackInSlot.method_7960() && stackInSlot.method_7909() != item) continue;
            return true;
        }
        return false;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    public int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        assert (this.field_11863 != null);
        return this.field_11863.method_61269().method_61755(new class_1799((class_1935)item));
    }
}

