/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.util;

import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class MGEnergyStorage
extends SnapshotParticipant<Integer>
implements EnergyStorage {
    public int amount = 0;
    public int capacity;
    public int maxInsert;
    public int maxExtract;

    public MGEnergyStorage(int capacity) {
        this(capacity, capacity);
    }

    public MGEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public MGEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        StoragePreconditions.notNegative((long)capacity);
        StoragePreconditions.notNegative((long)maxReceive);
        StoragePreconditions.notNegative((long)maxExtract);
        this.capacity = capacity;
        this.maxInsert = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void setEnergy(int energy) {
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.capacity) {
            energy = this.capacity;
        }
        this.amount = energy;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxInsert = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean supportsInsertion() {
        return (long)this.maxInsert > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min((long)this.maxInsert, Math.min(maxAmount, (long)(this.capacity - this.amount)));
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount = (int)((long)this.amount + inserted);
            return inserted;
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return (long)this.maxExtract > 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min((long)this.maxExtract, Math.min(maxAmount, (long)this.amount));
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount = (int)((long)this.amount - extracted);
            return extracted;
        }
        return 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return this.capacity;
    }

    protected Integer createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Integer integer) {
        this.amount = integer;
    }

    public static String convertEnergyToString(long energy) {
        if (energy < 1000L) {
            return energy + " FE";
        }
        if (energy < 1000000L) {
            return String.format("%.2f", Float.valueOf((float)energy / 1000.0f)) + " kFE";
        }
        if (energy < 1000000000L) {
            return String.format("%.2f", Float.valueOf((float)energy / 1000000.0f)) + " MFE";
        }
        return String.format("%.2f", Float.valueOf((float)energy / 1.0E9f)) + " GFE";
    }
}

