/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.block.entity;

import com.coolerpromc.moregears.block.entity.MGBlockEntities;
import com.coolerpromc.moregears.recipe.AlloySmeltingRecipe;
import com.coolerpromc.moregears.recipe.MGRecipes;
import com.coolerpromc.moregears.recipe.custom.MultipleRecipeInput;
import com.coolerpromc.moregears.screen.AlloySmelterMenu;
import com.coolerpromc.moregears.util.MGEnergyStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class AlloySmelterBlockEntity
extends BlockEntity
implements MenuProvider {
    private final MGEnergyStorage energyStorage = new MGEnergyStorage(100000, 10000, 0);
    private final ItemStackHandler fuelHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getBurnTime(RecipeType.BLASTING) > 0;
        }

        protected void onContentsChanged(int slot) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler inputHandler = new ItemStackHandler(2){

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler outputHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        protected void onContentsChanged(int slot) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> AlloySmelterBlockEntity.this.progress;
                case 1 -> AlloySmelterBlockEntity.this.maxProgress;
                case 2 -> AlloySmelterBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> AlloySmelterBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 4 -> AlloySmelterBlockEntity.this.burnProgress;
                case 5 -> AlloySmelterBlockEntity.this.maxBurnProgress;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    AlloySmelterBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    AlloySmelterBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 5: {
                    AlloySmelterBlockEntity.this.maxBurnProgress = pValue;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int burnProgress = 0;
    private int maxBurnProgress = 0;
    private boolean isBurning = false;

    public AlloySmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super(MGBlockEntities.ALLOY_SMELTER_BE.get(), pos, blockState);
    }

    public MGEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ItemStackHandler getFuelHandler() {
        return this.fuelHandler;
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ContainerData getData() {
        return this.data;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(4);
        inventory.setItem(0, this.inputHandler.getStackInSlot(0));
        inventory.setItem(1, this.inputHandler.getStackInSlot(1));
        inventory.setItem(2, this.outputHandler.getStackInSlot(0));
        inventory.setItem(3, this.fuelHandler.getStackInSlot(0));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.moregears.alloy_smelter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AlloySmelterMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("fuel", (Tag)this.fuelHandler.serializeNBT(registries));
        tag.put("input", (Tag)this.inputHandler.serializeNBT(registries));
        tag.put("output", (Tag)this.outputHandler.serializeNBT(registries));
        tag.putInt("energy", this.energyStorage.getEnergyStored());
        tag.putInt("progress", this.progress);
        tag.putInt("burnProgress", this.burnProgress);
        tag.putInt("maxBurnProgress", this.maxBurnProgress);
        tag.putBoolean("isBurning", this.isBurning);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fuelHandler.deserializeNBT(registries, tag.getCompound("fuel"));
        this.inputHandler.deserializeNBT(registries, tag.getCompound("input"));
        this.outputHandler.deserializeNBT(registries, tag.getCompound("output"));
        this.energyStorage.setEnergy(tag.getInt("energy"));
        this.progress = tag.getInt("progress");
        this.burnProgress = tag.getInt("burnProgress");
        this.maxBurnProgress = tag.getInt("maxBurnProgress");
        this.isBurning = tag.getBoolean("isBurning");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        this.generateEnergy();
        AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasRecipe() && this.energyStorage.getEnergyStored() >= 1) {
            this.increaseCraftingProgress();
            this.energyStorage.removeEnergy(10);
            AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
                AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else {
            this.resetProgress();
            AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private void generateEnergy() {
        if (this.fuelHandler.getStackInSlot(0).getBurnTime(RecipeType.BLASTING) > 0 && !this.isBurning) {
            this.maxBurnProgress = Math.max(this.fuelHandler.getStackInSlot(0).getBurnTime(RecipeType.BLASTING), 0);
        }
        if (this.fuelHandler.getStackInSlot(0).getBurnTime(RecipeType.BLASTING) > 0 || this.isBurning && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
            if (this.burnProgress >= this.maxBurnProgress) {
                this.burnProgress = 0;
                this.isBurning = false;
                return;
            }
            if (this.burnProgress == 0) {
                this.fuelHandler.extractItem(0, 1, false);
                this.isBurning = true;
            }
            this.energyStorage.receiveEnergy(100, false);
            ++this.burnProgress;
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<RecipeHolder<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            List<ItemStack> results = ((AlloySmeltingRecipe)recipe.get().value()).getOutput();
            int extractFromSlot0 = 0;
            int extractFromSlot1 = 0;
            for (SizedIngredient ingredient : ((AlloySmeltingRecipe)recipe.get().value()).getInputItems()) {
                if (ingredient.test(this.inputHandler.getStackInSlot(0))) {
                    extractFromSlot0 += Math.min(this.inputHandler.getStackInSlot(0).getCount(), ingredient.count());
                    continue;
                }
                if (!ingredient.test(this.inputHandler.getStackInSlot(1))) continue;
                extractFromSlot1 += Math.min(this.inputHandler.getStackInSlot(1).getCount(), ingredient.count());
            }
            if (extractFromSlot0 > 0) {
                this.inputHandler.extractItem(0, extractFromSlot0, false);
            }
            if (extractFromSlot1 > 0) {
                this.inputHandler.extractItem(1, extractFromSlot1, false);
            }
            for (ItemStack result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.setStackInSlot(outputSlot, new ItemStack((ItemLike)result.getItem(), this.outputHandler.getStackInSlot(outputSlot).getCount() + result.getCount()));
                    continue;
                }
                System.err.println("No suitable output slot found for item: " + String.valueOf(result));
            }
        }
    }

    private int findSuitableOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        AlloySmeltingRecipe currentRecipe = (AlloySmeltingRecipe)recipe.get().value();
        List<SizedIngredient> recipeIngredients = currentRecipe.getInputItems();
        List<ItemStack> outputResults = currentRecipe.getOutput();
        ArrayList<ItemStack> userInputs = new ArrayList<ItemStack>();
        userInputs.add(this.inputHandler.getStackInSlot(0));
        userInputs.add(this.inputHandler.getStackInSlot(1));
        for (SizedIngredient recipeIngredient : recipeIngredients) {
            boolean ingredientMatched = false;
            Iterator userInputIterator = userInputs.iterator();
            while (userInputIterator.hasNext()) {
                ItemStack userInput = (ItemStack)userInputIterator.next();
                if (!recipeIngredient.ingredient().test(userInput) || userInput.getCount() < recipeIngredient.count()) continue;
                userInputIterator.remove();
                ingredientMatched = true;
                break;
            }
            if (ingredientMatched) continue;
            return false;
        }
        for (ItemStack result : outputResults) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result.getItem())) continue;
            return false;
        }
        return this.checkSlot(outputResults);
    }

    private boolean checkSlot(List<ItemStack> results) {
        int count = 0;
        int emptyCount = 0;
        for (ItemStack result : results) {
            ++count;
        }
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty()) {
                for (ItemStack result : results) {
                    if (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private Optional<RecipeHolder<AlloySmeltingRecipe>> getCurrentRecipe() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inputHandler.getSlots(); ++i) {
            inputs.add(this.inputHandler.getStackInSlot(i));
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)MGRecipes.ALLOY_SMELTING_TYPE.get(), (RecipeInput)new MultipleRecipeInput(inputs), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && stackInSlot.getItem() != item) continue;
            return true;
        }
        return false;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

