/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.compat.jei.category;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.recipe.AlloySmeltingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AlloySmeltingCategory
implements IRecipeCategory<AlloySmeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"alloy_smelting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"textures/gui/compat/alloy_smelter_gui.png");
    public static final RecipeType<AlloySmeltingRecipe> ALLOY_SMELTING_TYPE = new RecipeType(UID, AlloySmeltingRecipe.class);
    private int tickCount = 0;
    private final IDrawable background;
    private final IDrawable icon;

    public AlloySmeltingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 84);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MGBlocks.ALLOY_SMELTER.get()));
    }

    public RecipeType<AlloySmeltingRecipe> getRecipeType() {
        return ALLOY_SMELTING_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.moregears.alloy_smelter");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft.getInstance().getTextureManager().bindForSetup(TEXTURE);
        ++this.tickCount;
        int arrowHeight = this.tickCount % 600 * 25 / 600;
        guiGraphics.blit(TEXTURE, 99, 30, 176, 18, 20, arrowHeight);
        int energyScaled = (int)Math.ceil(0.58);
        guiGraphics.blit(TEXTURE, 9, 13 + (58 - energyScaled), 176, 101 - energyScaled, 14, energyScaled);
        int energyGeneration = this.tickCount % 2000 * 18 / 2000;
        guiGraphics.blit(TEXTURE, 33, 44 + energyGeneration, 176, energyGeneration, 12, 18 - energyGeneration);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloySmeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 31, 23).addItemStack(new ItemStack((ItemLike)Items.COAL));
        builder.addSlot(RecipeIngredientRole.INPUT, 83, 23).addItemStack(new ItemStack((ItemLike)recipe.getInputItems().get(0).getItems()[0].getItem(), recipe.getInputItems().get(0).count()));
        builder.addSlot(RecipeIngredientRole.INPUT, 119, 23).addItemStack(new ItemStack((ItemLike)recipe.getInputItems().get(1).getItems()[0].getItem(), recipe.getInputItems().get(1).count()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 55).addItemStack(recipe.getOutput().getFirst());
    }
}

