/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.coolerpromc.moregears.datagen.MGBlockStateProvider;
import com.coolerpromc.moregears.datagen.MGBlockTagGenerator;
import com.coolerpromc.moregears.datagen.MGItemModelProvider;
import com.coolerpromc.moregears.datagen.MGItemTagGenerator;
import com.coolerpromc.moregears.datagen.MGLootTableProvider;
import com.coolerpromc.moregears.datagen.MGRecipeProvider;
import com.coolerpromc.moregears.datagen.MGWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="moregears", bus=EventBusSubscriber.Bus.MOD)
public class MGDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new MGRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MGLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MGBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MGItemModelProvider(packOutput, existingFileHelper));
        MGBlockTagGenerator blockTagGenerator = (MGBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new MGBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MGItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MGWorldGenProvider(packOutput, lookupProvider));
    }
}

