/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.coolerpromc.moregears.item.MGItems;
import java.util.LinkedHashMap;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class MGItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public MGItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "moregears", existingFileHelper);
    }

    protected void registerModels() {
        ResourceLocation RAW_ORE = this.textureLoc("template_raw_ore");
        ResourceLocation INGOT = this.textureLoc("template_ingot");
        ResourceLocation GEM = this.textureLoc("template_gem");
        this.withExistingTexture(MGItems.RAW_TIN, RAW_ORE);
        this.withExistingTexture(MGItems.RAW_RUBY, RAW_ORE);
        this.withExistingTexture(MGItems.RAW_TITANIUM, RAW_ORE);
        this.withExistingTexture(MGItems.RAW_ENDERITE, RAW_ORE);
        this.withExistingTexture(MGItems.TIN_INGOT, INGOT);
        this.withExistingTexture(MGItems.BRONZE_INGOT, INGOT);
        this.withExistingTexture(MGItems.STEEL_INGOT, INGOT);
        this.withExistingTexture(MGItems.RUBY_INGOT, GEM);
        this.withExistingTexture(MGItems.TITANIUM_INGOT, INGOT);
        this.withExistingTexture(MGItems.ENDERITE_INGOT, INGOT);
        this.trimmedArmorItem(MGItems.COPPER_HELMET);
        this.trimmedArmorItem(MGItems.COPPER_CHESTPLATE);
        this.trimmedArmorItem(MGItems.COPPER_LEGGINGS);
        this.trimmedArmorItem(MGItems.COPPER_BOOTS);
        this.trimmedArmorItem(MGItems.BRONZE_HELMET);
        this.trimmedArmorItem(MGItems.BRONZE_CHESTPLATE);
        this.trimmedArmorItem(MGItems.BRONZE_LEGGINGS);
        this.trimmedArmorItem(MGItems.BRONZE_BOOTS);
        this.trimmedArmorItem(MGItems.STEEL_HELMET);
        this.trimmedArmorItem(MGItems.STEEL_CHESTPLATE);
        this.trimmedArmorItem(MGItems.STEEL_LEGGINGS);
        this.trimmedArmorItem(MGItems.STEEL_BOOTS);
        this.trimmedArmorItem(MGItems.RUBY_HELMET);
        this.trimmedArmorItem(MGItems.RUBY_CHESTPLATE);
        this.trimmedArmorItem(MGItems.RUBY_LEGGINGS);
        this.trimmedArmorItem(MGItems.RUBY_BOOTS);
        this.trimmedArmorItem(MGItems.TITANIUM_HELMET);
        this.trimmedArmorItem(MGItems.TITANIUM_CHESTPLATE);
        this.trimmedArmorItem(MGItems.TITANIUM_LEGGINGS);
        this.trimmedArmorItem(MGItems.TITANIUM_BOOTS);
        this.trimmedArmorItem(MGItems.ENDERITE_HELMET);
        this.trimmedArmorItem(MGItems.ENDERITE_CHESTPLATE);
        this.trimmedArmorItem(MGItems.ENDERITE_LEGGINGS);
        this.trimmedArmorItem(MGItems.ENDERITE_BOOTS);
        this.basicItem((Item)MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE.get());
        this.basicItem((Item)MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE.get());
        this.handheldItem((Item)MGItems.COPPER_SWORD.get());
        this.handheldItem((Item)MGItems.COPPER_SHOVEL.get());
        this.handheldItem((Item)MGItems.COPPER_PICKAXE.get());
        this.handheldItem((Item)MGItems.COPPER_AXE.get());
        this.handheldItem((Item)MGItems.COPPER_HOE.get());
        this.handheldItem((Item)MGItems.BRONZE_SWORD.get());
        this.handheldItem((Item)MGItems.BRONZE_SHOVEL.get());
        this.handheldItem((Item)MGItems.BRONZE_PICKAXE.get());
        this.handheldItem((Item)MGItems.BRONZE_AXE.get());
        this.handheldItem((Item)MGItems.BRONZE_HOE.get());
        this.handheldItem((Item)MGItems.STEEL_SWORD.get());
        this.handheldItem((Item)MGItems.STEEL_SHOVEL.get());
        this.handheldItem((Item)MGItems.STEEL_PICKAXE.get());
        this.handheldItem((Item)MGItems.STEEL_AXE.get());
        this.handheldItem((Item)MGItems.STEEL_HOE.get());
        this.handheldItem((Item)MGItems.RUBY_SWORD.get());
        this.handheldItem((Item)MGItems.RUBY_SHOVEL.get());
        this.handheldItem((Item)MGItems.RUBY_PICKAXE.get());
        this.handheldItem((Item)MGItems.RUBY_AXE.get());
        this.handheldItem((Item)MGItems.RUBY_HOE.get());
        this.handheldItem((Item)MGItems.TITANIUM_SWORD.get());
        this.handheldItem((Item)MGItems.TITANIUM_SHOVEL.get());
        this.handheldItem((Item)MGItems.TITANIUM_PICKAXE.get());
        this.handheldItem((Item)MGItems.TITANIUM_AXE.get());
        this.handheldItem((Item)MGItems.TITANIUM_HOE.get());
        this.handheldItem((Item)MGItems.ENDERITE_SWORD.get());
        this.handheldItem((Item)MGItems.ENDERITE_SHOVEL.get());
        this.handheldItem((Item)MGItems.ENDERITE_PICKAXE.get());
        this.handheldItem((Item)MGItems.ENDERITE_AXE.get());
        this.handheldItem((Item)MGItems.ENDERITE_HOE.get());
    }

    private <T extends Item> void withExistingTexture(DeferredItem<T> item, ResourceLocation texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + item.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", texture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#layer0").tintindex(0).end().face(Direction.UP).texture("#layer0").tintindex(0).end().face(Direction.NORTH).texture("#layer0").tintindex(0).end().face(Direction.SOUTH).texture("#layer0").tintindex(0).end().face(Direction.WEST).texture("#layer0").tintindex(0).end().face(Direction.EAST).texture("#layer0").tintindex(0).end().end();
    }

    private ResourceLocation textureLoc(String location) {
        return this.modLoc("item/" + location);
    }

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "moregears";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

