/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.datagen.builder.AlloySmeltingRecipeBuilder;
import com.coolerpromc.moregears.item.MGItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MGRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public MGRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        MGRecipeProvider.alloySmeltingRecipe(recipeOutput, SizedIngredient.of((ItemLike)Items.COPPER_INGOT, (int)1), SizedIngredient.of((ItemLike)((ItemLike)MGItems.TIN_INGOT.get()), (int)1), MGItems.BRONZE_INGOT, 2);
        MGRecipeProvider.alloySmeltingRecipe(recipeOutput, SizedIngredient.of((ItemLike)Items.IRON_INGOT, (int)1), SizedIngredient.of((ItemLike)Items.COAL, (int)1), MGItems.STEEL_INGOT, 2);
        MGRecipeProvider.oreCooking(recipeOutput, List.of(MGBlocks.TIN_ORE, MGBlocks.DEEPSLATE_TIN_ORE, MGItems.RAW_TIN), RecipeCategory.TOOLS, MGItems.TIN_INGOT, 0.7f, 200, "tin_ingot");
        MGRecipeProvider.oreCooking(recipeOutput, List.of(MGBlocks.RUBY_ORE, MGBlocks.DEEPSLATE_RUBY_ORE, MGItems.RAW_RUBY), RecipeCategory.TOOLS, MGItems.RUBY_INGOT, 0.7f, 200, "ruby");
        MGRecipeProvider.oreCooking(recipeOutput, List.of(MGBlocks.NETHER_TITANIUM_ORE, MGItems.RAW_TITANIUM), RecipeCategory.TOOLS, MGItems.TITANIUM_INGOT, 1.0f, 200, "titanium_ingot");
        MGRecipeProvider.oreCooking(recipeOutput, List.of(MGBlocks.END_ENDERITE_ORE, MGItems.RAW_ENDERITE), RecipeCategory.TOOLS, MGItems.ENDERITE_INGOT, 1.0f, 200, "enderite_ingot");
        MGRecipeProvider.armorSetRecipe(recipeOutput, (ItemLike)Items.COPPER_INGOT, MGItems.COPPER_HELMET, MGItems.COPPER_CHESTPLATE, MGItems.COPPER_LEGGINGS, MGItems.COPPER_BOOTS);
        MGRecipeProvider.toolSetRecipe(recipeOutput, (ItemLike)Items.COPPER_INGOT, MGItems.COPPER_SWORD, MGItems.COPPER_PICKAXE, MGItems.COPPER_AXE, MGItems.COPPER_SHOVEL, MGItems.COPPER_HOE);
        MGRecipeProvider.armorSetRecipe(recipeOutput, MGItems.BRONZE_INGOT, MGItems.BRONZE_HELMET, MGItems.BRONZE_CHESTPLATE, MGItems.BRONZE_LEGGINGS, MGItems.BRONZE_BOOTS);
        MGRecipeProvider.toolSetRecipe(recipeOutput, MGItems.BRONZE_INGOT, MGItems.BRONZE_SWORD, MGItems.BRONZE_PICKAXE, MGItems.BRONZE_AXE, MGItems.BRONZE_SHOVEL, MGItems.BRONZE_HOE);
        MGRecipeProvider.armorSetRecipe(recipeOutput, MGItems.STEEL_INGOT, MGItems.STEEL_HELMET, MGItems.STEEL_CHESTPLATE, MGItems.STEEL_LEGGINGS, MGItems.STEEL_BOOTS);
        MGRecipeProvider.toolSetRecipe(recipeOutput, MGItems.STEEL_INGOT, MGItems.STEEL_SWORD, MGItems.STEEL_PICKAXE, MGItems.STEEL_AXE, MGItems.STEEL_SHOVEL, MGItems.STEEL_HOE);
        MGRecipeProvider.armorSetRecipe(recipeOutput, MGItems.RUBY_INGOT, MGItems.RUBY_HELMET, MGItems.RUBY_CHESTPLATE, MGItems.RUBY_LEGGINGS, MGItems.RUBY_BOOTS);
        MGRecipeProvider.toolSetRecipe(recipeOutput, MGItems.RUBY_INGOT, MGItems.RUBY_SWORD, MGItems.RUBY_PICKAXE, MGItems.RUBY_AXE, MGItems.RUBY_SHOVEL, MGItems.RUBY_HOE);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_HELMET, RecipeCategory.COMBAT, MGItems.TITANIUM_HELMET);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_CHESTPLATE, RecipeCategory.COMBAT, MGItems.TITANIUM_CHESTPLATE);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_LEGGINGS, RecipeCategory.COMBAT, MGItems.TITANIUM_LEGGINGS);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_BOOTS, RecipeCategory.COMBAT, MGItems.TITANIUM_BOOTS);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_SWORD, RecipeCategory.TOOLS, MGItems.TITANIUM_SWORD);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_PICKAXE, RecipeCategory.TOOLS, MGItems.TITANIUM_PICKAXE);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_AXE, RecipeCategory.TOOLS, MGItems.TITANIUM_AXE);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_SHOVEL, RecipeCategory.TOOLS, MGItems.TITANIUM_SHOVEL);
        MGRecipeProvider.titaniumSmithing(recipeOutput, (ItemLike)Items.NETHERITE_HOE, RecipeCategory.TOOLS, MGItems.TITANIUM_HOE);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_HELMET, RecipeCategory.COMBAT, MGItems.ENDERITE_HELMET);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_CHESTPLATE, RecipeCategory.COMBAT, MGItems.ENDERITE_CHESTPLATE);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_LEGGINGS, RecipeCategory.COMBAT, MGItems.ENDERITE_LEGGINGS);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_BOOTS, RecipeCategory.COMBAT, MGItems.ENDERITE_BOOTS);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_SWORD, RecipeCategory.TOOLS, MGItems.ENDERITE_SWORD);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_PICKAXE, RecipeCategory.TOOLS, MGItems.ENDERITE_PICKAXE);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_AXE, RecipeCategory.TOOLS, MGItems.ENDERITE_AXE);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_SHOVEL, RecipeCategory.TOOLS, MGItems.ENDERITE_SHOVEL);
        MGRecipeProvider.enderiteSmithing(recipeOutput, MGItems.TITANIUM_HOE, RecipeCategory.TOOLS, MGItems.ENDERITE_HOE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('X'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('S'), (ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), MGItems.TITANIUM_INGOT).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.TITANIUM_INGOT), MGRecipeProvider.has(MGItems.TITANIUM_INGOT)).save(recipeOutput, MGRecipeProvider.getItemName(MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE) + "_from_netherite_smithing_template");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE, (int)2).define(Character.valueOf('X'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('S'), MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), (ItemLike)Items.BLACKSTONE).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.TITANIUM_INGOT), MGRecipeProvider.has(MGItems.TITANIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('X'), MGItems.TITANIUM_INGOT).define(Character.valueOf('S'), MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), MGItems.ENDERITE_INGOT).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.ENDERITE_INGOT), MGRecipeProvider.has(MGItems.ENDERITE_INGOT)).save(recipeOutput, MGRecipeProvider.getItemName(MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE) + "_from_titanium_smithing_template");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE, (int)2).define(Character.valueOf('X'), MGItems.TITANIUM_INGOT).define(Character.valueOf('S'), MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), (ItemLike)Items.END_STONE).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.ENDERITE_INGOT), MGRecipeProvider.has(MGItems.ENDERITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MGBlocks.ALLOY_SMELTER).define(Character.valueOf('X'), (ItemLike)Items.FURNACE).define(Character.valueOf('A'), (ItemLike)Items.DEEPSLATE).define(Character.valueOf('N'), (ItemLike)Items.GUNPOWDER).pattern("XAX").pattern("ANA").pattern("AAA").unlockedBy(MGRecipeProvider.getHasName((ItemLike)Items.FURNACE), MGRecipeProvider.has((ItemLike)Items.FURNACE)).save(recipeOutput);
    }

    protected static void armorSetRecipe(RecipeOutput recipeOutput, ItemLike material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('X'), material).pattern("X X").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('X'), material).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    protected static void toolSetRecipe(RecipeOutput recipeOutput, ItemLike material, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike shovel, ItemLike hoe) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XX").pattern(" s").pattern(" s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("X").pattern("s").pattern("s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XX").pattern("Xs").pattern(" s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XXX").pattern(" s ").pattern(" s ").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)sword).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("X").pattern("X").pattern("s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), MGRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    protected static void titaniumSmithing(RecipeOutput recipeOutput, ItemLike ingredientItem, RecipeCategory category, ItemLike resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MGItems.TITANIUM_INGOT}), (RecipeCategory)category, (Item)resultItem.asItem()).unlocks("has_titanium_ingot", MGRecipeProvider.has(MGItems.TITANIUM_INGOT)).save(recipeOutput, MGRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    protected static void enderiteSmithing(RecipeOutput recipeOutput, ItemLike ingredientItem, RecipeCategory category, ItemLike resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MGItems.ENDERITE_INGOT}), (RecipeCategory)category, (Item)resultItem.asItem()).unlocks("has_enderite_ingot", MGRecipeProvider.has(MGItems.ENDERITE_INGOT)).save(recipeOutput, MGRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    protected static void oreCooking(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        MGRecipeProvider.oreCooking((RecipeOutput)recipeOutput, (RecipeSerializer)RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, (String)group, (String)"_from_smelting");
        MGRecipeProvider.oreCooking((RecipeOutput)recipeOutput, (RecipeSerializer)RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, (String)group, (String)"_from_blasting");
    }

    protected static void alloySmeltingRecipe(RecipeOutput recipeOutput, SizedIngredient ingredients1, SizedIngredient ingredients2, ItemLike result, int outputCount) {
        AlloySmeltingRecipeBuilder.alloySmeltingRecipe().addIngredient(ingredients1).addIngredient(ingredients2).addOutput(new ItemStack(result, outputCount)).unlockedBy(MGRecipeProvider.getHasName((ItemLike)ingredients1.ingredient().getItems()[0].getItem()), MGRecipeProvider.has((ItemLike)ingredients1.ingredient().getItems()[0].getItem())).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("alloy_smelting/" + MGRecipeProvider.getItemName((ItemLike)result) + "_from_alloy_smelting")));
    }
}

