/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.event;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.block.custom.MGOreBlock;
import com.coolerpromc.moregears.item.MGItems;
import com.coolerpromc.moregears.item.custom.MGIngot;
import com.coolerpromc.moregears.item.custom.MGRawOre;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="moregears", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterColorEvent {
    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        RegisterColorEvent.registerBlockColor(event, RegisterColorEvent.getBlocks());
    }

    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        RegisterColorEvent.registerBlockItemColor(event, RegisterColorEvent.getBlocks());
        RegisterColorEvent.registerRawOreColor(event, RegisterColorEvent.getRawOres());
        RegisterColorEvent.registerIngotColor(event, RegisterColorEvent.getIngots());
    }

    private static void registerBlockColor(RegisterColorHandlersEvent.Block event, Block ... blocks) {
        event.register((blockState, blockAndTintGetter, blockPos, i) -> {
            Block patt0$temp = blockState.getBlock();
            if (patt0$temp instanceof MGOreBlock) {
                MGOreBlock mgOreBlock = (MGOreBlock)patt0$temp;
                if (i == 1) {
                    return mgOreBlock.getColor();
                }
            }
            return -1;
        }, blocks);
    }

    private static void registerBlockItemColor(RegisterColorHandlersEvent.Item event, Block ... blocks) {
        event.register((itemStack, i) -> {
            BlockItem blockItem;
            Block patt1$temp;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof MGOreBlock) {
                MGOreBlock mgOreBlock = (MGOreBlock)patt1$temp;
                if (i == 1) {
                    return mgOreBlock.getColor();
                }
            }
            return -1;
        }, (ItemLike[])blocks);
    }

    private static void registerRawOreColor(RegisterColorHandlersEvent.Item event, Item ... items) {
        event.register((itemStack, i) -> {
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof MGRawOre) {
                MGRawOre mgRawOre = (MGRawOre)patt0$temp;
                if (i == 0) {
                    return mgRawOre.getColor();
                }
            }
            return -1;
        }, (ItemLike[])items);
    }

    private static void registerIngotColor(RegisterColorHandlersEvent.Item event, Item ... items) {
        event.register((itemStack, i) -> {
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof MGIngot) {
                MGIngot mgIngot = (MGIngot)patt0$temp;
                if (i == 0) {
                    return mgIngot.getColor();
                }
            }
            return -1;
        }, (ItemLike[])items);
    }

    private static Block[] getBlocks() {
        ArrayList<MGOreBlock> blocks = new ArrayList<MGOreBlock>();
        for (Field field : MGBlocks.class.getFields()) {
            try {
                Supplier supplier;
                Object t;
                if (!Supplier.class.isAssignableFrom(field.getType()) || !((t = (supplier = (Supplier)field.get(null)).get()) instanceof MGOreBlock)) continue;
                MGOreBlock block = (MGOreBlock)((Object)t);
                blocks.add(block);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return blocks.toArray(new Block[0]);
    }

    private static Item[] getRawOres() {
        ArrayList<MGRawOre> items = new ArrayList<MGRawOre>();
        for (Field field : MGItems.class.getFields()) {
            try {
                Supplier supplier;
                Object t;
                if (!Supplier.class.isAssignableFrom(field.getType()) || !((t = (supplier = (Supplier)field.get(null)).get()) instanceof MGRawOre)) continue;
                MGRawOre item = (MGRawOre)((Object)t);
                items.add(item);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return items.toArray(new Item[0]);
    }

    private static Item[] getIngots() {
        ArrayList<MGIngot> items = new ArrayList<MGIngot>();
        for (Field field : MGItems.class.getFields()) {
            try {
                Supplier supplier;
                Object t;
                if (!Supplier.class.isAssignableFrom(field.getType()) || !((t = (supplier = (Supplier)field.get(null)).get()) instanceof MGIngot)) continue;
                MGIngot item = (MGIngot)((Object)t);
                items.add(item);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return items.toArray(new Item[0]);
    }
}

