/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.screen;

import com.coolerpromc.moregears.screen.AlloySmelterMenu;
import com.coolerpromc.moregears.util.MGEnergyStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AlloySmelterScreen
extends AbstractContainerScreen<AlloySmelterMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"textures/gui/alloy_smelter_gui.png");

    public AlloySmelterScreen(AlloySmelterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 74;
        this.titleLabelX = 56;
        this.titleLabelY = 5;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderEnergyBar(pGuiGraphics, x, y);
        this.renderProgressArrow(pGuiGraphics, x, y);
        this.renderEnergyGeneration(pGuiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energyScaled = ((AlloySmelterMenu)this.menu).getEnergyStoredScaled();
        guiGraphics.blit(TEXTURE, x + 9, y + 13 + (58 - energyScaled), 176, 101 - energyScaled, 14, energyScaled);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloySmelterMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 99, y + 30, 176, 18, 20, ((AlloySmelterMenu)this.menu).getScaledProgress());
        }
    }

    private void renderEnergyGeneration(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloySmelterMenu)this.menu).isGeneratingEnergy()) {
            guiGraphics.blit(TEXTURE, x + 33, y + 44 + ((AlloySmelterMenu)this.menu).getEnergyProgress(), 176, ((AlloySmelterMenu)this.menu).getEnergyProgress(), 12, 18 - ((AlloySmelterMenu)this.menu).getEnergyProgress());
        }
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        int energyStored = ((AlloySmelterMenu)this.menu).getEnergy();
        int maxEnergy = ((AlloySmelterMenu)this.menu).getMaxEnergy();
        MutableComponent text = Component.translatable((String)"gui.moregears.energy_stored", (Object[])new Object[]{MGEnergyStorage.convertEnergyToString(energyStored), MGEnergyStorage.convertEnergyToString(maxEnergy)});
        if (this.isHovering(9, 13, 14, 58, pMouseX, pMouseY)) {
            pGuiGraphics.renderTooltip(this.font, (Component)text, pMouseX, pMouseY);
        }
    }
}

