/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.tool.steel;

import com.coolerpromc.moregears.util.MGTooltip;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SteelHoe
extends HoeItem {
    private static final ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)"steel_hoe_slow_speed");

    public SteelHoe(Tier p_42961_, Item.Properties p_42964_) {
        super(p_42961_, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean shouldSlow = player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == this || player.getItemInHand(InteractionHand.OFF_HAND).getItem() == this;
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (movementSpeed == null) {
            return;
        }
        AttributeModifier existingModifier = movementSpeed.getModifier(modifierId);
        if (shouldSlow) {
            if (existingModifier == null) {
                AttributeModifier speedModifier = new AttributeModifier(modifierId, (double)-0.02f, AttributeModifier.Operation.ADD_VALUE);
                movementSpeed.addTransientModifier(speedModifier);
            }
        } else if (existingModifier != null) {
            movementSpeed.removeModifier(existingModifier);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add(MGTooltip.itemSpecialEffect("special_effect.moregears.heavy"));
        tooltipComponents.add(MGTooltip.itemSpecialEffect("special_effect.moregears.faster_attack_speed"));
    }
}

