/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.worldgen;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.block.custom.MGOreBlock;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class MGConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_KEY = MGConfiguredFeatures.registerKey("tin_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RUBY_ORE_KEY = MGConfiguredFeatures.registerKey("ruby_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_TITANIUM_ORE_KEY = MGConfiguredFeatures.registerKey("nether_titanium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_ENDERITE_ORE_KEY = MGConfiguredFeatures.registerKey("end_enderite_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceable = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest netherrackReplaceable = new TagMatchTest(BlockTags.BASE_STONE_NETHER);
        BlockMatchTest endstoneReplaceable = new BlockMatchTest(Blocks.END_STONE);
        List<OreConfiguration.TargetBlockState> overworldTinOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((MGOreBlock)((Object)MGBlocks.TIN_ORE.get())).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceable, (BlockState)((MGOreBlock)((Object)MGBlocks.DEEPSLATE_TIN_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldRubyOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((MGOreBlock)((Object)MGBlocks.RUBY_ORE.get())).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceable, (BlockState)((MGOreBlock)((Object)MGBlocks.DEEPSLATE_RUBY_ORE.get())).defaultBlockState()));
        MGConfiguredFeatures.register(context, TIN_ORE_KEY, Feature.ORE, new OreConfiguration(overworldTinOres, 8));
        MGConfiguredFeatures.register(context, RUBY_ORE_KEY, Feature.ORE, new OreConfiguration(overworldRubyOres, 4));
        MGConfiguredFeatures.register(context, NETHER_TITANIUM_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceable, ((MGOreBlock)((Object)MGBlocks.NETHER_TITANIUM_ORE.get())).defaultBlockState(), 4));
        MGConfiguredFeatures.register(context, END_ENDERITE_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)endstoneReplaceable, ((MGOreBlock)((Object)MGBlocks.END_ENDERITE_ORE.get())).defaultBlockState(), 3));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

