/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class MGEquipmentInfoProvider
implements DataProvider {
    private final PackOutput.PathProvider path;

    public MGEquipmentInfoProvider(PackOutput output) {
        this.path = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
    }

    private void add(BiConsumer<ResourceLocation, EquipmentClientInfo> registrar) {
        this.register(registrar, "copper");
        this.register(registrar, "bronze");
        this.register(registrar, "steel");
        this.register(registrar, "ruby");
        this.register(registrar, "titanium");
        this.register(registrar, "enderite");
    }

    private void register(BiConsumer<ResourceLocation, EquipmentClientInfo> registrar, String path) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)path);
        registrar.accept(resourceLocation, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.HUMANOID, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(resourceLocation)}).addLayers(EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(resourceLocation)}).build());
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        HashMap map = new HashMap();
        this.add((name, info) -> {
            if (map.putIfAbsent(name, info) != null) {
                throw new IllegalStateException("Tried to register equipment client info twice for id: " + String.valueOf(name));
            }
        });
        return DataProvider.saveAll((CachedOutput)cachedOutput, (Codec)EquipmentClientInfo.CODEC, (PackOutput.PathProvider)this.path, map);
    }

    public String getName() {
        return "Equipment Client Infos: moregears";
    }
}

