/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.item.custom;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MGArrowEntity
extends AbstractArrow {
    private final ItemStack stack;

    public MGArrowEntity(EntityType<? extends AbstractArrow> p_331098_, Level p_331626_, ItemStack pickupItemStack) {
        super(p_331098_, p_331626_);
        this.stack = pickupItemStack;
    }

    public MGArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, double baseDamage) {
        super(entityType, owner, level, pickupItemStack.copyWithCount(1), firedFromWeapon);
        this.stack = pickupItemStack;
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        if (firedFromWeapon != null && firedFromWeapon.getItem() instanceof BowItem) {
            int infinityLevel;
            int powerLevel = firedFromWeapon.getEnchantmentLevel((Holder)level.registryAccess().getOrThrow(Enchantments.POWER));
            if (powerLevel > 0) {
                baseDamage += baseDamage * 0.25 * (double)(powerLevel + 1);
            }
            this.pickup = (infinityLevel = firedFromWeapon.getEnchantmentLevel((Holder)level.registryAccess().getOrThrow(Enchantments.INFINITY))) > 0 ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
        }
        this.setBaseDamage(baseDamage);
    }

    public MGArrowEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(entityType, x, y, z, level, pickupItemStack, firedFromWeapon);
        this.stack = pickupItemStack;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return this.stack;
    }
}

