/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.block.entity;

import com.coolerpromc.moregears.block.entity.MGBlockEntities;
import com.coolerpromc.moregears.recipe.AlloySmeltingRecipe;
import com.coolerpromc.moregears.recipe.MGRecipes;
import com.coolerpromc.moregears.recipe.custom.MultipleRecipeInput;
import com.coolerpromc.moregears.screen.AlloySmelterMenu;
import com.coolerpromc.moregears.util.MGEnergyStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class AlloySmelterBlockEntity
extends BlockEntity
implements MenuProvider {
    private final MGEnergyStorage energyStorage = new MGEnergyStorage(100000, 10000, 0);
    private final ItemStacksResourceHandler fuelHandler = new ItemStacksResourceHandler(1){

        public boolean isValid(int index, ItemResource resource) {
            assert (AlloySmelterBlockEntity.this.level != null);
            return resource.toStack().getBurnTime(RecipeType.BLASTING, AlloySmelterBlockEntity.this.level.fuelValues()) > 0;
        }

        protected void onContentsChanged(int index, ItemStack previousContents) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    private final ItemStacksResourceHandler inputHandler = new ItemStacksResourceHandler(2){

        protected void onContentsChanged(int index, ItemStack previousContents) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    private final ItemStacksResourceHandler outputHandler = new ItemStacksResourceHandler(1){

        public boolean isValid(int index, ItemResource resource) {
            return false;
        }

        protected void onContentsChanged(int index, ItemStack previousContents) {
            AlloySmelterBlockEntity.this.setChanged();
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> AlloySmelterBlockEntity.this.progress;
                case 1 -> AlloySmelterBlockEntity.this.maxProgress;
                case 2 -> AlloySmelterBlockEntity.this.energyStorage.getAmountAsInt();
                case 3 -> AlloySmelterBlockEntity.this.energyStorage.getCapacityAsInt();
                case 4 -> AlloySmelterBlockEntity.this.burnProgress;
                case 5 -> AlloySmelterBlockEntity.this.maxBurnProgress;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    AlloySmelterBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    AlloySmelterBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 5: {
                    AlloySmelterBlockEntity.this.maxBurnProgress = pValue;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int burnProgress = 0;
    private int maxBurnProgress = 0;
    private boolean isBurning = false;

    public AlloySmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super(MGBlockEntities.ALLOY_SMELTER_BE.get(), pos, blockState);
    }

    public MGEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ItemStacksResourceHandler getFuelHandler() {
        return this.fuelHandler;
    }

    public ItemStacksResourceHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStacksResourceHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ContainerData getData() {
        return this.data;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(4);
        inventory.setItem(0, ((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0)));
        inventory.setItem(1, ((ItemResource)this.inputHandler.getResource(1)).toStack(this.inputHandler.getAmountAsInt(1)));
        inventory.setItem(2, ((ItemResource)this.outputHandler.getResource(0)).toStack(this.outputHandler.getAmountAsInt(0)));
        inventory.setItem(3, ((ItemResource)this.fuelHandler.getResource(0)).toStack(this.fuelHandler.getAmountAsInt(0)));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.moregears.alloy_smelter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AlloySmelterMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        this.fuelHandler.serialize(valueOutput.child("fuelHandler"));
        this.inputHandler.serialize(valueOutput.child("inputHandler"));
        this.outputHandler.serialize(valueOutput.child("outputHandler"));
        valueOutput.putInt("energy", this.energyStorage.getAmountAsInt());
        valueOutput.putInt("progress", this.progress);
        valueOutput.putInt("burnProgress", this.burnProgress);
        valueOutput.putInt("maxBurnProgress", this.maxBurnProgress);
        valueOutput.putBoolean("isBurning", this.isBurning);
        super.saveAdditional(valueOutput);
    }

    protected void loadAdditional(ValueInput valueInput) {
        this.fuelHandler.deserialize(valueInput.childOrEmpty("fuelHandler"));
        this.inputHandler.deserialize(valueInput.childOrEmpty("inputHandler"));
        this.outputHandler.deserialize(valueInput.childOrEmpty("outputHandler"));
        this.energyStorage.setEnergy(valueInput.getIntOr("energy", 0));
        this.progress = valueInput.getIntOr("progress", 0);
        this.burnProgress = valueInput.getIntOr("burnProgress", 0);
        this.maxBurnProgress = valueInput.getIntOr("maxBurnProgress", 0);
        this.isBurning = valueInput.getBooleanOr("isBurning", false);
        super.loadAdditional(valueInput);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        this.generateEnergy();
        AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasRecipe() && this.energyStorage.getAmountAsInt() >= 1) {
            this.increaseCraftingProgress();
            this.energyStorage.removeEnergy(10);
            AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
                AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else {
            this.resetProgress();
            AlloySmelterBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private void generateEnergy() {
        assert (this.level != null);
        if (((ItemResource)this.fuelHandler.getResource(0)).toStack().getBurnTime(RecipeType.BLASTING, this.level.fuelValues()) > 0 && !this.isBurning) {
            this.maxBurnProgress = Math.max(((ItemResource)this.fuelHandler.getResource(0)).toStack().getBurnTime(RecipeType.BLASTING, this.level.fuelValues()), 0);
        }
        if (((ItemResource)this.fuelHandler.getResource(0)).toStack().getBurnTime(RecipeType.BLASTING, this.level.fuelValues()) > 0 || this.isBurning && this.energyStorage.getAmountAsInt() < this.energyStorage.getCapacityAsInt()) {
            if (this.burnProgress >= this.maxBurnProgress) {
                this.burnProgress = 0;
                this.isBurning = false;
                return;
            }
            if (this.burnProgress == 0) {
                try (Transaction tx = Transaction.open(null);){
                    if (this.fuelHandler.extract((Resource)((ItemResource)this.fuelHandler.getResource(0)), 1, (TransactionContext)tx) == 1) {
                        tx.commit();
                        this.isBurning = true;
                    }
                }
            }
            this.energyStorage.addEnergy(100);
            ++this.burnProgress;
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<RecipeHolder<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            Transaction tx;
            List<ItemStack> results = ((AlloySmeltingRecipe)recipe.get().value()).output();
            int extractFromSlot0 = 0;
            int extractFromSlot1 = 0;
            for (SizedIngredient ingredient : ((AlloySmeltingRecipe)recipe.get().value()).inputItems()) {
                if (ingredient.test(((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0)))) {
                    extractFromSlot0 += Math.min(this.inputHandler.getAmountAsInt(0), ingredient.count());
                    continue;
                }
                if (!ingredient.test(((ItemResource)this.inputHandler.getResource(1)).toStack(this.inputHandler.getAmountAsInt(1)))) continue;
                extractFromSlot1 += Math.min(this.inputHandler.getAmountAsInt(1), ingredient.count());
            }
            if (extractFromSlot0 > 0) {
                tx = Transaction.open(null);
                try {
                    if (this.inputHandler.extract((Resource)((ItemResource)this.inputHandler.getResource(0)), extractFromSlot0, (TransactionContext)tx) == extractFromSlot0) {
                        tx.commit();
                    }
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            if (extractFromSlot1 > 0) {
                tx = Transaction.open(null);
                try {
                    if (this.inputHandler.extract((Resource)((ItemResource)this.inputHandler.getResource(1)), extractFromSlot1, (TransactionContext)tx) == extractFromSlot1) {
                        tx.commit();
                    }
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            for (ItemStack result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.set(outputSlot, (Resource)ItemResource.of((ItemLike)result.getItem()), this.outputHandler.getAmountAsInt(outputSlot) + result.getCount());
                    continue;
                }
                System.err.println("No suitable output slot found for item: " + String.valueOf(result));
            }
        }
    }

    private int findSuitableOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.size(); ++i) {
            ItemStack stackInSlot = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (!stackInSlot.isEmpty() && (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<AlloySmeltingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        AlloySmeltingRecipe currentRecipe = (AlloySmeltingRecipe)recipe.get().value();
        List<SizedIngredient> recipeIngredients = currentRecipe.inputItems();
        List<ItemStack> outputResults = currentRecipe.output();
        ArrayList<ItemStack> userInputs = new ArrayList<ItemStack>();
        userInputs.add(((ItemResource)this.inputHandler.getResource(0)).toStack(this.inputHandler.getAmountAsInt(0)));
        userInputs.add(((ItemResource)this.inputHandler.getResource(1)).toStack(this.inputHandler.getAmountAsInt(1)));
        for (SizedIngredient recipeIngredient : recipeIngredients) {
            boolean ingredientMatched = false;
            Iterator userInputIterator = userInputs.iterator();
            while (userInputIterator.hasNext()) {
                ItemStack userInput = (ItemStack)userInputIterator.next();
                if (!recipeIngredient.ingredient().test(userInput) || userInput.getCount() < recipeIngredient.count()) continue;
                userInputIterator.remove();
                ingredientMatched = true;
                break;
            }
            if (ingredientMatched) continue;
            return false;
        }
        for (ItemStack result : outputResults) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result.getItem())) continue;
            return false;
        }
        return this.checkSlot(outputResults);
    }

    private boolean checkSlot(List<ItemStack> results) {
        int count = 0;
        int emptyCount = 0;
        for (ItemStack result : results) {
            ++count;
        }
        for (int i = 0; i < this.outputHandler.size(); ++i) {
            ItemStack stackInSlot = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (!stackInSlot.isEmpty()) {
                for (ItemStack result : results) {
                    if (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private Optional<RecipeHolder<AlloySmeltingRecipe>> getCurrentRecipe() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inputHandler.size(); ++i) {
            inputs.add(((ItemResource)this.inputHandler.getResource(i)).toStack(this.inputHandler.getAmountAsInt(i)));
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        assert (serverLevel != null);
        RecipeManager recipeManager = serverLevel.recipeAccess();
        return recipeManager.getRecipeFor((RecipeType)MGRecipes.ALLOY_SMELTING_TYPE.get(), (RecipeInput)new MultipleRecipeInput(inputs), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.size(); ++i) {
            ItemStack stackInSlot = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (!stackInSlot.isEmpty() && (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        for (int i = 0; i < this.outputHandler.size(); ++i) {
            ItemStack stackInSlot = ((ItemResource)this.outputHandler.getResource(i)).toStack(this.outputHandler.getAmountAsInt(i));
            if (!stackInSlot.isEmpty() && stackInSlot.getItem() != item) continue;
            return true;
        }
        return false;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void preRemoveSideEffects(BlockPos p_394577_, BlockState p_394161_) {
        this.drops();
    }
}

