/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.datagen;

import com.coolerpromc.moregears.block.MGBlocks;
import com.coolerpromc.moregears.datagen.builder.AlloySmeltingRecipeBuilder;
import com.coolerpromc.moregears.item.MGItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MGRecipeProvider
extends RecipeProvider {
    private final HolderGetter<Item> items;

    public MGRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
        this.items = lookupProvider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.alloySmeltingRecipe(this.output, SizedIngredient.of((ItemLike)Items.COPPER_INGOT, (int)1), SizedIngredient.of((ItemLike)((ItemLike)MGItems.TIN_INGOT.get()), (int)1), (ItemLike)MGItems.BRONZE_INGOT, 2);
        this.alloySmeltingRecipe(this.output, SizedIngredient.of((ItemLike)Items.IRON_INGOT, (int)1), SizedIngredient.of((ItemLike)Items.COAL, (int)1), (ItemLike)MGItems.STEEL_INGOT, 2);
        this.oreCooking((List<ItemLike>)List.of(MGBlocks.TIN_ORE, MGBlocks.DEEPSLATE_TIN_ORE, MGItems.RAW_TIN), RecipeCategory.TOOLS, (ItemLike)MGItems.TIN_INGOT, 0.7f, 200, "tin_ingot");
        this.oreCooking((List<ItemLike>)List.of(MGBlocks.RUBY_ORE, MGBlocks.DEEPSLATE_RUBY_ORE, MGItems.RAW_RUBY), RecipeCategory.TOOLS, (ItemLike)MGItems.RUBY_INGOT, 0.7f, 200, "ruby");
        this.oreCooking((List<ItemLike>)List.of(MGBlocks.NETHER_TITANIUM_ORE, MGItems.RAW_TITANIUM), RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_INGOT, 1.0f, 200, "titanium_ingot");
        this.oreCooking((List<ItemLike>)List.of(MGBlocks.END_ENDERITE_ORE, MGItems.RAW_ENDERITE), RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_INGOT, 1.0f, 200, "enderite_ingot");
        this.armorSetRecipe(this.output, this.items, (ItemLike)Items.COPPER_INGOT, (ItemLike)MGItems.COPPER_HELMET, (ItemLike)MGItems.COPPER_CHESTPLATE, (ItemLike)MGItems.COPPER_LEGGINGS, (ItemLike)MGItems.COPPER_BOOTS);
        this.toolSetRecipe(this.output, this.items, (ItemLike)Items.COPPER_INGOT, (ItemLike)MGItems.COPPER_SWORD, (ItemLike)MGItems.COPPER_PICKAXE, (ItemLike)MGItems.COPPER_AXE, (ItemLike)MGItems.COPPER_SHOVEL, (ItemLike)MGItems.COPPER_HOE);
        this.armorSetRecipe(this.output, this.items, (ItemLike)MGItems.BRONZE_INGOT, (ItemLike)MGItems.BRONZE_HELMET, (ItemLike)MGItems.BRONZE_CHESTPLATE, (ItemLike)MGItems.BRONZE_LEGGINGS, (ItemLike)MGItems.BRONZE_BOOTS);
        this.toolSetRecipe(this.output, this.items, (ItemLike)MGItems.BRONZE_INGOT, (ItemLike)MGItems.BRONZE_SWORD, (ItemLike)MGItems.BRONZE_PICKAXE, (ItemLike)MGItems.BRONZE_AXE, (ItemLike)MGItems.BRONZE_SHOVEL, (ItemLike)MGItems.BRONZE_HOE);
        this.armorSetRecipe(this.output, this.items, (ItemLike)MGItems.STEEL_INGOT, (ItemLike)MGItems.STEEL_HELMET, (ItemLike)MGItems.STEEL_CHESTPLATE, (ItemLike)MGItems.STEEL_LEGGINGS, (ItemLike)MGItems.STEEL_BOOTS);
        this.toolSetRecipe(this.output, this.items, (ItemLike)MGItems.STEEL_INGOT, (ItemLike)MGItems.STEEL_SWORD, (ItemLike)MGItems.STEEL_PICKAXE, (ItemLike)MGItems.STEEL_AXE, (ItemLike)MGItems.STEEL_SHOVEL, (ItemLike)MGItems.STEEL_HOE);
        this.armorSetRecipe(this.output, this.items, (ItemLike)MGItems.RUBY_INGOT, (ItemLike)MGItems.RUBY_HELMET, (ItemLike)MGItems.RUBY_CHESTPLATE, (ItemLike)MGItems.RUBY_LEGGINGS, (ItemLike)MGItems.RUBY_BOOTS);
        this.toolSetRecipe(this.output, this.items, (ItemLike)MGItems.RUBY_INGOT, (ItemLike)MGItems.RUBY_SWORD, (ItemLike)MGItems.RUBY_PICKAXE, (ItemLike)MGItems.RUBY_AXE, (ItemLike)MGItems.RUBY_SHOVEL, (ItemLike)MGItems.RUBY_HOE);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_HELMET, RecipeCategory.COMBAT, (ItemLike)MGItems.TITANIUM_HELMET);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_CHESTPLATE, RecipeCategory.COMBAT, (ItemLike)MGItems.TITANIUM_CHESTPLATE);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_LEGGINGS, RecipeCategory.COMBAT, (ItemLike)MGItems.TITANIUM_LEGGINGS);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_BOOTS, RecipeCategory.COMBAT, (ItemLike)MGItems.TITANIUM_BOOTS);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_SWORD, RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_SWORD);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_PICKAXE, RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_PICKAXE);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_AXE, RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_AXE);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_SHOVEL, RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_SHOVEL);
        this.titaniumSmithing(this.output, (ItemLike)Items.NETHERITE_HOE, RecipeCategory.TOOLS, (ItemLike)MGItems.TITANIUM_HOE);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_HELMET, RecipeCategory.COMBAT, (ItemLike)MGItems.ENDERITE_HELMET);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_CHESTPLATE, RecipeCategory.COMBAT, (ItemLike)MGItems.ENDERITE_CHESTPLATE);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_LEGGINGS, RecipeCategory.COMBAT, (ItemLike)MGItems.ENDERITE_LEGGINGS);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_BOOTS, RecipeCategory.COMBAT, (ItemLike)MGItems.ENDERITE_BOOTS);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_SWORD, RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_SWORD);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_PICKAXE, RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_PICKAXE);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_AXE, RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_AXE);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_SHOVEL, RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_SHOVEL);
        this.enderiteSmithing(this.output, (ItemLike)MGItems.TITANIUM_HOE, RecipeCategory.TOOLS, (ItemLike)MGItems.ENDERITE_HOE);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('X'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('S'), (ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), MGItems.TITANIUM_INGOT).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.TITANIUM_INGOT), this.has((ItemLike)MGItems.TITANIUM_INGOT)).save(this.output, MGRecipeProvider.getItemName(MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE) + "_from_netherite_smithing_template");
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE, (int)2).define(Character.valueOf('X'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('S'), MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), (ItemLike)Items.BLACKSTONE).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.TITANIUM_INGOT), this.has((ItemLike)MGItems.TITANIUM_INGOT)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('X'), MGItems.TITANIUM_INGOT).define(Character.valueOf('S'), MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), MGItems.ENDERITE_INGOT).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.ENDERITE_INGOT), this.has((ItemLike)MGItems.ENDERITE_INGOT)).save(this.output, MGRecipeProvider.getItemName(MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE) + "_from_titanium_smithing_template");
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE, (int)2).define(Character.valueOf('X'), MGItems.TITANIUM_INGOT).define(Character.valueOf('S'), MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('N'), (ItemLike)Items.END_STONE).pattern("XSX").pattern("XNX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName(MGItems.ENDERITE_INGOT), this.has((ItemLike)MGItems.ENDERITE_INGOT)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, MGBlocks.ALLOY_SMELTER).define(Character.valueOf('X'), (ItemLike)Items.FURNACE).define(Character.valueOf('A'), (ItemLike)Items.DEEPSLATE).define(Character.valueOf('N'), (ItemLike)Items.GUNPOWDER).pattern("XAX").pattern("ANA").pattern("AAA").unlockedBy(MGRecipeProvider.getHasName((ItemLike)Items.FURNACE), this.has((ItemLike)Items.FURNACE)).save(this.output);
        this.arrowRecipe(this.output, (ItemLike)Items.COPPER_INGOT, (ItemLike)MGItems.COPPER_ARROW);
        this.arrowRecipe(this.output, (ItemLike)MGItems.BRONZE_INGOT, (ItemLike)MGItems.BRONZE_ARROW);
        this.arrowRecipe(this.output, (ItemLike)MGItems.STEEL_INGOT, (ItemLike)MGItems.STEEL_ARROW);
        this.arrowRecipe(this.output, (ItemLike)MGItems.RUBY_INGOT, (ItemLike)MGItems.RUBY_ARROW);
        this.arrowRecipe(this.output, (ItemLike)MGItems.TITANIUM_INGOT, (ItemLike)MGItems.TITANIUM_ARROW);
        this.arrowRecipe(this.output, (ItemLike)MGItems.ENDERITE_INGOT, (ItemLike)MGItems.ENDERITE_ARROW);
        this.bowRecipe(this.output, (ItemLike)Items.COPPER_INGOT, (ItemLike)MGItems.COPPER_BOW);
        this.bowRecipe(this.output, (ItemLike)MGItems.BRONZE_INGOT, (ItemLike)MGItems.BRONZE_BOW);
        this.bowRecipe(this.output, (ItemLike)MGItems.STEEL_INGOT, (ItemLike)MGItems.STEEL_BOW);
        this.bowRecipe(this.output, (ItemLike)MGItems.RUBY_INGOT, (ItemLike)MGItems.RUBY_BOW);
        this.bowRecipe(this.output, (ItemLike)MGItems.TITANIUM_INGOT, (ItemLike)MGItems.TITANIUM_BOW);
        this.bowRecipe(this.output, (ItemLike)MGItems.ENDERITE_INGOT, (ItemLike)MGItems.ENDERITE_BOW);
    }

    protected void armorSetRecipe(RecipeOutput output, HolderGetter<Item> items, ItemLike material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('X'), material).pattern("X X").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('X'), material).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
    }

    protected void toolSetRecipe(RecipeOutput output, HolderGetter<Item> items, ItemLike material, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike shovel, ItemLike hoe) {
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XX").pattern(" s").pattern(" s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("X").pattern("s").pattern("s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XX").pattern("Xs").pattern(" s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("XXX").pattern(" s ").pattern(" s ").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
        ShapedRecipeBuilder.shaped(items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)sword).define(Character.valueOf('X'), material).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("X").pattern("X").pattern("s").unlockedBy(MGRecipeProvider.getHasName((ItemLike)material), this.has(material)).save(output);
    }

    protected void titaniumSmithing(RecipeOutput output, ItemLike ingredientItem, RecipeCategory category, ItemLike resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(MGItems.TITANIUM_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)ingredientItem), (Ingredient)Ingredient.of(MGItems.TITANIUM_INGOT), (RecipeCategory)category, (Item)resultItem.asItem()).unlocks("has_titanium_ingot", this.has((ItemLike)MGItems.TITANIUM_INGOT)).save(output, MGRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    protected void enderiteSmithing(RecipeOutput output, ItemLike ingredientItem, RecipeCategory category, ItemLike resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(MGItems.ENDERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)ingredientItem), (Ingredient)Ingredient.of(MGItems.ENDERITE_INGOT), (RecipeCategory)category, (Item)resultItem.asItem()).unlocks("has_enderite_ingot", this.has((ItemLike)MGItems.ENDERITE_INGOT)).save(output, MGRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    protected void oreCooking(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
        this.oreCooking(RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_blasting");
    }

    protected void alloySmeltingRecipe(RecipeOutput output, SizedIngredient ingredients1, SizedIngredient ingredients2, ItemLike result, int outputCount) {
        AlloySmeltingRecipeBuilder.alloySmeltingRecipe().addIngredient(ingredients1).addIngredient(ingredients2).addOutput(new ItemStack(result, outputCount)).unlockedBy(MGRecipeProvider.getHasName((ItemLike)((ItemLike)ingredients1.ingredient().getValues().get(0).value())), this.has((ItemLike)ingredients1.ingredient().getValues().get(0).value())).save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moregears", (String)("alloy_smelting/" + MGRecipeProvider.getItemName((ItemLike)result) + "_from_alloy_smelting"))));
    }

    protected void arrowRecipe(RecipeOutput output, ItemLike ingot, ItemLike outputItem) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)outputItem, (int)6).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ingot).define(Character.valueOf('Y'), (ItemLike)Items.FEATHER).pattern("X").pattern("#").pattern("Y").unlockedBy(MGRecipeProvider.getHasName((ItemLike)ingot), this.has(ingot)).save(output);
    }

    protected void bowRecipe(RecipeOutput output, ItemLike ingot, ItemLike outputItem) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)outputItem).define(Character.valueOf('#'), ingot).define(Character.valueOf('X'), (ItemLike)Items.STRING).pattern(" #X").pattern("# X").pattern(" #X").unlockedBy(MGRecipeProvider.getHasName((ItemLike)ingot), this.has(ingot)).save(this.output);
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new MGRecipeProvider(lookupProvider, output);
        }

        public String getName() {
            return "ProductiveSlimes recipes";
        }
    }
}

