/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.moregears.item.custom;

import com.coolerpromc.moregears.item.custom.MGArrowEntity;
import com.mojang.serialization.Codec;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MGArrowItem
extends ArrowItem {
    private final double baseDamage;
    private final EntityType<? extends AbstractArrow> entityType;

    public MGArrowItem(Item.Properties p_40512_, double baseDamage, EntityType<? extends AbstractArrow> entityType) {
        super(p_40512_);
        this.baseDamage = baseDamage;
        this.entityType = entityType;
    }

    public AbstractArrow createArrow(Level level, ItemStack ammo, LivingEntity shooter, @Nullable ItemStack weapon) {
        return new MGArrowEntity(this.entityType, shooter, level, ammo.copyWithCount(1), weapon, this.baseDamage);
    }

    public boolean isInfinite(ItemStack ammo, ItemStack bow, LivingEntity livingEntity) {
        return bow.getEnchantmentLevel((Holder)livingEntity.level().registryAccess().getOrThrow(Enchantments.INFINITY)) > 0;
    }

    public Projectile asProjectile(Level level, Position location, ItemStack stack, Direction p_338469_) {
        MGArrowEntity arrow = new MGArrowEntity(this.entityType, location.x(), location.y(), location.z(), level, stack.copyWithCount(1), null);
        arrow.setBaseDamage(this.baseDamage);
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        return arrow;
    }

    public static enum MGArrowType implements StringRepresentable
    {
        COPPER("copper"),
        BRONZE("bronze"),
        STEEL("steel"),
        RUBY("ruby"),
        TITANIUM("titanium"),
        ENDERITE("enderite");

        public static final Codec<MGArrowType> CODEC;
        private final String name;

        private MGArrowType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MGArrowType::values);
        }
    }
}

