/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.api.server.TranslationUtil;
import dev.anvilcraft.rg.server.ServerPlusPlusServerRules;
import dev.anvilcraft.rg.server.commands.WlistCommand;
import dev.anvilcraft.rg.tools.FilesUtil;
import dev.anvilcraft.rg.tools.ModCommands;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import org.jetbrains.annotations.NotNull;

public class BlistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.ban.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.pardon.failed"));
    public static final FilesUtil.MapFile<String, Boolean> PERMISSION = new FilesUtil.MapFile("blist", Object::toString, Boolean.class);

    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, (String)"blist").requires(stack -> RGValidator.CommandRuleValidator.hasPermission(() -> ServerPlusPlusServerRules.commandBlist, (CommandSourceStack)stack) && WlistCommand.hasPermission(PERMISSION, stack))).executes(BlistCommand::list)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permission").requires(stack -> stack.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(BlistCommand::permissionAdd)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(BlistCommand::permissionRemove))))).then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(BlistCommand::add)).then(Commands.argument((String)"reson", (ArgumentType)StringArgumentType.greedyString()).executes(BlistCommand::add))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getBans().getUserList(), (SuggestionsBuilder)suggestionsBuilder)).executes(BlistCommand::remove))));
    }

    public static int add(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UserBanList userBanList = source.getServer().getPlayerList().getBans();
        int i = 0;
        MutableComponent component = null;
        try {
            component = Component.literal((String)StringArgumentType.getString(context, (String)"reson"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (GameProfile gameProfile : GameProfileArgument.getGameProfiles(context, (String)"targets")) {
            if (userBanList.isBanned(gameProfile)) continue;
            UserBanListEntry userBanListEntry = new UserBanListEntry(gameProfile, null, source.getTextName(), null, component == null ? null : component.getString());
            userBanList.add((StoredUserEntry)userBanListEntry);
            ++i;
            source.sendSuccess(() -> Component.translatable((String)"commands.ban.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName()), userBanListEntry.getReason()}), true);
            ServerPlayer serverPlayer = source.getServer().getPlayerList().getPlayer(gameProfile.getId());
            if (serverPlayer == null) continue;
            serverPlayer.connection.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.banned"));
        }
        if (i == 0) {
            throw ERROR_ALREADY_BANNED.create();
        }
        return i;
    }

    public static int remove(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UserBanList userBanList = source.getServer().getPlayerList().getBans();
        int i = 0;
        for (GameProfile gameProfile : GameProfileArgument.getGameProfiles(context, (String)"targets")) {
            if (!userBanList.isBanned(gameProfile)) continue;
            userBanList.remove((Object)gameProfile);
            ++i;
            source.sendSuccess(() -> Component.translatable((String)"commands.pardon.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName())}), true);
        }
        if (i == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return i;
    }

    public static int list(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection collection = source.getServer().getPlayerList().getBans().getEntries();
        if (collection.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.banlist.none"), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.banlist.list", (Object[])new Object[]{collection.size()}), false);
            for (UserBanListEntry userBanListEntry : collection) {
                source.sendSuccess(() -> Component.translatable((String)"commands.banlist.entry", (Object[])new Object[]{userBanListEntry.getDisplayName(), userBanListEntry.getSource(), userBanListEntry.getReason()}), false);
            }
        }
        return collection.size();
    }

    private static int permissionAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        int i = 0;
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile target : targets) {
            BlistCommand.PERMISSION.map.put(target.getId().toString(), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_blist.message.granted_permission", (Object[])new Object[]{target.getName()}), true);
            ++i;
        }
        ModCommands.notifyPlayersCommandsChanged((MinecraftServer)((CommandSourceStack)context.getSource()).getServer());
        PERMISSION.save();
        return i;
    }

    private static int permissionRemove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        int i = 0;
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile target : targets) {
            BlistCommand.PERMISSION.map.put(target.getId().toString(), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_blist.message.revoked_permission", (Object[])new Object[]{target.getName()}), true);
            ++i;
        }
        ModCommands.notifyPlayersCommandsChanged((MinecraftServer)((CommandSourceStack)context.getSource()).getServer());
        PERMISSION.save();
        return i;
    }
}

