/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.commands;

import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.api.server.TranslationUtil;
import dev.anvilcraft.rg.server.ServerPlusPlusServerRules;
import dev.anvilcraft.rg.tools.FilesUtil;
import dev.anvilcraft.rg.tools.IdGenerator;
import dev.anvilcraft.rg.tools.ModCommands;
import dev.anvilcraft.rg.tools.PosUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LocCommand {
    public static final FilesUtil.MapFile<Long, LocPoint> LOC_POINT = new FilesUtil.MapFile("loc", Long::decode, LocPoint.class);

    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, (String)"loc").requires(stack -> RGValidator.CommandRuleValidator.hasPermission(() -> ServerPlusPlusServerRules.commandLoc, (CommandSourceStack)stack))).executes(LocCommand::list)).then(Commands.literal((String)"add").then(Commands.argument((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(LocCommand::add)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(LocCommand::suggestId).executes(LocCommand::remove)))).then(Commands.literal((String)"info").then(Commands.argument((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(LocCommand::suggestId).executes(LocCommand::info)))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(LocCommand::list)).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(LocCommand::list))));
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestId(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(LocCommand.LOC_POINT.map.keySet().stream().map(Object::toString), (SuggestionsBuilder)builder);
    }

    public static int add(CommandContext<CommandSourceStack> context) {
        LOC_POINT.init(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        long id = IdGenerator.nextId();
        String desc = StringArgumentType.getString(context, (String)"desc");
        Vec3 pos = source.getPosition();
        ResourceKey dim = source.getLevel().dimension();
        LocCommand.LOC_POINT.map.put(id, new LocPoint(id, desc, pos.x, pos.y, pos.z, (ResourceKey<Level>)dim));
        LOC_POINT.save();
        source.sendSuccess(() -> TranslationUtil.trans((String)"command_loc.message.added", (Object[])new Object[]{desc}), false);
        return 1;
    }

    public static int remove(CommandContext<CommandSourceStack> context) {
        LOC_POINT.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        LocPoint remove = (LocPoint)LocCommand.LOC_POINT.map.remove(id);
        if (remove == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_loc.message.no_such_id", (Object[])new Object[]{id}));
            return 0;
        }
        LOC_POINT.save();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_loc.message.removed", (Object[])new Object[]{remove.desc}), false);
        return 1;
    }

    public static int list(CommandContext<CommandSourceStack> context) {
        int page;
        LOC_POINT.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = LocCommand.LOC_POINT.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_loc.message.no_such_page", (Object[])new Object[]{page}));
            return 0;
        }
        LocPoint[] locPoints = LocCommand.LOC_POINT.map.values().toArray(new LocPoint[0]);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TranslationUtil.trans((String)"command_loc.message.page_title", (Object[])new Object[]{page, maxPage}).withStyle(ChatFormatting.YELLOW));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)LocCommand.locToComponent(locPoints[i]));
        }
        MutableComponent prevPage = page <= 1 ? Component.literal((String)"<<<").withStyle(ChatFormatting.GRAY) : Component.literal((String)"<<<").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/loc list " + (page - 1))));
        MutableComponent nextPage = page >= maxPage ? Component.literal((String)">>>").withStyle(ChatFormatting.GRAY) : Component.literal((String)">>>").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/loc list " + (page + 1))));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"=======").withStyle(ChatFormatting.YELLOW).append(" ").append((Component)prevPage).append(" ").append((Component)TranslationUtil.trans((String)"command_loc.message.page_footer", (Object[])new Object[]{page, maxPage}).withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)nextPage).append(" ").append((Component)Component.literal((String)"=======").withStyle(ChatFormatting.YELLOW)));
        return 1;
    }

    @NotNull
    private static MutableComponent locToComponent(@NotNull LocPoint locPoint) {
        MutableComponent component = Component.literal((String)locPoint.desc).withStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)Long.toString(locPoint.id)))));
        List pos = PosUtils.pos((String)locPoint.desc, (double)locPoint.x, (double)locPoint.y, (double)locPoint.z, locPoint.dimType);
        MutableComponent info = Component.literal((String)"[i]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.YELLOW).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans((String)"command_loc.message.info", (Object[])new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/loc info %s".formatted(locPoint.id))));
        MutableComponent remove = Component.literal((String)"[\ud83d\uddd1]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.RED).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans((String)"command_loc.message.remove", (Object[])new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/loc remove %s".formatted(locPoint.id))));
        return Component.literal((String)"\u25b6 ").append((Component)component).append(" ").append((Component)pos.getFirst()).append(" ").append((Component)info).append(" ").append((Component)remove);
    }

    public static int info(CommandContext<CommandSourceStack> context) {
        LOC_POINT.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        LocPoint point = LocCommand.LOC_POINT.map.getOrDefault(id, null);
        if (point == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_loc.message.no_such_id", (Object[])new Object[]{id}));
            return 0;
        }
        for (Component component : LocCommand.info(point)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
        }
        return 1;
    }

    @NotNull
    public static List<Component> info(@NotNull LocPoint point) {
        MutableComponent desc = Component.literal((String)point.desc);
        MutableComponent dimType = point.dimType == Level.NETHER ? Component.translatableWithFallback((String)"advancements.nether.root.title", (String)point.dimType.location().toString()) : (point.dimType == Level.END ? Component.translatableWithFallback((String)"advancements.end.root.title", (String)point.dimType.location().toString()) : (point.dimType == Level.OVERWORLD ? Component.translatableWithFallback((String)"flat_world_preset.minecraft.overworld", (String)point.dimType.location().toString()) : Component.literal((String)point.dimType.location().toString())));
        List pos = PosUtils.pos((String)point.desc, (double)point.x, (double)point.y, (double)point.z, point.dimType);
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)Component.literal((String)"==================").withStyle(ChatFormatting.YELLOW));
        result.add((Component)TranslationUtil.trans((String)"command_loc.message.loc_point", (Object[])new Object[0]).append((Component)desc));
        result.add((Component)TranslationUtil.trans((String)"command_loc.message.dimension", (Object[])new Object[0]).append((Component)dimType));
        if (!pos.isEmpty()) {
            result.add((Component)TranslationUtil.trans((String)"command_loc.message.position", (Object[])new Object[0]).append((Component)pos.get(0)));
        }
        if (pos.size() > 1) {
            result.add((Component)pos.get(1));
        }
        if (pos.size() > 2) {
            result.add((Component)TranslationUtil.trans((String)"command_loc.message.transform_position", (Object[])new Object[0]).append((Component)pos.get(2)));
        }
        if (pos.size() > 3) {
            result.add((Component)pos.get(3));
        }
        result.add((Component)Component.literal((String)"==================").withStyle(ChatFormatting.YELLOW));
        return result;
    }

    public record LocPoint(long id, String desc, double x, double y, double z, @SerializedName(value="dim_type") ResourceKey<Level> dimType) {
    }
}

