/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.server.ServerPlusPlusServerRules;
import dev.anvilcraft.rg.tools.ModCommands;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.jetbrains.annotations.NotNull;

public class SopCommand {
    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, (String)"sop").requires(stack -> RGValidator.CommandRuleValidator.hasPermission(() -> ServerPlusPlusServerRules.commandSop, (CommandSourceStack)stack))).executes(SopCommand::sop));
    }

    public static int sop(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            return 0;
        }
        PlayerList playerList = source.getServer().getPlayerList();
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        GameProfile gameProfile = player.getGameProfile();
        if (!playerList.isOp(gameProfile)) {
            playerList.op(gameProfile);
            source.sendSuccess(() -> Component.translatable((String)"commands.op.success", (Object[])new Object[]{gameProfile.getName()}), true);
        }
        return 1;
    }
}

