/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.api.server.TranslationUtil;
import dev.anvilcraft.rg.server.ServerPlusPlusServerRules;
import dev.anvilcraft.rg.tools.FilesUtil;
import dev.anvilcraft.rg.tools.IdGenerator;
import dev.anvilcraft.rg.tools.ModCommands;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class TodoCommand {
    public static final FilesUtil.MapFile<Long, Todo> TODO = new FilesUtil.MapFile("todo", Long::decode, Todo.class);

    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, (String)"todo").requires(stack -> RGValidator.CommandRuleValidator.hasPermission(() -> ServerPlusPlusServerRules.commandTodo, (CommandSourceStack)stack))).executes(TodoCommand::list)).then(Commands.literal((String)"add").then(Commands.argument((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(TodoCommand::add)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(TodoCommand::suggestId).executes(TodoCommand::remove)))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(TodoCommand::list)).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TodoCommand::list)))).then(Commands.literal((String)"success").then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(TodoCommand::suggestId).executes(TodoCommand::success)).then(Commands.argument((String)"success", (ArgumentType)BoolArgumentType.bool()).executes(TodoCommand::success)))));
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestId(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(TodoCommand.TODO.map.keySet().stream().map(Object::toString), (SuggestionsBuilder)builder);
    }

    public static int add(CommandContext<CommandSourceStack> context) {
        TODO.init(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        long id = IdGenerator.nextId();
        String desc = StringArgumentType.getString(context, (String)"desc");
        TodoCommand.TODO.map.put(id, new Todo(id, desc, false));
        TODO.save();
        source.sendSuccess(() -> TranslationUtil.trans((String)"command_todo.message.added", (Object[])new Object[]{desc}), false);
        return 1;
    }

    public static int remove(CommandContext<CommandSourceStack> context) {
        TODO.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        Todo todo = (Todo)TodoCommand.TODO.map.remove(id);
        if (todo == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_todo.message.no_such_id", (Object[])new Object[]{id}));
            return 0;
        }
        TODO.save();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_todo.message.removed", (Object[])new Object[]{todo.desc}), false);
        return 1;
    }

    public static int success(CommandContext<CommandSourceStack> context) {
        boolean success;
        TODO.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        try {
            success = BoolArgumentType.getBool(context, (String)"success");
        }
        catch (IllegalArgumentException ignored) {
            success = true;
        }
        Todo todo = (Todo)TodoCommand.TODO.map.get(id);
        if (todo == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_todo.message.no_such_id", (Object[])new Object[]{id}));
            return 0;
        }
        todo.success = success;
        TODO.save();
        boolean finalSuccess = success;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_todo.message.success", (Object[])new Object[]{todo.desc, finalSuccess ? TranslationUtil.trans((String)"command_todo.message.done", (Object[])new Object[0]) : TranslationUtil.trans((String)"command_todo.message.undone", (Object[])new Object[0])}), false);
        return 1;
    }

    public static int list(CommandContext<CommandSourceStack> context) {
        int page;
        TODO.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = TodoCommand.TODO.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans((String)"command_todo.message.no_such_page", (Object[])new Object[]{page}));
            return 0;
        }
        Todo[] todos = TodoCommand.TODO.map.values().toArray(new Todo[0]);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TranslationUtil.trans((String)"command_todo.message.page_title", (Object[])new Object[]{page, maxPage}).withStyle(ChatFormatting.YELLOW));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TodoCommand.TodoToComponent(todos[i]));
        }
        MutableComponent prevPage = page <= 1 ? Component.literal((String)"<<<").withStyle(ChatFormatting.GRAY) : Component.literal((String)"<<<").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/todo list " + (page - 1))));
        MutableComponent nextPage = page >= maxPage ? Component.literal((String)">>>").withStyle(ChatFormatting.GRAY) : Component.literal((String)">>>").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/todo list " + (page + 1))));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"=======").withStyle(ChatFormatting.YELLOW).append(" ").append((Component)prevPage).append(" ").append((Component)TranslationUtil.trans((String)"command_todo.message.page_footer", (Object[])new Object[]{page, maxPage}).withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)nextPage).append(" ").append((Component)Component.literal((String)"=======").withStyle(ChatFormatting.YELLOW)));
        return 1;
    }

    @NotNull
    private static MutableComponent TodoToComponent(@NotNull Todo todo) {
        MutableComponent component = Component.literal((String)todo.desc).withStyle(Style.EMPTY.withStrikethrough(Boolean.valueOf(todo.success)).applyFormat(ChatFormatting.GRAY).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)Long.toString(todo.id)))));
        MutableComponent success = Component.literal((String)"[\u2714]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans((String)"command_todo.message.make_done", (Object[])new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/todo success %s".formatted(todo.id))));
        MutableComponent unSuccess = Component.literal((String)"[\u274c]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.RED).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans((String)"command_todo.message.make_undone", (Object[])new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/todo success %s false".formatted(todo.id))));
        MutableComponent remove = Component.literal((String)"[\ud83d\uddd1]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.RED).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans((String)"command_todo.message.remove", (Object[])new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/todo remove %s".formatted(todo.id))));
        return Component.literal((String)(todo.success ? "\u2611" : "\u2610")).append(" ").append((Component)component).append(" ").append((Component)(todo.success ? unSuccess : success)).append(" ").append((Component)remove);
    }

    public static class Todo {
        public final Long id;
        public final String desc;
        public boolean success;

        Todo(Long id, String desc, boolean success) {
            this.id = id;
            this.desc = desc;
            this.success = success;
        }
    }
}

