/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.api.server.TranslationUtil;
import dev.anvilcraft.rg.server.ServerPlusPlusServerRules;
import dev.anvilcraft.rg.tools.FilesUtil;
import dev.anvilcraft.rg.tools.ModCommands;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import org.jetbrains.annotations.NotNull;

public class WlistCommand {
    public static final FilesUtil.MapFile<String, Boolean> PERMISSION = new FilesUtil.MapFile("wlist", Object::toString, Boolean.class);
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.whitelist.remove.failed"));

    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, (String)"wlist").requires(stack -> RGValidator.CommandRuleValidator.hasPermission(() -> ServerPlusPlusServerRules.commandWlist, (CommandSourceStack)stack) && WlistCommand.hasPermission(PERMISSION, stack))).executes(WlistCommand::list)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permission").requires(stack -> stack.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(WlistCommand::permissionAdd)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(WlistCommand::permissionRemove))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> {
            PlayerList playerList = ((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerList.getPlayers().stream().filter(serverPlayer -> !playerList.getWhiteList().isWhiteListed(serverPlayer.getGameProfile())).map(serverPlayer -> serverPlayer.getGameProfile().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(WlistCommand::add)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getWhiteListNames(), (SuggestionsBuilder)suggestionsBuilder)).executes(WlistCommand::remove))));
    }

    public static int add(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UserWhiteList userWhiteList = source.getServer().getPlayerList().getWhiteList();
        int i = 0;
        for (GameProfile gameProfile : GameProfileArgument.getGameProfiles(context, (String)"targets")) {
            if (userWhiteList.isWhiteListed(gameProfile)) continue;
            UserWhiteListEntry userWhiteListEntry = new UserWhiteListEntry(gameProfile);
            userWhiteList.add((StoredUserEntry)userWhiteListEntry);
            ++i;
            source.sendSuccess(() -> Component.translatable((String)"commands.whitelist.add.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName())}), true);
        }
        if (i == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return i;
    }

    public static int remove(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UserWhiteList userWhiteList = source.getServer().getPlayerList().getWhiteList();
        int i = 0;
        for (GameProfile gameProfile : GameProfileArgument.getGameProfiles(context, (String)"targets")) {
            if (!userWhiteList.isWhiteListed(gameProfile)) continue;
            UserWhiteListEntry userWhiteListEntry = new UserWhiteListEntry(gameProfile);
            userWhiteList.remove((StoredUserEntry)userWhiteListEntry);
            ++i;
            source.sendSuccess(() -> Component.translatable((String)"commands.whitelist.remove.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName())}), true);
        }
        if (i == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        source.getServer().kickUnlistedPlayers(source);
        return i;
    }

    public static int list(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String[] strings = source.getServer().getPlayerList().getWhiteListNames();
        if (strings.length == 0) {
            source.sendSuccess(() -> Component.translatable((String)"commands.whitelist.none"), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.whitelist.list", (Object[])new Object[]{strings.length, String.join((CharSequence)", ", strings)}), false);
        }
        return strings.length;
    }

    public static boolean hasPermission(FilesUtil.MapFile<String, Boolean> permission, @NotNull CommandSourceStack stack) {
        if (stack.hasPermission(2)) {
            return true;
        }
        if (stack.isPlayer()) {
            ServerPlayer player = stack.getPlayer();
            if (player == null) {
                return false;
            }
            return permission.map.getOrDefault(player.getGameProfile().getId().toString(), false);
        }
        return true;
    }

    private static int permissionAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        int i = 0;
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile target : targets) {
            WlistCommand.PERMISSION.map.put(target.getId().toString(), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_wlist.message.granted_permission", (Object[])new Object[]{target.getName()}), true);
            ++i;
        }
        ModCommands.notifyPlayersCommandsChanged((MinecraftServer)((CommandSourceStack)context.getSource()).getServer());
        PERMISSION.save();
        return i;
    }

    private static int permissionRemove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        int i = 0;
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile target : targets) {
            WlistCommand.PERMISSION.map.put(target.getId().toString(), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans((String)"command_wlist.message.revoked_permission", (Object[])new Object[]{target.getName()}), true);
            ++i;
        }
        ModCommands.notifyPlayersCommandsChanged((MinecraftServer)((CommandSourceStack)context.getSource()).getServer());
        PERMISSION.save();
        return i;
    }
}

